/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.rooms.laundry;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.rooms.laundry.WashingMachineInventory;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.jetbrains.annotations.NotNull;

public class WashingMachineListener
extends TARDISMenuListener {
    private final Set<Material> DYEABLE = new HashSet<Material>();

    public WashingMachineListener(TARDIS plugin) {
        super(plugin);
        this.DYEABLE.addAll(Tag.WOOL.getValues());
        this.DYEABLE.addAll(Tag.WOOL_CARPETS.getValues());
        this.DYEABLE.addAll(Tag.ITEMS_DYEABLE.getValues());
    }

    @EventHandler
    public void onArchitecturalBlueprintClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof WashingMachineInventory)) {
            return;
        }
        int slot = event.getRawSlot();
        if (slot < 0 || slot > 26) {
            ClickType click = event.getClick();
            if (click.equals((Object)ClickType.SHIFT_RIGHT) || click.equals((Object)ClickType.SHIFT_LEFT) || click.equals((Object)ClickType.DOUBLE_CLICK)) {
                event.setCancelled(true);
            }
            return;
        }
        event.setCancelled(slot > 17);
        Player player = (Player)event.getWhoClicked();
        InventoryView view = event.getView();
        switch (slot) {
            case 21: {
                this.processTrims(view);
                break;
            }
            case 23: {
                this.processDyed(view);
                break;
            }
            case 26: {
                this.close(player);
                break;
            }
        }
    }

    private void processTrims(InventoryView view) {
        for (int i = 0; i < 9; ++i) {
            Material material;
            ItemStack armour = view.getItem(i);
            if (armour == null || !Tag.ITEMS_TRIMMABLE_ARMOR.isTagged((Keyed)(material = armour.getType()))) continue;
            ArmorMeta meta = (ArmorMeta)armour.getItemMeta();
            ArmorTrim trim = meta.getTrim();
            TrimPattern tp = trim.getPattern();
            NamespacedKey key = RegistryAccess.registryAccess().getRegistry(RegistryKey.TRIM_PATTERN).getKey((Keyed)tp);
            ItemStack template = ItemStack.of((Material)this.getTemplate(key));
            view.setItem(i + 9, template);
            meta.setTrim(null);
            armour.setItemMeta((ItemMeta)meta);
            view.setItem(i, armour);
        }
    }

    @NotNull
    private Material getTemplate(NamespacedKey key) {
        String which = key.getKey().toUpperCase(Locale.ROOT);
        try {
            return Material.valueOf((String)(which + "_ARMOR_TRIM_SMITHING_TEMPLATE"));
        }
        catch (IllegalArgumentException e) {
            return Material.WILD_ARMOR_TRIM_SMITHING_TEMPLATE;
        }
    }

    private void processDyed(InventoryView view) {
        for (int i = 0; i < 9; ++i) {
            Material material;
            ItemStack dyed = view.getItem(i);
            if (dyed == null || !this.DYEABLE.contains(material = dyed.getType())) continue;
            ItemMeta im = dyed.getItemMeta();
            if (im instanceof LeatherArmorMeta) {
                LeatherArmorMeta armorMeta = (LeatherArmorMeta)im;
                armorMeta.setColor(null);
                dyed.setItemMeta((ItemMeta)armorMeta);
                view.setItem(i, dyed);
                continue;
            }
            ItemStack bleached = switch (dyed.getType()) {
                case Material.ORANGE_WOOL, Material.MAGENTA_WOOL, Material.LIGHT_BLUE_WOOL, Material.LIGHT_GRAY_WOOL, Material.YELLOW_WOOL, Material.LIME_WOOL, Material.PINK_WOOL, Material.CYAN_WOOL, Material.PURPLE_WOOL, Material.BLUE_WOOL, Material.BROWN_WOOL, Material.GRAY_WOOL, Material.GREEN_WOOL, Material.RED_WOOL, Material.BLACK_WOOL -> ItemStack.of((Material)Material.WHITE_WOOL, (int)dyed.getAmount());
                default -> ItemStack.of((Material)Material.WHITE_CARPET, (int)dyed.getAmount());
            };
            view.setItem(i, bleached);
        }
    }
}

