/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.rooms;

import com.google.gson.JsonObject;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.DamageUtility;
import me.eccentric_nz.TARDIS.api.event.TARDISRoomGrowEvent;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.DiskCircuit;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.rooms.RoomData;
import me.eccentric_nz.TARDIS.rooms.RoomRunnable;
import me.eccentric_nz.TARDIS.schematic.SchematicGZip;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class StaircaseBuilder {
    private final TARDIS plugin;
    private final Location location;
    private final Player player;
    private final boolean isUp;

    public StaircaseBuilder(TARDIS plugin, Location location, Player player, boolean isUp) {
        this.plugin = plugin;
        this.location = location;
        this.player = player;
        this.isUp = isUp;
    }

    public boolean build() {
        ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
        if (rs.fromUUID(this.player.getUniqueId().toString())) {
            RoomData roomData = new RoomData();
            roomData.setTardis_id(rs.getTardisId());
            roomData.setMiddleType(Material.ORANGE_WOOL);
            roomData.setFloorType(Material.LIGHT_GRAY_WOOL);
            roomData.setDirection(COMPASS.SOUTH);
            JsonObject obj = SchematicGZip.getObject(this.plugin, "rooms", "staircase", false);
            if (obj == null) {
                return false;
            }
            roomData.setLocation(this.location);
            roomData.setRoom("STAIRCASE");
            roomData.setSchematic(obj);
            this.plugin.getTrackerKeeper().getIsStackedStaircase().put(rs.getTardisId(), this.isUp);
            long delay = Math.round(20.0 / this.plugin.getConfig().getDouble("growth.room_speed"));
            this.plugin.getPM().callEvent((Event)new TARDISRoomGrowEvent(this.player, null, null, roomData));
            RoomRunnable runnable = new RoomRunnable(this.plugin, roomData, this.player.getUniqueId());
            int taskID = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)runnable, delay, delay);
            runnable.setTask(taskID);
            this.plugin.getTrackerKeeper().getRoomTasks().put(taskID, roomData);
            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "ROOM_CANCEL", String.format("%d", taskID));
            DamageUtility.run(this.plugin, DiskCircuit.ARS, rs.getTardisId(), this.player);
        }
        return true;
    }
}

