/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.playerprefs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.console.ConsoleInteraction;
import me.eccentric_nz.TARDIS.custommodels.GUIChameleonPresets;
import me.eccentric_nz.TARDIS.custommodels.GUIPlayerPreferences;
import me.eccentric_nz.TARDIS.custommodels.GUIWeather;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetConsoleLabel;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.HADS;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.bukkit.persistence.PersistentDataType;

public class TARDISGeneralPrefsInventory
implements InventoryHolder {
    private final TARDIS plugin;
    private final UUID uuid;
    private final Inventory inventory;

    public TARDISGeneralPrefsInventory(TARDIS plugin, UUID uuid) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 36, (Component)Component.text((String)"Player Prefs Menu", (TextColor)NamedTextColor.DARK_RED));
        this.inventory.setContents(this.getItemStack());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack[] getItemStack() {
        ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, this.uuid.toString());
        ArrayList<Boolean> values = new ArrayList<Boolean>();
        if (!rsp.resultSet()) {
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("uuid", this.uuid.toString());
            this.plugin.getQueryFactory().doSyncInsert("player_prefs", set);
            rsp = new ResultSetPlayerPrefs(this.plugin, this.uuid.toString());
            rsp.resultSet();
        }
        Player player = this.plugin.getServer().getPlayer(this.uuid);
        values.add(rsp.isAnnounceRepeatersOn());
        values.add(rsp.isAutoOn());
        values.add(rsp.isAutoRescueOn());
        values.add(rsp.isTravelbarOn());
        values.add(rsp.isBeaconOn());
        values.add(rsp.isBuildOn());
        values.add(rsp.isDialogsOn());
        values.add(rsp.isDND());
        values.add(rsp.isOpenDisplayDoorOn());
        values.add(rsp.isDynamicLightsOn());
        values.add(rsp.isEpsOn());
        values.add(rsp.isFarmOn());
        values.add(this.plugin.getTrackerKeeper().getActiveForceFields().containsKey(this.uuid));
        values.add(rsp.isCloseGUIOn());
        values.add(rsp.isHadsOn());
        values.add(rsp.getHadsType().equals((Object)HADS.DISPERSAL));
        values.add(rsp.isInfoOn());
        Tardis tardis = null;
        HashMap<String, Object> wherep = new HashMap<String, Object>();
        wherep.put("uuid", this.uuid.toString());
        ResultSetTardis rst = new ResultSetTardis(this.plugin, wherep, "", false);
        boolean hasTARDIS = rst.resultSet();
        if (hasTARDIS) {
            tardis = rst.getTardis();
            values.add(tardis.isIsomorphicOn());
            values.add(rst.getTardis().getPreset().equals((Object)ChameleonPreset.JUNK_MODE));
            ResultSetConsoleLabel rs = new ResultSetConsoleLabel(this.plugin, tardis.getTardisId());
            if (rs.resultSet()) {
                boolean hasLabels = this.hasLabels(rs.getLocation());
                values.add(hasLabels);
            } else {
                values.add(false);
            }
        } else {
            values.add(false);
            values.add(false);
            values.add(false);
        }
        if (this.plugin.isWorldGuardOnServer()) {
            String chunk = tardis != null ? rst.getTardis().getChunk() : "TARDIS_TimeVortex:1";
            String[] split = chunk.split(":");
            World world = this.plugin.getServer().getWorld(split[0]);
            values.add(!this.plugin.getWorldGuardUtils().queryContainers(world, player.getName()));
        } else {
            values.add(false);
        }
        values.add(rsp.isMinecartOn());
        values.add(rsp.isAutoPowerUp());
        values.add(rsp.isQuotesOn());
        values.add(rsp.isRendererOn());
        values.add(rsp.isAutoSiegeOn());
        values.add(rsp.isSignOn());
        values.add(rsp.isSfxOn());
        values.add(rsp.isSubmarineOn());
        values.add(rsp.isTelepathyOn());
        ItemStack[] stack = new ItemStack[36];
        for (GUIPlayerPreferences pref : GUIPlayerPreferences.values()) {
            if (pref.getMaterial() != Material.REPEATER) continue;
            ItemStack is = ItemStack.of((Material)pref.getMaterial(), (int)1);
            ItemMeta im = is.getItemMeta();
            im.displayName((Component)Component.text((String)pref.getName()));
            boolean v = (Boolean)values.get(pref.getSlot());
            if (pref.getOffFloats() != null) {
                CustomModelDataComponent component = im.getCustomModelDataComponent();
                component.setFloats(v ? pref.getOnFloats() : pref.getOffFloats());
                im.setCustomModelDataComponent(component);
            }
            if (pref == GUIPlayerPreferences.HADS_TYPE) {
                im.lore(List.of(Component.text((String)(v ? "DISPERSAL" : "DISPLACEMENT"))));
            } else {
                im.lore(List.of(Component.text((String)(v ? this.plugin.getLanguage().getString("SET_ON", "ON") : this.plugin.getLanguage().getString("SET_OFF", "OFF")))));
            }
            is.setItemMeta(im);
            stack[pref.getSlot()] = is;
        }
        if (!this.plugin.isWorldGuardOnServer()) {
            stack[GUIPlayerPreferences.LOCK_CONTAINERS.getSlot()] = null;
        }
        ItemStack back = ItemStack.of((Material)GUIChameleonPresets.BACK.material(), (int)1);
        ItemMeta but = back.getItemMeta();
        but.displayName((Component)Component.text((String)"Back"));
        back.setItemMeta(but);
        stack[33] = back;
        ItemStack close = ItemStack.of((Material)GUIWeather.CLOSE.material(), (int)1);
        ItemMeta can = close.getItemMeta();
        can.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_CLOSE", "Close")));
        close.setItemMeta(can);
        stack[35] = close;
        return stack;
    }

    private boolean hasLabels(Location location) {
        ConsoleInteraction ci = ConsoleInteraction.HANDBRAKE;
        Location spawn = location.clone().add(ci.getRelativePosition().getX(), ci.getRelativePosition().getY() + (double)ci.getHeight(), ci.getRelativePosition().getZ());
        for (Entity e : spawn.getWorld().getNearbyEntities(spawn, 1.0, 2.0, 1.0, t -> t.getType() == EntityType.TEXT_DISPLAY)) {
            if (!(e instanceof TextDisplay) || e.getPersistentDataContainer().has(this.plugin.getInteractionUuidKey(), PersistentDataType.BOOLEAN)) continue;
            return true;
        }
        return false;
    }
}

