/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.mapping;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.TARDISData;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.move.TARDISTeleportLocation;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

class TARDISGetter {
    private final TARDIS plugin;
    private final World world;
    private final String prefix;
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();

    TARDISGetter(TARDIS plugin, World world) {
        this.plugin = plugin;
        this.world = world;
        this.prefix = plugin.getPrefix();
    }

    public void resultSetAsync(GetterCallback callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            List<TARDISData> results = this.getList(this.world);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.onDone(results));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<TARDISData> getList(World world) {
        ArrayList<TARDISData> dataList = new ArrayList<TARDISData>();
        Statement statement = null;
        ResultSet rs = null;
        String query = "SELECT " + this.prefix + "tardis.tardis_id, " + this.prefix + "tardis.owner, " + this.prefix + "tardis.chameleon_preset, " + this.prefix + "tardis.size, " + this.prefix + "tardis.abandoned, " + this.prefix + "tardis.powered_on, " + this.prefix + "tardis.siege_on, " + this.prefix + "current.x, " + this.prefix + "current.y, " + this.prefix + "current.z FROM " + this.prefix + "tardis, " + this.prefix + "current WHERE " + this.prefix + "tardis.tardis_id = " + this.prefix + "current.tardis_id";
        if (world != null) {
            query = query + " AND " + this.prefix + "current.world = '" + world.getName() + "'";
        } else {
            StringBuilder sb = new StringBuilder();
            for (String planet : this.plugin.getPlanetsConfig().getConfigurationSection("planets").getKeys(false)) {
                if (!this.plugin.getPlanetsConfig().getBoolean("planets." + planet + ".time_travel")) continue;
                sb.append("'").append(planet).append("',");
            }
            query = query + " AND " + this.prefix + "current.world IN (" + sb.substring(0, sb.length() - 1) + ")";
        }
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.createStatement();
            rs = statement.executeQuery(query);
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    int id = rs.getInt("tardis_id");
                    String owner = rs.getString("owner");
                    Location current = new Location(world, (double)rs.getInt("x"), (double)rs.getInt("y"), (double)rs.getInt("z"));
                    String console = rs.getString("size");
                    String chameleon = rs.getString("chameleon_preset");
                    String door = "Closed";
                    for (Map.Entry<Location, TARDISTeleportLocation> map : this.plugin.getTrackerKeeper().getPortals().entrySet()) {
                        if (map.getKey().getWorld().getName().contains("TARDIS") || map.getValue().isAbandoned() || id != map.getValue().getTardisId()) continue;
                        door = "Open";
                        break;
                    }
                    String powered = rs.getBoolean("powered_on") ? "Yes" : "No";
                    String siege = rs.getBoolean("siege_on") ? "Yes" : "No";
                    String abandoned = rs.getBoolean("abandoned") ? "Yes" : "No";
                    List<String> occupants = this.plugin.getTardisAPI().getPlayersInTARDIS(id);
                    TARDISData data = new TARDISData(owner, current, console, chameleon, door, powered, siege, abandoned, occupants);
                    dataList.add(data);
                }
            }
        }
        catch (SQLException e) {
            TARDIS.plugin.debug("ResultSet error for tardis/current table! " + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                TARDIS.plugin.debug("Error closing tardis/current table! " + e.getMessage());
            }
        }
        return dataList;
    }

    public static interface GetterCallback {
        public void onDone(List<TARDISData> var1);
    }
}

