/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners;

import java.util.HashMap;
import java.util.Set;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.sudo.TARDISSudoTracker;
import me.eccentric_nz.TARDIS.enumeration.Storage;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class TARDISMenuListener
implements Listener {
    private final TARDIS plugin;
    private final HashMap<Component, Integer> titles;

    protected TARDISMenuListener(TARDIS plugin) {
        this.plugin = plugin;
        this.titles = this.getTitleMap();
    }

    protected void close(Player player) {
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> ((Player)player).closeInventory(), 1L);
    }

    @EventHandler(ignoreCancelled=true)
    public void onMenuDrag(InventoryDragEvent event) {
        InventoryView view = event.getView();
        Component title = view.title();
        if (!this.titles.containsKey(title)) {
            return;
        }
        Set slots = event.getRawSlots();
        slots.forEach(slot -> {
            if (slot >= 0 && slot < this.titles.get(title)) {
                event.setCancelled(true);
            }
        });
    }

    @EventHandler(ignoreCancelled=true)
    public void onMenuClose(InventoryCloseEvent event) {
        InventoryView view = event.getView();
        Component title = view.title();
        if (!this.titles.containsKey(title)) {
            return;
        }
        TARDISSudoTracker.SUDOERS.remove(event.getPlayer().getUniqueId());
    }

    public int getPageNumber(InventoryView view) {
        ItemStack is = view.getItem(45);
        ItemMeta im = is.getItemMeta();
        String[] split = ComponentUtils.stripColour(im.displayName()).split(" ");
        return TARDISNumberParsers.parseInt(split[1]);
    }

    private HashMap<Component, Integer> getTitleMap() {
        HashMap<Component, Integer> map = new HashMap<Component, Integer>();
        map.put((Component)Component.text((String)"Add Companion", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"Admin Config Menu", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"Architectural Blueprints", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"Architectural Reconfiguration", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"Room Relocator", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"Area Locations", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"Artron Capacitor Storage", (TextColor)NamedTextColor.DARK_RED), 9);
        map.put((Component)Component.text((String)"Chameleon Circuit", (TextColor)NamedTextColor.DARK_RED), 27);
        map.put((Component)Component.text((String)"Chameleon Construction", (TextColor)NamedTextColor.DARK_RED), 18);
        map.put((Component)Component.text((String)"Chameleon Help", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"Chameleon Police Boxes", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"Chameleon Presets", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"Chameleon Template", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"Colour Picker", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"Companions", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"Custom Chameleon Presets", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"Customise Console", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"Destination Terminal", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"Chemical compounds", (TextColor)NamedTextColor.DARK_RED), 27);
        map.put((Component)Component.text((String)"Element constructor", (TextColor)NamedTextColor.DARK_RED), 27);
        map.put((Component)Component.text((String)"Light Emitting Blocks", (TextColor)NamedTextColor.DARK_RED), 27);
        map.put((Component)Component.text((String)"Material reducer", (TextColor)NamedTextColor.DARK_RED), 27);
        map.put((Component)Component.text((String)"Product crafting", (TextColor)NamedTextColor.DARK_RED), 27);
        map.put((Component)Component.text((String)"Lab table", (TextColor)NamedTextColor.DARK_RED), 27);
        map.put((Component)Component.text((String)"Genetic Manipulator", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"Genetic Skins", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"Particle Preferences", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"Player Prefs Menu", (TextColor)NamedTextColor.DARK_RED), 36);
        map.put((Component)Component.text((String)"Recipe Categories", (TextColor)NamedTextColor.DARK_RED), 36);
        map.put((Component)Component.text((String)"TARDIS Recipes", (TextColor)NamedTextColor.DARK_RED), 27);
        map.put((Component)Component.text((String)"Saved Programs", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"Sonic Activator", (TextColor)NamedTextColor.DARK_RED), 9);
        map.put((Component)Component.text((String)"Sonic Configurator", (TextColor)NamedTextColor.DARK_RED), 27);
        map.put((Component)Component.text((String)"Sonic Generator", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"Sonic Prefs Menu", (TextColor)NamedTextColor.DARK_RED), 27);
        map.put((Component)Component.text((String)"TARDIS Archive", (TextColor)NamedTextColor.DARK_RED), 27);
        map.put((Component)Component.text((String)"TARDIS Autonomous Menu", (TextColor)NamedTextColor.DARK_RED), 36);
        map.put((Component)Component.text((String)"TARDIS Console", (TextColor)NamedTextColor.DARK_RED), 18);
        map.put((Component)Component.text((String)"TARDIS Control Menu", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"TARDIS Farming Menu", (TextColor)NamedTextColor.DARK_RED), 36);
        map.put((Component)Component.text((String)"TARDIS Floor Menu", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"TARDIS Interior Sounds", (TextColor)NamedTextColor.DARK_RED), 18);
        map.put((Component)Component.text((String)"TARDIS Index File", (TextColor)NamedTextColor.DARK_RED), 27);
        map.put((Component)Component.text((String)"TARDIS Info Category", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"TARDIS Info Entry", (TextColor)NamedTextColor.DARK_RED), 27);
        map.put((Component)Component.text((String)"TARDIS Key Prefs Menu", (TextColor)NamedTextColor.DARK_RED), 27);
        map.put((Component)Component.text((String)"TARDIS Light Levels", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"TARDIS Light Sequence", (TextColor)NamedTextColor.DARK_RED), 36);
        map.put((Component)Component.text((String)"TARDIS Lights", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"TARDIS Map", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"TARDIS Dimension Map", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"TARDIS Seeds Menu", (TextColor)NamedTextColor.DARK_RED), 90);
        map.put((Component)Component.text((String)"TARDIS Seeds Recipe", (TextColor)NamedTextColor.DARK_RED), 90);
        map.put((Component)Component.text((String)"TARDIS Shell Loader", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"TARDIS System Upgrades", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"TARDIS Telepathic Circuit", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"TARDIS Television", (TextColor)NamedTextColor.DARK_RED), 36);
        map.put((Component)Component.text((String)"Doctor Skins", (TextColor)NamedTextColor.DARK_RED), 36);
        map.put((Component)Component.text((String)"Companion Skins", (TextColor)NamedTextColor.DARK_RED), 36);
        map.put((Component)Component.text((String)"Character Skins", (TextColor)NamedTextColor.DARK_RED), 36);
        map.put((Component)Component.text((String)"Monster Skins", (TextColor)NamedTextColor.DARK_RED), 27);
        map.put((Component)Component.text((String)"TARDIS Upgrade Menu", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"TARDIS Wall & Floor Menu", (TextColor)NamedTextColor.DARK_RED), 90);
        map.put((Component)Component.text((String)"TARDIS Wall Menu", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"TARDIS Washing Machine", (TextColor)NamedTextColor.DARK_RED), 27);
        map.put((Component)Component.text((String)"TARDIS Weather Menu", (TextColor)NamedTextColor.DARK_RED), 9);
        map.put((Component)Component.text((String)"TARDIS areas", (TextColor)NamedTextColor.DARK_RED), 90);
        map.put((Component)Component.text((String)"TARDIS saves", (TextColor)NamedTextColor.DARK_RED), 90);
        map.put((Component)Component.text((String)"TARDIS transmats", (TextColor)NamedTextColor.DARK_RED), 90);
        map.put((Component)Component.text((String)"Temporal Locator", (TextColor)NamedTextColor.DARK_RED), 27);
        map.put((Component)Component.text((String)"Telepathic Biome Finder", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"Telepathic Structure Finder", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"Variable Light Blocks", (TextColor)NamedTextColor.DARK_RED), 54);
        map.put((Component)Component.text((String)"Vortex Manipulator", (TextColor)NamedTextColor.DARK_RED), 81);
        map.put((Component)Component.text((String)"VM Messages", (TextColor)NamedTextColor.DARK_RED), 81);
        map.put((Component)Component.text((String)"VM Saves", (TextColor)NamedTextColor.DARK_RED), 81);
        for (Storage s : Storage.values()) {
            map.put((Component)Component.text((String)s.getTitle()), 54);
        }
        return map;
    }
}

