/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners;

import java.util.ArrayList;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetGarden;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.plugin.Plugin;

public class TARDISBonemealListener
implements Listener {
    private final TARDIS plugin;
    private final List<Material> smallFlowers;

    public TARDISBonemealListener(TARDIS plugin) {
        this.plugin = plugin;
        this.smallFlowers = new ArrayList<Material>(Tag.SMALL_FLOWERS.getValues());
        this.smallFlowers.remove(Material.WITHER_ROSE);
        this.smallFlowers.remove(Material.TORCHFLOWER);
        this.smallFlowers.remove(Material.WILDFLOWERS);
    }

    @EventHandler(ignoreCancelled=true)
    public void onBonemeal(BlockFertilizeEvent event) {
        Location location = event.getBlock().getLocation();
        if (!this.plugin.getUtils().inTARDISWorld(location)) {
            return;
        }
        int id = this.inGarden(location);
        if (id == -1) {
            return;
        }
        ResultSetTardisID rst = new ResultSetTardisID(this.plugin);
        if (rst.fromUUID(event.getPlayer().getUniqueId().toString()) && rst.getTardisId() == id) {
            int y = location.getBlockY() + 1;
            for (BlockState state : event.getBlocks()) {
                Block block = state.getBlock();
                if (block.getY() > y) {
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        state.setType(Material.AIR);
                        state.update(true);
                    }, 1L);
                    continue;
                }
                if (block.getType() != Material.AIR) continue;
                Material flower = this.smallFlowers.get(TARDISConstants.RANDOM.nextInt(this.smallFlowers.size()));
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    state.setType(flower);
                    state.update(true);
                }, 1L);
            }
        } else {
            event.setCancelled(true);
            this.plugin.getMessenger().send((CommandSender)event.getPlayer(), TardisModule.TARDIS, "GARDEN_TIMELORD");
        }
    }

    private int inGarden(Location location) {
        ResultSetGarden rsg = new ResultSetGarden(this.plugin, location);
        return rsg.resultSet() ? rsg.getTardis_id() : -1;
    }
}

