/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners;

import com.destroystokyo.paper.MaterialTags;
import io.papermc.paper.event.player.PlayerFlowerPotManipulateEvent;
import java.util.ArrayList;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetAntiBuild;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISAntiBuild;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class TARDISAntiBuildListener
implements Listener {
    private final TARDIS plugin;
    private final List<Material> no_place = new ArrayList<Material>();
    private final List<Material> allow_interact = new ArrayList<Material>();

    public TARDISAntiBuildListener(TARDIS plugin) {
        this.plugin = plugin;
        this.no_place.add(Material.CHEST_MINECART);
        this.no_place.add(Material.EGG);
        this.no_place.add(Material.FLINT_AND_STEEL);
        this.no_place.add(Material.FURNACE_MINECART);
        this.no_place.add(Material.HOPPER_MINECART);
        this.no_place.add(Material.ITEM_FRAME);
        this.no_place.add(Material.MINECART);
        this.no_place.add(Material.PAINTING);
        this.no_place.add(Material.SHEARS);
        this.no_place.add(Material.TNT_MINECART);
        this.no_place.addAll(MaterialTags.BUCKETS.getValues());
        this.no_place.addAll(MaterialTags.SPAWN_EGGS.getValues());
        this.no_place.addAll(Tag.ITEMS_BOATS.getValues());
        this.allow_interact.add(Material.COMPARATOR);
        this.allow_interact.add(Material.LEVER);
        this.allow_interact.add(Material.REPEATER);
        this.allow_interact.addAll(Tag.BUTTONS.getValues());
        this.allow_interact.addAll(Tag.DOORS.getValues());
        this.allow_interact.addAll(Tag.FENCE_GATES.getValues());
        this.allow_interact.addAll(Tag.PRESSURE_PLATES.getValues());
        this.allow_interact.addAll(Tag.TRAPDOORS.getValues());
    }

    @EventHandler
    public void onFlowerPotInteract(PlayerFlowerPotManipulateEvent event) {
        Player p = event.getPlayer();
        if (!this.plugin.getUtils().inTARDISWorld(p)) {
            return;
        }
        ResultSetAntiBuild rs = new ResultSetAntiBuild(this.plugin, p.getUniqueId());
        if (!rs.resultSet() || !this.plugin.getTrackerKeeper().getAntiBuild().containsKey(rs.getTardis_id())) {
            return;
        }
        event.setCancelled(true);
        this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "ANTIBUILD");
    }

    @EventHandler(ignoreCancelled=true)
    public void onCompanionBuild(BlockPlaceEvent event) {
        TARDISAntiBuild tab;
        Player p = event.getPlayer();
        if (!this.plugin.getUtils().inTARDISWorld(p)) {
            return;
        }
        ResultSetAntiBuild rs = new ResultSetAntiBuild(this.plugin, p.getUniqueId());
        if (!rs.resultSet() || !this.plugin.getTrackerKeeper().getAntiBuild().containsKey(rs.getTardis_id())) {
            return;
        }
        Vector v = event.getBlock().getLocation().toVector();
        if (v.isInAABB((tab = this.plugin.getTrackerKeeper().getAntiBuild().get(rs.getTardis_id())).getMin(), tab.getMax())) {
            event.setCancelled(true);
            this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "ANTIBUILD_TIMELORD", tab.getTimelord());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onCompanionBreak(BlockBreakEvent event) {
        TARDISAntiBuild tab;
        Player p = event.getPlayer();
        if (!this.plugin.getUtils().inTARDISWorld(p)) {
            return;
        }
        ResultSetAntiBuild rs = new ResultSetAntiBuild(this.plugin, p.getUniqueId());
        if (!rs.resultSet() || !this.plugin.getTrackerKeeper().getAntiBuild().containsKey(rs.getTardis_id())) {
            return;
        }
        Vector v = event.getBlock().getLocation().toVector();
        if (v.isInAABB((tab = this.plugin.getTrackerKeeper().getAntiBuild().get(rs.getTardis_id())).getMin(), tab.getMax())) {
            event.setCancelled(true);
            this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "ANTIBUILD_TIMELORD", tab.getTimelord());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onCompanionPlace(PlayerInteractEvent event) {
        if (event.getAction().equals((Object)Action.PHYSICAL)) {
            return;
        }
        Player p = event.getPlayer();
        if (!this.plugin.getUtils().inTARDISWorld(p)) {
            return;
        }
        ResultSetAntiBuild rs = new ResultSetAntiBuild(this.plugin, p.getUniqueId());
        if (!rs.resultSet() || !this.plugin.getTrackerKeeper().getAntiBuild().containsKey(rs.getTardis_id())) {
            return;
        }
        EquipmentSlot hand = event.getHand();
        if (hand == null) {
            return;
        }
        ItemStack t = hand.equals((Object)EquipmentSlot.HAND) ? p.getInventory().getItemInMainHand() : p.getInventory().getItemInOffHand();
        Material m = t.getType();
        if (hand.equals((Object)EquipmentSlot.HAND) && this.no_place.contains(m) || hand.equals((Object)EquipmentSlot.OFF_HAND) && this.no_place.contains(m) && !this.allow_interact.contains(event.getClickedBlock().getType())) {
            event.setUseItemInHand(Event.Result.DENY);
            event.setCancelled(true);
            this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "ANTIBUILD");
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onCompanionEntityClick(PlayerInteractEntityEvent event) {
        TARDISAntiBuild tab;
        Player p = event.getPlayer();
        if (!this.plugin.getUtils().inTARDISWorld(p)) {
            return;
        }
        ResultSetAntiBuild rs = new ResultSetAntiBuild(this.plugin, p.getUniqueId());
        if (!rs.resultSet() || !this.plugin.getTrackerKeeper().getAntiBuild().containsKey(rs.getTardis_id())) {
            return;
        }
        Vector v = event.getRightClicked().getLocation().toVector();
        if (v.isInAABB((tab = this.plugin.getTrackerKeeper().getAntiBuild().get(rs.getTardis_id())).getMin(), tab.getMax())) {
            event.setCancelled(true);
            this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "ANTIBUILD_TIMELORD", tab.getTimelord());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onCompanionDamage(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (entity instanceof Player) {
            TARDISAntiBuild tab;
            Player p = (Player)entity;
            if (!this.plugin.getUtils().inTARDISWorld(p)) {
                return;
            }
            ResultSetAntiBuild rs = new ResultSetAntiBuild(this.plugin, p.getUniqueId());
            if (!rs.resultSet() || !this.plugin.getTrackerKeeper().getAntiBuild().containsKey(rs.getTardis_id())) {
                return;
            }
            Vector v = event.getEntity().getLocation().toVector();
            if (v.isInAABB((tab = this.plugin.getTrackerKeeper().getAntiBuild().get(rs.getTardis_id())).getMin(), tab.getMax())) {
                event.setCancelled(true);
                this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "ANTIBUILD_TIMELORD", tab.getTimelord());
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onCompanionBreakHanging(HangingBreakByEntityEvent event) {
        Entity entity = event.getRemover();
        if (entity instanceof Player) {
            TARDISAntiBuild tab;
            Player p = (Player)entity;
            if (!this.plugin.getUtils().inTARDISWorld(p)) {
                return;
            }
            ResultSetAntiBuild rs = new ResultSetAntiBuild(this.plugin, p.getUniqueId());
            if (!rs.resultSet() || !this.plugin.getTrackerKeeper().getAntiBuild().containsKey(rs.getTardis_id())) {
                return;
            }
            Vector v = event.getEntity().getLocation().toVector();
            if (v.isInAABB((tab = this.plugin.getTrackerKeeper().getAntiBuild().get(rs.getTardis_id())).getMin(), tab.getMax())) {
                event.setCancelled(true);
                this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "ANTIBUILD_TIMELORD", tab.getTimelord());
            }
        }
    }
}

