/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.floodgate;

import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.commands.utils.weather.Weather;
import me.eccentric_nz.TARDIS.control.AtmosphericExcitation;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.response.SimpleFormResponse;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class FloodgateWeatherForm {
    private final TARDIS plugin;
    private final UUID uuid;

    public FloodgateWeatherForm(TARDIS plugin, UUID uuid) {
        this.plugin = plugin;
        this.uuid = uuid;
    }

    public void send() {
        SimpleForm form = (SimpleForm)((SimpleForm.Builder)((SimpleForm.Builder)SimpleForm.builder().title("TARDIS Weather Menu")).button("clear", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/clear.png").button("rain", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/rain.png").button("thunder", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/thunder.png").button("excite", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/excite.png").validResultHandler(this::handleResponse)).build();
        FloodgatePlayer player = FloodgateApi.getInstance().getPlayer(this.uuid);
        player.sendForm((Form)form);
    }

    private void handleResponse(SimpleFormResponse response) {
        Player player = this.plugin.getServer().getPlayer(this.uuid);
        String label = response.clickedButton().text();
        if (!this.plugin.getConfig().getBoolean("allow.weather_set")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "WEATHER_DISABLED");
            return;
        }
        HashMap<String, Object> wheres = new HashMap<String, Object>();
        wheres.put("uuid", player.getUniqueId().toString());
        ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wheres, false);
        if (rst.resultSet()) {
            int id = rst.getTardis_id();
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", id);
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (rs.resultSet()) {
                Tardis tardis = rs.getTardis();
                if (!tardis.isTardisInit()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ENERGY_NO_INIT");
                    return;
                }
                if (this.plugin.getConfig().getBoolean("allow.power_down") && !tardis.isPoweredOn()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "POWER_DOWN");
                    return;
                }
                if (!tardis.isHandbrakeOn()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_WHILE_TRAVELLING");
                    return;
                }
                ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
                if (!rsc.resultSet()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
                    return;
                }
                if (label.equals("excite")) {
                    if (this.plugin.getTrackerKeeper().getExcitation().contains(player.getUniqueId())) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CMD_EXCITE");
                        return;
                    }
                    new AtmosphericExcitation(this.plugin).excite(tardis.getTardisId(), player);
                    this.plugin.getTrackerKeeper().getExcitation().add(player.getUniqueId());
                } else {
                    me.eccentric_nz.TARDIS.enumeration.Weather weather = me.eccentric_nz.TARDIS.enumeration.Weather.fromString(label);
                    String perm = weather.toString().toLowerCase(Locale.ROOT);
                    if (!TARDISPermission.hasPermission(player, "tardis.weather." + perm)) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERMS");
                    }
                    Weather.setWeather(rsc.getCurrent().location().getWorld(), weather);
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "WEATHER_SET", perm);
                }
            }
        }
    }
}

