/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.files;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;

public class LanguageConfigUpdater {
    private final TARDIS plugin;

    public LanguageConfigUpdater(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void update() {
        String lang = this.plugin.getConfig().getString("preferences.language");
        if (lang.equals("en")) {
            return;
        }
        String en_path = String.valueOf(this.plugin.getDataFolder()) + File.separator + "language" + File.separator + "en.yml";
        File en_file = new File(en_path);
        YamlConfiguration en = YamlConfiguration.loadConfiguration((File)en_file);
        int i = 0;
        for (Object key : en.getKeys(false)) {
            if (this.plugin.getLanguage().contains((String)key)) continue;
            this.plugin.getLanguage().set((String)key, (Object)en.getString((String)key));
            ++i;
        }
        try {
            String lang_path = String.valueOf(this.plugin.getDataFolder()) + File.separator + "language" + File.separator + lang + ".yml";
            this.plugin.getLanguage().save(new File(lang_path));
        }
        catch (IOException ex) {
            this.plugin.debug("Could not save language config file after adding entries! " + ex.getMessage());
        }
        int j = 0;
        for (String key : this.plugin.getLanguage().getKeys(false)) {
            if (en.contains(key)) continue;
            this.plugin.getLanguage().set(key, null);
            ++j;
        }
        String lang_path = String.valueOf(this.plugin.getDataFolder()) + File.separator + "language" + File.separator + lang + ".yml";
        try {
            this.plugin.getLanguage().save(new File(lang_path));
        }
        catch (IOException ex) {
            this.plugin.debug("Could not save language config file after removing entries! " + ex.getMessage());
        }
        if (i > 0) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Added " + i + " new messages to " + lang + ".yml");
            try {
                ArrayList<String> lineList;
                try (FileReader fileReader = new FileReader(lang_path);){
                    String inputLine;
                    BufferedReader bufferedReader = new BufferedReader(fileReader);
                    lineList = new ArrayList<String>();
                    while ((inputLine = bufferedReader.readLine()) != null) {
                        lineList.add(inputLine);
                    }
                }
                Collections.sort(lineList);
                try (FileWriter fileWriter = new FileWriter(lang_path);
                     PrintWriter out = new PrintWriter((Writer)fileWriter, false);){
                    lineList.forEach(out::println);
                    out.flush();
                }
            }
            catch (IOException ex) {
                this.plugin.debug("Could not alphabetize language config file! " + ex.getMessage());
            }
        }
        if (j > 0) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Removed " + j + " redundant messages from " + lang + ".yml");
        }
    }
}

