/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.enumeration;

public enum ConsoleSize {
    SMALL("small", "16 x 16 x 16 blocks", 600L, 16),
    MEDIUM("medium", "32 x 16 x 32 blocks", 1460L, 32),
    TALL("tall", "32 x 32 x 32 blocks", 3072L, 32),
    WIDE("wide", "48 x 48 x 16 blocks", 3456L, 48),
    MASSIVE("massive", "48 x 32 x 48 blocks", 3760L, 48);

    private final String configPath;
    private final String blocks;
    private final long delay;
    private final int castDistance;

    private ConsoleSize(String configPath, String blocks, long delay, int castDistance) {
        this.configPath = configPath;
        this.blocks = blocks;
        this.delay = delay;
        this.castDistance = castDistance;
    }

    public static ConsoleSize getByWidthAndHeight(int w, int h) {
        if (w < 17 && h < 17) {
            return SMALL;
        }
        if (w > 16 && w < 48 && h < 17) {
            return MEDIUM;
        }
        if (w < 48) {
            return TALL;
        }
        if (h < 17) {
            return WIDE;
        }
        return MASSIVE;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public String getBlocks() {
        return this.blocks;
    }

    public long getDelay() {
        return this.delay;
    }

    public int getCastDistance() {
        return this.castDistance;
    }
}

