/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.doors.inner;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.builders.exterior.EmergencyRelocation;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDoors;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.mobfarming.FollowerSpawner;
import me.eccentric_nz.TARDIS.mobfarming.PetsAndFollowers;
import me.eccentric_nz.TARDIS.mobfarming.TARDISFarmer;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class InnerDisplayDoorMover {
    private final TARDIS plugin;

    public InnerDisplayDoorMover(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void exit(Player player, Block block) {
        Location block_loc = block.getLocation();
        String bw = block_loc.getWorld().getName();
        int bx = block_loc.getBlockX();
        int by = block_loc.getBlockY();
        int bz = block_loc.getBlockZ();
        String doorloc = bw + ":" + bx + ":" + by + ":" + bz;
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("door_location", doorloc);
        ResultSetDoors rsd = new ResultSetDoors(this.plugin, where, false);
        if (rsd.resultSet()) {
            int id = rsd.getTardis_id();
            if (rsd.isLocked()) {
                this.plugin.getMessenger().sendStatus(player, "DOOR_DEADLOCKED");
                return;
            }
            if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
                this.plugin.getMessenger().sendStatus(player, "SIEGE_NO_EXIT");
                return;
            }
            HashMap<String, Object> tid = new HashMap<String, Object>();
            tid.put("tardis_id", id);
            ResultSetTardis rs = new ResultSetTardis(this.plugin, tid, "", false);
            if (rs.resultSet()) {
                Tardis tardis = rs.getTardis();
                if (!tardis.isHandbrakeOn()) {
                    this.plugin.getMessenger().sendStatus(player, "HANDBRAKE_ENGAGE");
                    return;
                }
                ChameleonPreset preset = tardis.getPreset();
                float yaw = player.getLocation().getYaw();
                boolean hb = tardis.isHandbrakeOn();
                ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
                if (!rsc.resultSet()) {
                    new EmergencyRelocation(this.plugin).relocate(id, player);
                    return;
                }
                boolean userQuotes = true;
                boolean minecart = false;
                ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, player.getUniqueId().toString());
                if (rsp.resultSet()) {
                    userQuotes = rsp.isQuotesOn();
                    minecart = rsp.isMinecartOn();
                }
                Current current = rsc.getCurrent();
                HashMap<String, Object> other = new HashMap<String, Object>();
                other.put("tardis_id", id);
                other.put("door_type", 0);
                ResultSetDoors rsexit = new ResultSetDoors(this.plugin, other, false);
                COMPASS exitDirection = rsexit.resultSet() ? rsexit.getDoor_direction() : current.direction();
                if (this.plugin.getTrackerKeeper().getInVortex().contains(id) || this.plugin.getTrackerKeeper().getMaterialising().contains(id) || this.plugin.getTrackerKeeper().getDematerialising().contains(id)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "LOST_IN_VORTEX");
                    return;
                }
                if (preset.equals((Object)ChameleonPreset.INVISIBLE)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "INVISIBILITY_SNEAK");
                    return;
                }
                boolean opened = TARDISStaticUtils.isDoorOpen(block);
                Location exitLoc = opened && preset.hasDoor() ? TARDISStaticLocationGetters.getLocationFromDB(rsexit.getDoor_location()) : current.location();
                if (hb && exitLoc != null) {
                    TARDISFarmer tf;
                    PetsAndFollowers petsAndFollowers;
                    COMPASS interiorDirection = rsd.getDoor_direction();
                    if (!interiorDirection.equals((Object)exitDirection)) {
                        yaw += this.plugin.getGeneralKeeper().getDoorListener().adjustYaw(interiorDirection, exitDirection);
                    }
                    exitLoc.setYaw(yaw);
                    double ex = exitLoc.getX();
                    double ez = exitLoc.getZ();
                    if (opened) {
                        exitLoc.setX(ex + 0.5);
                        exitLoc.setZ(ez + 0.5);
                    } else {
                        switch (exitDirection.forPreset()) {
                            case NORTH: {
                                exitLoc.setX(ex + 0.5);
                                exitLoc.setZ(ez + 2.5);
                                break;
                            }
                            case EAST: {
                                exitLoc.setX(ex - 1.5);
                                exitLoc.setZ(ez + 0.5);
                                break;
                            }
                            case SOUTH: {
                                exitLoc.setX(ex + 0.5);
                                exitLoc.setZ(ez - 1.5);
                                break;
                            }
                            default: {
                                exitLoc.setX(ex + 2.5);
                                exitLoc.setZ(ez + 0.5);
                            }
                        }
                    }
                    this.plugin.getGeneralKeeper().getDoorListener().movePlayer(player, exitLoc, true, block.getWorld(), userQuotes, 2, minecart, false);
                    if (this.plugin.getConfig().getBoolean("allow.mob_farming") && TARDISPermission.hasPermission(player, "tardis.farm") && (petsAndFollowers = (tf = new TARDISFarmer(this.plugin)).exitPets(player)) != null) {
                        if (!petsAndFollowers.getPets().isEmpty()) {
                            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getGeneralKeeper().getDoorListener().movePets(petsAndFollowers.getPets(), exitLoc, player, exitDirection, false), 10L);
                        }
                        if (!petsAndFollowers.getFollowers().isEmpty()) {
                            new FollowerSpawner(this.plugin).spawn(petsAndFollowers.getFollowers(), exitLoc, player, exitDirection, false);
                        }
                    }
                    HashMap<String, Object> wheret = new HashMap<String, Object>();
                    wheret.put("uuid", player.getUniqueId().toString());
                    this.plugin.getQueryFactory().doSyncDelete("travellers", wheret);
                } else {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "LOST_IN_VORTEX");
                }
            }
        }
    }
}

