/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.TardisLight;
import org.bukkit.Material;

public class ResultSetLightPrefs {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;
    private int tardisId;
    private TardisLight light;
    private Material material;
    private String sequence;
    private String delays;
    private String levels;

    public ResultSetLightPrefs(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fromID(int id) {
        Statement statement = null;
        ResultSet rs = null;
        String query = "SELECT * FROM " + this.prefix + "light_prefs WHERE tardis_id = ?";
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.prepareStatement(query);
            statement.setInt(1, id);
            rs = statement.executeQuery();
            if (rs.isBeforeFirst()) {
                rs.next();
                this.tardisId = rs.getInt("tardis_id");
                try {
                    this.light = TardisLight.valueOf(rs.getString("light"));
                    this.material = Material.valueOf((String)rs.getString("material"));
                }
                catch (IllegalArgumentException e) {
                    this.light = TardisLight.LAMP;
                    this.material = Material.BONE_BLOCK;
                }
                this.sequence = rs.getString("pattern");
                this.delays = rs.getString("delays");
                this.levels = rs.getString("levels");
                boolean e = true;
                return e;
            }
            boolean e = false;
            return e;
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for light_prefs table! " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing light_prefs table! " + e.getMessage());
            }
        }
    }

    public TardisLight getLight() {
        return this.light;
    }

    public Material getMaterial() {
        return this.material;
    }

    public String getSequence() {
        return this.sequence;
    }

    public String getDelays() {
        return this.delays;
    }

    public String getLevels() {
        return this.levels;
    }
}

