/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.console.telepathic;

import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.custommodels.GUIMap;
import me.eccentric_nz.TARDIS.custommodels.keys.SwitchVariant;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;

public class TelepathicInventory
implements InventoryHolder {
    private final TARDIS plugin;
    private final Player player;
    private final Inventory inventory;

    public TelepathicInventory(TARDIS plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 54, (Component)Component.text((String)"TARDIS Telepathic Circuit", (TextColor)NamedTextColor.DARK_RED));
        this.inventory.setContents(this.getButtons());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public ItemStack[] getButtons() {
        ItemStack[] stack = new ItemStack[9];
        ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, this.player.getUniqueId().toString());
        boolean on = rsp.resultSet() && rsp.isTelepathyOn();
        TextComponent onOff = on ? Component.text((String)"ON", (TextColor)NamedTextColor.GREEN) : Component.text((String)"OFF", (TextColor)NamedTextColor.RED);
        ItemStack toggle = ItemStack.of((Material)Material.REPEATER);
        ItemMeta tim = toggle.getItemMeta();
        tim.displayName((Component)Component.text((String)"Telepathic Circuit"));
        tim.lore(List.of(onOff));
        CustomModelDataComponent component = tim.getCustomModelDataComponent();
        component.setFloats(on ? SwitchVariant.TELEPATHIC_CIRCUIT_ON.getFloats() : SwitchVariant.TELEPATHIC_CIRCUIT_OFF.getFloats());
        tim.setCustomModelDataComponent(component);
        toggle.setItemMeta(tim);
        stack[0] = toggle;
        if (TARDISPermission.hasPermission(this.player, "tardis.timetravel.cave")) {
            ItemStack cave = ItemStack.of((Material)Material.DRIPSTONE_BLOCK);
            ItemMeta cim = cave.getItemMeta();
            cim.displayName((Component)Component.text((String)"Cave Finder"));
            cim.lore(List.of(Component.text((String)"Search for a cave"), Component.text((String)"to travel to.")));
            cave.setItemMeta(cim);
            stack[2] = cave;
        }
        if (TARDISPermission.hasPermission(this.player, "tardis.timetravel.village")) {
            ItemStack structure = ItemStack.of((Material)Material.HAY_BLOCK);
            ItemMeta sim = structure.getItemMeta();
            sim.displayName((Component)Component.text((String)"Structure Finder"));
            sim.lore(List.of(Component.text((String)"Search for a structure"), Component.text((String)"to travel to.")));
            structure.setItemMeta(sim);
            stack[4] = structure;
        }
        if (TARDISPermission.hasPermission(this.player, "tardis.timetravel.biome")) {
            ItemStack biome = ItemStack.of((Material)Material.BAMBOO_MOSAIC);
            ItemMeta bim = biome.getItemMeta();
            bim.displayName((Component)Component.text((String)"Biome Finder"));
            bim.lore(List.of(Component.text((String)"Search for a biome"), Component.text((String)"to travel to.")));
            biome.setItemMeta(bim);
            stack[6] = biome;
        }
        ItemStack close = ItemStack.of((Material)GUIMap.BUTTON_CLOSE.material(), (int)1);
        ItemMeta gui = close.getItemMeta();
        gui.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_CLOSE", "Close")));
        gui.setItemModel(GUIMap.BUTTON_CLOSE.key());
        close.setItemMeta(gui);
        stack[8] = close;
        return stack;
    }
}

