/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.console.interaction;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.console.models.DirectionModel;
import me.eccentric_nz.TARDIS.control.actions.DirectionAction;
import me.eccentric_nz.TARDIS.database.InteractionStateSaver;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;

public class DirectionInteraction {
    private final TARDIS plugin;

    public DirectionInteraction(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void rotate(int id, Player player, Interaction interaction) {
        if (this.plugin.getTrackerKeeper().getFlight().containsKey(player.getUniqueId())) {
            return;
        }
        if (this.plugin.getTrackerKeeper().getInVortex().contains(id) || this.plugin.getTrackerKeeper().getMaterialising().contains(id) || this.plugin.getTrackerKeeper().getDematerialising().contains(id)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_WHILE_MAT");
            return;
        }
        String direction = new DirectionAction(this.plugin).rotate(id, player);
        this.plugin.getMessenger().announceRepeater(player, direction);
        int state = this.getState(direction);
        new InteractionStateSaver(this.plugin).write("DIRECTION", state, id);
        UUID uuid = (UUID)interaction.getPersistentDataContainer().get(this.plugin.getModelUuidKey(), this.plugin.getPersistentDataTypeUUID());
        if (uuid != null) {
            ItemDisplay display = (ItemDisplay)this.plugin.getServer().getEntity(uuid);
            new DirectionModel().setState(display, state);
        }
    }

    private int getState(String direction) {
        return switch (direction) {
            case "NORTH_EAST" -> 1;
            case "EAST" -> 2;
            case "SOUTH_EAST" -> 3;
            case "SOUTH" -> 4;
            case "SOUTH_WEST" -> 5;
            case "WEST" -> 6;
            case "NORTH_WEST" -> 7;
            default -> 0;
        };
    }
}

