/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.event.TARDISTravelEvent;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.commands.utils.RescueAcceptor;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisPowered;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.TravelType;
import me.eccentric_nz.TARDIS.flight.TARDISLand;
import me.eccentric_nz.TARDIS.travel.TARDISRescue;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

class RescueCommand {
    private final TARDIS plugin;

    RescueCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    boolean startRescue(Player player, String[] args) {
        if (args.length < 2) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TOO_FEW_ARGS");
            return true;
        }
        if (args[1].equalsIgnoreCase("accept")) {
            new RescueAcceptor(this.plugin).doRequest(player, false);
            return true;
        }
        if (TARDISPermission.hasPermission(player, "tardis.timetravel.rescue")) {
            ResultSetTardisPowered rs = new ResultSetTardisPowered(this.plugin);
            if (!rs.fromUUID(player.getUniqueId().toString())) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_A_TIMELORD");
                return true;
            }
            if (this.plugin.getConfig().getBoolean("allow.power_down") && !rs.isPowered()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "POWER_DOWN");
                return true;
            }
            String saved = args[1];
            if (!saved.equalsIgnoreCase("accept")) {
                Player destPlayer = this.plugin.getServer().getPlayer(saved);
                if (destPlayer == null) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_ONLINE");
                    return true;
                }
                UUID savedUUID = destPlayer.getUniqueId();
                String who = this.plugin.getTrackerKeeper().getTelepathicRescue().containsKey(savedUUID) ? this.plugin.getServer().getPlayer(this.plugin.getTrackerKeeper().getTelepathicRescue().get(savedUUID)).getName() : player.getName();
                ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, destPlayer.getUniqueId().toString());
                if (rsp.resultSet() && rsp.isAutoRescueOn()) {
                    TARDISRescue res = new TARDISRescue(this.plugin);
                    this.plugin.getTrackerKeeper().getChatRescue().remove(savedUUID);
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        TARDISRescue.RescueData rd = res.tryRescue(player, destPlayer.getUniqueId(), false);
                        if (rd.success()) {
                            if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(rd.getTardis_id())) {
                                new TARDISLand(this.plugin, rd.getTardis_id(), player).exitVortex();
                                this.plugin.getPM().callEvent((Event)new TARDISTravelEvent(player, null, TravelType.RESCUE, rd.getTardis_id()));
                            } else {
                                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "REQUEST_RELEASE", destPlayer.getName());
                            }
                        }
                    }, 2L);
                } else {
                    this.plugin.getMessenger().send((CommandSender)destPlayer, TardisModule.TARDIS, "RESCUE_REQUEST", who);
                    this.plugin.getMessenger().sendRescue((CommandSender)destPlayer, this.plugin);
                    this.plugin.getTrackerKeeper().getChatRescue().put(savedUUID, player.getUniqueId());
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        if (this.plugin.getTrackerKeeper().getChatRescue().containsKey(savedUUID)) {
                            this.plugin.getTrackerKeeper().getChatRescue().remove(savedUUID);
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "RESCUE_NO_RESPONSE", saved);
                        }
                    }, 1200L);
                }
            }
        } else {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERM_PLAYER");
            return true;
        }
        return false;
    }
}

