/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.RecipeItem;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemCommand {
    private final TARDIS plugin;

    public ItemCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean update(Player player, String[] args) {
        if (args.length < 2) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TOO_FEW_ARGS");
            return true;
        }
        if (!(args[1].equalsIgnoreCase("hand") || args[1].equalsIgnoreCase("inventory") || args[1].equalsIgnoreCase("cell"))) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARG_ITEM");
            return true;
        }
        switch (args[1].toLowerCase(Locale.ROOT)) {
            case "hand": {
                RecipeItem recipeItem;
                ItemStack inHand = player.getInventory().getItemInMainHand();
                if (!inHand.hasItemMeta()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ITEM_IN_HAND");
                    return true;
                }
                ItemMeta im = inHand.getItemMeta();
                if (!im.hasDisplayName()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ITEM_IN_HAND");
                    return true;
                }
                Component component = im.displayName();
                String stripped = ComponentUtils.stripColour(component);
                if (!component.children().isEmpty()) {
                    stripped = ComponentUtils.stripColour((Component)component.children().getFirst());
                }
                if ((recipeItem = RecipeItem.getByName(stripped)).equals((Object)RecipeItem.NOT_FOUND)) break;
                im.displayName((Component)ComponentUtils.toWhite(stripped));
                im.setItemModel(null);
                inHand.setItemMeta(im);
                player.updateInventory();
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ITEM_UPDATED");
                break;
            }
            case "inventory": {
                int i = 0;
                for (ItemStack is : player.getInventory()) {
                    RecipeItem recipeItem;
                    ItemMeta im;
                    if (is == null || !is.hasItemMeta() || !(im = is.getItemMeta()).hasDisplayName()) continue;
                    Component component = im.displayName();
                    String stripped = ComponentUtils.stripColour(component);
                    if (!component.children().isEmpty()) {
                        stripped = ComponentUtils.stripColour((Component)component.children().getFirst());
                    }
                    if ((recipeItem = RecipeItem.getByName(stripped)).equals((Object)RecipeItem.NOT_FOUND)) continue;
                    im.displayName((Component)ComponentUtils.toWhite(stripped));
                    im.setItemModel(null);
                    is.setItemMeta(im);
                    ++i;
                }
                if (i <= 0) break;
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ITEMS_UPDATED", "" + i);
                player.updateInventory();
                break;
            }
            case "cell": {
                int i = 0;
                for (ItemStack is : player.getInventory()) {
                    RecipeItem recipeItem;
                    ItemMeta im;
                    if (is == null || !is.hasItemMeta() || is.getType() != Material.BUCKET || !(im = is.getItemMeta()).hasDisplayName()) continue;
                    Component component = im.displayName();
                    String stripped = ComponentUtils.stripColour(component);
                    if (!component.children().isEmpty()) {
                        stripped = ComponentUtils.stripColour((Component)component.children().getFirst());
                    }
                    if (!(recipeItem = RecipeItem.getByName(stripped)).equals((Object)RecipeItem.ARTRON_STORAGE_CELL)) continue;
                    im.displayName((Component)ComponentUtils.toWhite(stripped));
                    im.setItemModel(null);
                    if (im.hasLore()) {
                        List lore = im.lore();
                        int level = TARDISNumberParsers.parseInt(ComponentUtils.stripColour((Component)lore.get(1)));
                        if (level < 0) {
                            level = 0;
                        }
                        lore.set(0, Component.text((String)"Charge Level"));
                        lore.set(1, Component.text((int)level));
                        im.lore(lore);
                        im.setEnchantmentGlintOverride(Boolean.valueOf(level > 0));
                        im.addItemFlags(ItemFlag.values());
                        im.setAttributeModifiers((Multimap)Multimaps.forMap(Map.of()));
                    }
                    is.setItemMeta(im);
                    ++i;
                }
                if (i <= 0) break;
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ITEMS_UPDATED_CELL", "" + i);
                player.updateInventory();
                break;
            }
        }
        return true;
    }
}

