/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.CircuitChecker;
import me.eccentric_nz.TARDIS.advanced.CircuitDamager;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.destroyers.DestroyData;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.DiskCircuit;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;

public class HideCommand {
    private final TARDIS plugin;

    public HideCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean hide(OfflinePlayer player) {
        if (TARDISPermission.hasPermission(player, "tardis.rebuild")) {
            int hide;
            UUID uuid = player.getUniqueId();
            if (this.plugin.getTrackerKeeper().getHideCooldown().containsKey(uuid)) {
                long now = System.currentTimeMillis();
                long cooldown = this.plugin.getConfig().getLong("police_box.rebuild_cooldown");
                long then = this.plugin.getTrackerKeeper().getHideCooldown().get(uuid) + cooldown;
                if (now < then) {
                    this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "COOLDOWN_HIDE", String.format("%d", cooldown / 1000L));
                    return true;
                }
            }
            this.plugin.getTrackerKeeper().getHideCooldown().put(uuid, System.currentTimeMillis());
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", uuid.toString());
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (!rs.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "NO_TARDIS");
                return false;
            }
            Tardis tardis = rs.getTardis();
            if (this.plugin.getConfig().getBoolean("allow.power_down") && !tardis.isPoweredOn()) {
                this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "POWER_DOWN");
                return true;
            }
            if (tardis.getPreset().equals((Object)ChameleonPreset.INVISIBLE)) {
                this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "INVISIBILITY_ENGAGED");
                return true;
            }
            int id = tardis.getTardisId();
            CircuitChecker tcc = new CircuitChecker(this.plugin, id);
            tcc.getCircuits();
            if (this.plugin.getConfig().getBoolean("difficulty.circuits") && !this.plugin.getUtils().inGracePeriod(player.getPlayer(), true) && !tcc.hasMaterialisation()) {
                this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "NO_MAT_CIRCUIT");
                return true;
            }
            if (this.plugin.getConfig().getBoolean("circuits.damage") && this.plugin.getConfig().getInt("circuits.uses.telepathic") > 0) {
                int uses_left = tcc.getTelepathicUses();
                new CircuitDamager(this.plugin, DiskCircuit.TELEPATHIC, uses_left, id, player.getPlayer()).damage();
            }
            HashMap<String, Object> wherein = new HashMap<String, Object>();
            wherein.put("uuid", uuid.toString());
            ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wherein, false);
            if (rst.resultSet() && this.plugin.getTrackerKeeper().getHasDestination().containsKey(id)) {
                this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "TARDIS_NO_HIDE");
                return true;
            }
            if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "NOT_IN_VORTEX");
                return true;
            }
            if (this.plugin.getTrackerKeeper().getInVortex().contains(id) || this.plugin.getTrackerKeeper().getMaterialising().contains(id) || this.plugin.getTrackerKeeper().getDematerialising().contains(id)) {
                this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "NOT_WHILE_MAT");
                return true;
            }
            if (this.plugin.getTrackerKeeper().getDispersedTARDII().contains(id)) {
                this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "NOT_WHILE_DISPERSED");
                return true;
            }
            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
            if (!rsc.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "CURRENT_NOT_FOUND");
                return true;
            }
            Current current = rsc.getCurrent();
            int level = tardis.getArtronLevel();
            if (level < (hide = this.plugin.getArtronConfig().getInt("hide"))) {
                this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "ENERGY_NO_HIDE");
                return false;
            }
            DestroyData dd = new DestroyData();
            dd.setDirection(current.direction());
            dd.setLocation(current.location());
            dd.setPlayer((OfflinePlayer)player.getPlayer());
            dd.setHide(true);
            dd.setOutside(false);
            dd.setSubmarine(current.submarine());
            dd.setTardisID(id);
            dd.setThrottle(SpaceTimeThrottle.REBUILD);
            this.plugin.getPresetDestroyer().destroyPreset(dd);
            this.plugin.getTrackerKeeper().getInVortex().add(id);
            this.plugin.getMessenger().sendColouredCommand((CommandSender)player.getPlayer(), "TARDIS_HIDDEN", "/tardis rebuild ", this.plugin);
            HashMap<String, Object> wheret = new HashMap<String, Object>();
            wheret.put("tardis_id", id);
            this.plugin.getQueryFactory().alterEnergyLevel("tardis", -hide, wheret, player.getPlayer());
            HashMap<String, Object> whereh = new HashMap<String, Object>();
            whereh.put("tardis_id", id);
            HashMap<String, Object> seth = new HashMap<String, Object>();
            seth.put("hidden", 1);
            this.plugin.getQueryFactory().doUpdate("tardis", seth, whereh);
            if (this.plugin.getTrackerKeeper().getActiveForceFields().containsKey(uuid)) {
                this.plugin.getTrackerKeeper().getActiveForceFields().remove(uuid);
                this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "FORCE_FIELD", "OFF");
            }
            return true;
        }
        this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "NO_PERMS");
        return false;
    }
}

