/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.WorldManager;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.upgrades.SystemTree;
import me.eccentric_nz.TARDIS.upgrades.SystemUpgradeChecker;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

class FindCommand {
    private final TARDIS plugin;

    FindCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    boolean findTARDIS(Player player) {
        if (TARDISPermission.hasPermission(player, "tardis.find")) {
            if (this.plugin.getConfig().getBoolean("difficulty.system_upgrades") && !new SystemUpgradeChecker(this.plugin).has(player.getUniqueId().toString(), SystemTree.TARDIS_LOCATOR)) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "TARDIS Locator");
                return true;
            }
            ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
            if (!rs.fromUUID(player.getUniqueId().toString())) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TARDIS");
                return true;
            }
            if (!this.plugin.getConfig().getBoolean("difficulty.tardis_locator") || this.plugin.getUtils().inGracePeriod(player, true)) {
                ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, rs.getTardisId());
                if (rsc.resultSet()) {
                    Current current = rsc.getCurrent();
                    String world = TARDISAliasResolver.getWorldAlias(current.location().getWorld());
                    if (!this.plugin.getPlanetsConfig().getBoolean("planets." + current.location().getWorld().getName() + ".enabled") && this.plugin.getWorldManager().equals((Object)WorldManager.MULTIVERSE)) {
                        world = this.plugin.getMVHelper().getAlias(current.location().getWorld());
                    }
                    if (player.isOp()) {
                        this.plugin.getMessenger().sendFind(player, world, current.location().getBlockX(), current.location().getBlockY(), current.location().getBlockZ());
                    } else {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TARDIS_FIND", world + " at x: " + current.location().getBlockX() + " y: " + current.location().getBlockY() + " z: " + current.location().getBlockZ());
                    }
                } else {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
                }
                return true;
            }
            this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "DIFF_HARD_FIND", "/tardisrecipe locator", this.plugin);
            return true;
        }
        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERMS");
        return false;
    }
}

