/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.preferences;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.commands.TARDISCommandHelper;
import me.eccentric_nz.TARDIS.commands.preferences.BuildCommand;
import me.eccentric_nz.TARDIS.commands.preferences.EPSMessageCommand;
import me.eccentric_nz.TARDIS.commands.preferences.FloorCommand;
import me.eccentric_nz.TARDIS.commands.preferences.HadsTypeCommand;
import me.eccentric_nz.TARDIS.commands.preferences.HumCommand;
import me.eccentric_nz.TARDIS.commands.preferences.IsomorphicCommand;
import me.eccentric_nz.TARDIS.commands.preferences.JunkPreference;
import me.eccentric_nz.TARDIS.commands.preferences.LabelsCommand;
import me.eccentric_nz.TARDIS.commands.preferences.LightsCommand;
import me.eccentric_nz.TARDIS.commands.preferences.ParticlePrefsCommand;
import me.eccentric_nz.TARDIS.commands.preferences.SetFlightCommand;
import me.eccentric_nz.TARDIS.commands.preferences.SetKeyCommand;
import me.eccentric_nz.TARDIS.commands.preferences.SetLanguageCommand;
import me.eccentric_nz.TARDIS.commands.preferences.SilenceMobsCommand;
import me.eccentric_nz.TARDIS.commands.preferences.ToggleOnOffCommand;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetArtronLevel;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.forcefield.ForceField;
import me.eccentric_nz.TARDIS.playerprefs.TARDISKeyMenuInventory;
import me.eccentric_nz.TARDIS.playerprefs.TARDISSonicMenuInventory;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TARDISPrefsCommands
implements CommandExecutor {
    private static final ImmutableList<String> firstArgs = ImmutableList.of((Object)"announce_repeaters", (Object)"auto", (Object)"auto_powerup", (Object)"auto_rescue", (Object)"auto_siege", (Object)"beacon", (Object)"build", (Object)"close_gui", (Object)"console_labels", (Object)"dialogs", (Object)"dnd", (Object)"dynamic_lamps", (Object[])new String[]{"effect", "eps", "eps_message", "farm", "flight", "floor", "forcefield", "hads", "hads_type", "hum", "info", "isomorphic", "key", "key_menu", "junk", "language", "lights", "lock_containers", "minecart", "open_display_door", "quotes", "regen_block", "renderer", "sfx", "shape", "siege_floor", "siege_wall", "sign", "silence_mobs", "sonic", "speed", "submarine", "telepathy", "translate", "travelbar", "wall"});
    private final TARDIS plugin;

    public TARDISPrefsCommands(TARDIS plugin) {
        this.plugin = plugin;
    }

    public static ImmutableList<String> getRootArgs() {
        return firstArgs;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        boolean bl;
        if (!(sender instanceof Player)) return false;
        Player player = (Player)sender;
        if (!cmd.getName().equalsIgnoreCase("tardisprefs")) return false;
        if (args.length == 0) {
            new TARDISCommandHelper(this.plugin).getCommand("tardisprefs", sender);
            return true;
        }
        String pref = args[0].toLowerCase(Locale.ROOT);
        if (!firstArgs.contains((Object)pref)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PREF_NOT_VALID");
            return true;
        }
        if (!TARDISPermission.hasPermission(player, "tardis.timetravel") || TARDISPermission.isNegated(player, "tardis.prefs." + pref)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERMS");
            return true;
        }
        if (pref.equals("sonic")) {
            player.openInventory(new TARDISSonicMenuInventory(this.plugin).getInventory());
            return true;
        }
        if (pref.equals("key_menu")) {
            player.openInventory(new TARDISKeyMenuInventory(this.plugin).getInventory());
            return true;
        }
        String uuid = player.getUniqueId().toString();
        ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, uuid);
        HashMap<String, Object> set = new HashMap<String, Object>();
        if (!rsp.resultSet()) {
            set.put("uuid", uuid);
            this.plugin.getQueryFactory().doInsert("player_prefs", set);
        }
        switch (pref) {
            case "console_labels": {
                return new LabelsCommand(this.plugin).toggle(player, args);
            }
            case "eps_message": {
                return new EPSMessageCommand(this.plugin).setMessage(player, args);
            }
            case "flight": {
                return new SetFlightCommand(this.plugin).setMode(player, args);
            }
            case "hads_type": {
                return new HadsTypeCommand(this.plugin).setHadsPref(player, args);
            }
            case "hum": {
                return new HumCommand(this.plugin).setHumPref(player, args);
            }
            case "isomorphic": {
                return new IsomorphicCommand(this.plugin).toggleIsomorphicControls(player);
            }
            case "key": {
                return new SetKeyCommand(this.plugin).setKeyPref(player, args);
            }
            case "language": 
            case "translate": {
                return new SetLanguageCommand(this.plugin).setLanguagePref(player, args);
            }
            case "lights": {
                return new LightsCommand(this.plugin).setLightsPref(player, args);
            }
            case "wall": 
            case "floor": 
            case "siege_wall": 
            case "siege_floor": {
                return new FloorCommand(this.plugin).setFloorOrWallBlock(player, args);
            }
            case "effect": 
            case "shape": 
            case "speed": {
                return new ParticlePrefsCommand(this.plugin).setPartclePref(player, args);
            }
            case "silence_mobs": {
                return new SilenceMobsCommand(this.plugin).toggle(player, args);
            }
        }
        if (args.length < 2 || !args[1].equalsIgnoreCase("on") && !args[1].equalsIgnoreCase("off")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PREF_ON_OFF", pref);
            return false;
        }
        if (pref.equals("forcefield") && TARDISPermission.hasPermission(player, "tardis.forcefield")) {
            if (!args[1].equalsIgnoreCase("on")) {
                this.plugin.getTrackerKeeper().getActiveForceFields().remove(player.getUniqueId());
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PREF_WAS_OFF", "The TARDIS force field");
                return true;
            }
            ResultSetArtronLevel rsal = new ResultSetArtronLevel(this.plugin, uuid);
            if (!rsal.resultset()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "POWER_LEVEL");
                return true;
            }
            if (rsal.getArtronLevel() <= this.plugin.getArtronConfig().getInt("standby")) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "POWER_LOW");
                return true;
            }
            if (!ForceField.addToTracker(player)) return true;
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PREF_WAS_ON", "The TARDIS force field");
            return true;
        }
        switch (pref) {
            case "build": {
                bl = new BuildCommand(this.plugin).toggleCompanionBuilding(player, args);
                return bl;
            }
            case "junk": {
                bl = new JunkPreference(this.plugin).toggle(player, args[1]);
                return bl;
            }
        }
        bl = new ToggleOnOffCommand(this.plugin).toggle(player, args);
        return bl;
    }
}

