/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.give.actions;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.give.DisplayBlockCommand;
import me.eccentric_nz.TARDIS.commands.give.Give;
import me.eccentric_nz.TARDIS.enumeration.RecipeCategory;
import me.eccentric_nz.TARDIS.enumeration.RecipeItem;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import me.eccentric_nz.tardischemistry.lab.Lab;
import me.eccentric_nz.tardischemistry.lab.LabBuilder;
import me.eccentric_nz.tardischemistry.product.Product;
import me.eccentric_nz.tardischemistry.product.ProductBuilder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TARDISItem {
    private final TARDIS plugin;
    private final List<String> CHEM_BLOCKS = List.of("Atomic Elements", "Chemical Compounds", "Lab Table", "Product Crafting", "Material Reducer", "Element Constructor");

    public TARDISItem(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean give(CommandSender sender, String item, int amount, Player player) {
        if (amount > 64) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARG_MAX");
            return true;
        }
        if ((item.equals("untempered-schism") || item.equals("elixir-of-life")) && !this.plugin.getConfig().getBoolean("modules.regeneration")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "RECIPE_REGENERATION");
            return true;
        }
        if ((item.equals("sonic-blaster") || item.equals("blaster-battery") || item.equals("landing-pad")) && !this.plugin.getConfig().getBoolean("modules.sonic_blaster")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "RECIPE_BLASTER");
            return true;
        }
        if (item.equals("k9") && !this.plugin.getConfig().getBoolean("modules.weeping_angels")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "RECIPE_K9");
            return true;
        }
        String item_to_give = Give.items.get(item);
        RecipeCategory category = RecipeCategory.ITEMS;
        try {
            RecipeItem recipeItem = RecipeItem.valueOf(TARDISStringUtils.toEnumUppercase(item_to_give));
            category = recipeItem.getCategory();
        }
        catch (IllegalArgumentException recipeItem) {
            // empty catch block
        }
        ItemStack result = null;
        ItemMeta im = null;
        if (category == RecipeCategory.CHEMISTRY) {
            String enumName;
            if (!this.plugin.getConfig().getBoolean("modules.chemistry")) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "RECIPE_CHEMISTRY");
                return true;
            }
            if (item.equalsIgnoreCase("balloon") || item.equalsIgnoreCase("glow-stick") || item.equalsIgnoreCase("sparkler")) {
                switch (item) {
                    case "balloon": {
                        enumName = "Red_Balloon";
                        break;
                    }
                    case "glow-stick": {
                        enumName = "Light_Blue_Glow_Stick";
                        break;
                    }
                    default: {
                        enumName = "Green_Sparkler";
                        break;
                    }
                }
            } else {
                enumName = item_to_give.replaceAll(" ", "_");
            }
            if (this.CHEM_BLOCKS.contains(item_to_give)) {
                result = this.plugin.getFigura().getShapedRecipes().get(item_to_give).getResult();
            } else {
                try {
                    Product product = Product.valueOf(enumName);
                    result = ProductBuilder.getProduct(product);
                }
                catch (IllegalArgumentException e) {
                    try {
                        this.plugin.debug("Giving lab built item...");
                        Lab lab = Lab.valueOf(enumName);
                        result = LabBuilder.getLabProduct(lab);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
        } else {
            ArrayList<TextComponent> lore;
            if (item.equals("vortex-manipulator") && !this.plugin.getConfig().getBoolean("modules.vortex_manipulator")) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "RECIPE_VORTEX");
                return true;
            }
            if (item.equals("acid-bucket") || item.equals("rust-bucket")) {
                result = ItemStack.of((Material)(item.equals("acid-bucket") ? Material.WATER_BUCKET : Material.LAVA_BUCKET), (int)1);
                im = result.getItemMeta();
            } else {
                result = item.equals("save-storage-disk") || item.equals("preset-storage-disk") || item.equals("biome-storage-disk") || item.equals("player-storage-disk") || item.equals("bowl-of-custard") || item.equals("jelly-baby") || item.equals("schematic-wand") || item.equals("judoon-ammunition") ? this.plugin.getIncomposita().getShapelessRecipes().get(item_to_give).getResult() : (Give.custom.contains(item) ? new DisplayBlockCommand(this.plugin).getStack(item) : this.plugin.getFigura().getShapedRecipes().get(item_to_give).getResult());
            }
            if (item.equals("vortex-manipulator")) {
                this.plugin.getMessenger().sendColouredCommand(sender, "GIVE_VORTEX", "/vm activate " + player.getName(), this.plugin);
            }
            if (item.equals("invisibility-circuit")) {
                im = result.getItemMeta();
                lore = im.lore();
                TextComponent uses = this.plugin.getConfig().getString("circuits.uses.invisibility", "5").equals("0") || !this.plugin.getConfig().getBoolean("circuits.damage") ? Component.text((String)"unlimited", (TextColor)NamedTextColor.YELLOW) : Component.text((String)this.plugin.getConfig().getString("circuits.uses.invisibility", "5"), (TextColor)NamedTextColor.YELLOW);
                lore.set(1, uses);
                im.lore((List)lore);
            }
            if (item.equals("blank") || item.equals("save-disk") || item.equals("preset-disk") || item.equals("biome-disk") || item.equals("player-disk") || item.equals("blaster") || item.equals("control")) {
                im = result.getItemMeta();
                im.addItemFlags(ItemFlag.values());
                im.setAttributeModifiers((Multimap)Multimaps.forMap(Map.of()));
            }
            if (item.equals("key") || item.equals("control")) {
                im = result.getItemMeta();
                im.getPersistentDataContainer().set(this.plugin.getTimeLordUuidKey(), this.plugin.getPersistentDataTypeUUID(), (Object)player.getUniqueId());
                lore = im.lore();
                if (lore == null) {
                    lore = new ArrayList<TextComponent>();
                }
                String what = item.equals("key") ? "key" : "disk";
                lore.add((TextComponent)Component.text((String)("This " + what + " belongs to"), (TextColor)NamedTextColor.AQUA).decorate(TextDecoration.ITALIC));
                lore.add((TextComponent)Component.text((String)player.getName(), (TextColor)NamedTextColor.AQUA).decorate(TextDecoration.ITALIC));
                im.lore(lore);
            }
        }
        if (result != null) {
            if (im == null) {
                im = result.getItemMeta();
            }
            im.displayName((Component)ComponentUtils.toWhite(Give.items.get(item)));
            result.setItemMeta(im);
            result.setAmount(amount);
            player.getInventory().addItem(new ItemStack[]{result});
            player.updateInventory();
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "GIVE_ITEM", sender.getName(), amount + " " + item_to_give);
        }
        return true;
    }
}

