/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.builders.interior;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISBuilderInstanceKeeper;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.builders.interior.TARDISInteriorPostioning;
import me.eccentric_nz.TARDIS.builders.interior.TIPSData;
import me.eccentric_nz.TARDIS.builders.utility.FractalFence;
import me.eccentric_nz.TARDIS.console.ConsoleBuilder;
import me.eccentric_nz.TARDIS.customblocks.TARDISBlockDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetAchievements;
import me.eccentric_nz.TARDIS.desktop.ChunkUtils;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.UseClay;
import me.eccentric_nz.TARDIS.floodgate.TARDISFloodgate;
import me.eccentric_nz.TARDIS.mobfarming.FollowerSpawner;
import me.eccentric_nz.TARDIS.rotors.TimeRotor;
import me.eccentric_nz.TARDIS.schematic.SchematicGZip;
import me.eccentric_nz.TARDIS.schematic.setters.ArmourStandSetter;
import me.eccentric_nz.TARDIS.schematic.setters.BannerSetter;
import me.eccentric_nz.TARDIS.schematic.setters.HeadSetter;
import me.eccentric_nz.TARDIS.schematic.setters.ItemDisplaySetter;
import me.eccentric_nz.TARDIS.schematic.setters.ItemFrameSetter;
import me.eccentric_nz.TARDIS.schematic.setters.MannequinSetter;
import me.eccentric_nz.TARDIS.schematic.setters.PaintingSetter;
import me.eccentric_nz.TARDIS.schematic.setters.PotSetter;
import me.eccentric_nz.TARDIS.schematic.setters.SIDRATFenceSetter;
import me.eccentric_nz.TARDIS.schematic.setters.SignSetter;
import me.eccentric_nz.TARDIS.utility.TARDISBannerData;
import me.eccentric_nz.TARDIS.utility.TARDISBlockSetters;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.FaceAttachable;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.type.Switch;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class InteriorBuildRunnable
implements Runnable {
    private final TARDIS plugin;
    private final Schematic schm;
    private final World world;
    private final int dbID;
    private final Player player;
    private final Material wall_type;
    private final Material floor_type;
    private final int tips;
    private final HashMap<Block, BlockData> postBedBlocks = new HashMap();
    private final HashMap<Block, BlockData> postCarpetBlocks = new HashMap();
    private final HashMap<Block, BlockData> postDoorBlocks = new HashMap();
    private final HashMap<Block, BlockData> postDripstoneBlocks = new HashMap();
    private final HashMap<Block, BlockData> postLanternBlocks = new HashMap();
    private final HashMap<Block, BlockData> postLeverBlocks = new HashMap();
    private final HashMap<Block, BlockData> postLichenBlocks = new HashMap();
    private final HashMap<Block, BlockData> postPistonBaseBlocks = new HashMap();
    private final HashMap<Block, BlockData> postPistonExtensionBlocks = new HashMap();
    private final HashMap<Block, BlockData> postRedstoneTorchBlocks = new HashMap();
    private final HashMap<Block, BlockData> postRepeaterBlocks = new HashMap();
    private final HashMap<Block, BlockData> postSculkVeinBlocks = new HashMap();
    private final HashMap<Block, BlockData> postStickyPistonBaseBlocks = new HashMap();
    private final HashMap<Block, BlockData> postTorchBlocks = new HashMap();
    private final HashMap<Block, BlockData> sidratFenceBlocks = new HashMap();
    private final HashMap<Block, JsonObject> postSignBlocks = new HashMap();
    private final List<Block> fractalBlocks = new ArrayList<Block>();
    private final List<Block> iceBlocks = new ArrayList<Block>();
    private final List<Block> postLightBlocks = new ArrayList<Block>();
    private final HashMap<Block, TARDISBannerData> postBannerBlocks = new HashMap();
    private final HashMap<String, Object> set = new HashMap();
    private final HashMap<String, Object> where = new HashMap();
    private Block postBedrock = null;
    private Location postOod = null;
    private int task;
    private int level = 0;
    private int row = 0;
    private int startx;
    private int starty;
    private int startz;
    private int resetx;
    private int resetz;
    private int h;
    private int w;
    private int d;
    private int j = 2;
    private JsonArray arr;
    private JsonObject obj;
    private Location wg1;
    private Location wg2;
    private TIPSData pos;
    private List<Chunk> chunkList;
    private String playerUUID;
    private boolean running = false;
    private Location ender = null;
    private UseClay use_clay;
    private int counter = 0;
    private double div = 1.0;
    private BossBar bb;

    public InteriorBuildRunnable(TARDIS plugin, Schematic schm, World world, int dbID, Player player, Material wall_type, Material floor_type, int tips) {
        this.plugin = plugin;
        this.schm = schm;
        this.world = world;
        this.dbID = dbID;
        this.player = player;
        this.wall_type = wall_type;
        this.floor_type = floor_type;
        this.tips = tips;
    }

    @Override
    public void run() {
        if (!this.running) {
            if (!this.plugin.getConfig().getBoolean("creation.create_worlds") && !this.plugin.getConfig().getBoolean("creation.default_world")) {
                this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "CONFIG_CREATION_WORLD");
                this.plugin.getServer().getScheduler().cancelTask(this.task);
                this.task = -1;
                return;
            }
            this.starty = this.schm.getStartY();
            this.obj = SchematicGZip.getObject(this.plugin, "consoles", this.schm.getPermission(), this.schm.isCustom());
            if (this.obj != null) {
                JsonObject dimensions = this.obj.get("dimensions").getAsJsonObject();
                this.h = dimensions.get("height").getAsInt() - 1;
                this.w = dimensions.get("width").getAsInt();
                this.d = dimensions.get("length").getAsInt() - 1;
                this.div = ((double)this.h + 1.0) * (double)this.w * ((double)this.d + 1.0);
                this.playerUUID = this.player.getUniqueId().toString();
                if (this.tips > -1000001) {
                    TARDISInteriorPostioning tARDISInteriorPostioning = new TARDISInteriorPostioning(this.plugin);
                    this.pos = tARDISInteriorPostioning.getTIPSData(this.tips);
                    this.startx = this.pos.getCentreX();
                    this.resetx = this.pos.getCentreX();
                    this.startz = this.pos.getCentreZ();
                    this.resetz = this.pos.getCentreZ();
                    Location cl = new Location(this.world, (double)this.startx, (double)this.starty, (double)this.startz);
                    Chunk c2 = this.world.getChunkAt(cl);
                    while (!c2.isLoaded()) {
                        c2.load(true);
                    }
                    String chun = this.world.getName() + ":" + c2.getX() + ":" + c2.getZ();
                    this.set.put("chunk", chun);
                    if (this.schm.getPermission().equals("junk")) {
                        this.set.put("creeper", cl.toString());
                    }
                } else {
                    int[] nArray = this.plugin.getLocationUtils().getStartLocation(this.dbID);
                    this.startx = nArray[0];
                    this.resetx = nArray[1];
                    this.startz = nArray[2];
                    this.resetz = nArray[3];
                }
                this.wg1 = new Location(this.world, (double)this.startx, (double)this.starty, (double)this.startz);
                this.wg2 = new Location(this.world, (double)(this.startx + (this.w - 1)), (double)(this.starty + (this.h - 1)), (double)(this.startz + (this.d - 1)));
                this.chunkList = ChunkUtils.getConsoleChunks(this.world, this.wg1.getChunk().getX(), this.wg1.getChunk().getZ(), this.w, this.d);
                this.chunkList.forEach(c -> {
                    while (!c.isLoaded()) {
                        c.load(true);
                    }
                    HashMap<String, Object> setc = new HashMap<String, Object>();
                    setc.put("tardis_id", this.dbID);
                    setc.put("world", this.world.getName());
                    setc.put("x", c.getX());
                    setc.put("z", c.getZ());
                    this.plugin.getQueryFactory().doInsert("chunks", setc);
                });
                this.where.put("tardis_id", this.dbID);
                try {
                    this.use_clay = UseClay.valueOf(this.plugin.getConfig().getString("creation.use_clay"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.use_clay = UseClay.WOOL;
                }
                this.arr = this.obj.get("input").getAsJsonArray();
                this.bb = Bukkit.createBossBar((String)TARDISConstants.GROWTH_STATES.getFirst(), (BarColor)BarColor.WHITE, (BarStyle)BarStyle.SOLID, (BarFlag[])TARDISConstants.EMPTY_ARRAY);
                this.bb.setProgress(0.0);
                this.bb.addPlayer(this.player);
                this.bb.setVisible(true);
                this.running = true;
            }
        }
        if (this.level == this.h && this.row == this.w - 1) {
            this.postBedBlocks.forEach(Block::setBlockData);
            this.postDoorBlocks.forEach(Block::setBlockData);
            this.postRedstoneTorchBlocks.forEach(Block::setBlockData);
            this.postTorchBlocks.forEach(Block::setBlockData);
            this.postLanternBlocks.forEach(Block::setBlockData);
            this.postRepeaterBlocks.forEach(Block::setBlockData);
            this.postStickyPistonBaseBlocks.forEach(Block::setBlockData);
            this.postPistonBaseBlocks.forEach(Block::setBlockData);
            this.postPistonExtensionBlocks.forEach(Block::setBlockData);
            this.postLeverBlocks.forEach(Block::setBlockData);
            this.postDripstoneBlocks.forEach(Block::setBlockData);
            this.postLichenBlocks.forEach(Block::setBlockData);
            this.postSculkVeinBlocks.forEach(Block::setBlockData);
            SignSetter.setSigns(this.postSignBlocks, this.plugin, this.dbID);
            for (Map.Entry entry : this.postCarpetBlocks.entrySet()) {
                Block pcb = (Block)entry.getKey();
                pcb.setBlockData((BlockData)entry.getValue());
            }
            if (this.postBedrock != null) {
                this.postBedrock.setBlockData(TARDISConstants.POWER);
            }
            if (this.postOod != null) {
                FollowerSpawner spawner = new FollowerSpawner(this.plugin);
                spawner.spawnDivisionOod(this.postOod);
            }
            this.postLightBlocks.forEach(block -> {
                if (block.getType().isAir()) {
                    Levelled levelled = TARDISConstants.LIGHT;
                    levelled.setLevel(15);
                    block.setBlockData((BlockData)levelled);
                }
            });
            if (this.schm.getPermission().equals("cave")) {
                this.iceBlocks.forEach(ice -> ice.setBlockData(TARDISConstants.WATER));
                this.iceBlocks.clear();
            }
            for (int f = 0; f < this.fractalBlocks.size(); ++f) {
                FractalFence.grow(this.fractalBlocks.get(f), f);
            }
            BannerSetter.setBanners(this.postBannerBlocks);
            SIDRATFenceSetter.update(this.sidratFenceBlocks);
            if (this.plugin.isWorldGuardOnServer() && this.plugin.getConfig().getBoolean("preferences.use_worldguard")) {
                if (this.pos != null) {
                    this.plugin.getWorldGuardUtils().addWGProtection(this.player, this.pos, this.world, this.schm.getPermission().equals("junk"));
                } else {
                    this.plugin.getWorldGuardUtils().addWGProtection(this.player, this.wg1, this.wg2);
                }
            }
            if (this.ender != null) {
                Entity ender_crystal = this.world.spawnEntity(this.ender, EntityType.END_CRYSTAL);
                ((EnderCrystal)ender_crystal).setShowingBottom(false);
            }
            if (this.obj.has("mannequins")) {
                JsonArray mannequins = this.obj.get("mannequins").getAsJsonArray();
                MannequinSetter.setMannequins(mannequins, this.world, this.resetx, this.starty, this.resetz);
            }
            if (this.obj.has("armour_stands")) {
                JsonArray stands = this.obj.get("armour_stands").getAsJsonArray();
                ArmourStandSetter.setStands(stands, this.world, this.resetx, this.starty, this.resetz);
            }
            if (this.obj.has("paintings")) {
                JsonArray paintings = (JsonArray)this.obj.get("paintings");
                PaintingSetter.setArt(paintings, this.world, this.resetx, this.starty, this.resetz);
            }
            if (this.obj.has("item_frames")) {
                JsonArray frames = this.obj.get("item_frames").getAsJsonArray();
                ItemFrameSetter.curate(frames, this.wg1, this.dbID);
            }
            if (this.obj.has("item_displays")) {
                JsonArray displays = this.obj.get("item_displays").getAsJsonArray();
                ItemDisplaySetter.process(displays, this.player, this.wg1, this.dbID);
            }
            this.chunkList.forEach(chink -> {
                for (Entity e : chink.getEntities()) {
                    if (!(e instanceof Item)) continue;
                    e.remove();
                }
            });
            this.plugin.getQueryFactory().doUpdate("tardis", this.set, this.where);
            if (this.plugin.getKitsConfig().getBoolean("give.create.enabled") && TARDISPermission.hasPermission(this.player, "tardis.kit.create")) {
                HashMap<String, Object> wherek = new HashMap<String, Object>();
                wherek.put("uuid", this.playerUUID);
                wherek.put("name", "createkit");
                ResultSetAchievements resultSetAchievements = new ResultSetAchievements(this.plugin, wherek);
                if (!resultSetAchievements.resultSet()) {
                    HashMap<String, Object> setk = new HashMap<String, Object>();
                    setk.put("uuid", this.playerUUID);
                    setk.put("name", "createkit");
                    this.plugin.getQueryFactory().doInsert("achievements", setk);
                    String kit = this.plugin.getKitsConfig().getString("give.create.kit");
                    this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "tardisgive " + this.player.getName() + " kit " + kit);
                }
            }
            this.plugin.getServer().getScheduler().cancelTask(this.task);
            this.task = -1;
            this.bb.setProgress(1.0);
            this.bb.setVisible(false);
            this.bb.removeAll();
        }
        JsonArray floor = this.arr.get(this.level).getAsJsonArray();
        JsonArray jsonArray = (JsonArray)floor.get(this.row);
        for (int col = 0; col <= this.d; ++col) {
            Bisected bisected;
            ++this.counter;
            JsonObject c2 = jsonArray.get(col).getAsJsonObject();
            int x = this.startx + this.row;
            int y = this.starty + this.level;
            int z = this.startz + col;
            BlockData data = this.plugin.getServer().createBlockData(c2.get("data").getAsString());
            Material type = data.getMaterial();
            if (type.equals((Object)Material.LIGHT_GRAY_CONCRETE) && (this.schm.getPermission().equals("bone") || this.schm.getPermission().equals("rustic"))) {
                Block block2 = new Location(this.world, (double)x, (double)y, (double)z).getBlock();
                String ct = this.schm.getPermission().equals("bone") ? "console_light_gray" : "console_rustic";
                new ConsoleBuilder(this.plugin).create(block2, ct, this.dbID, this.playerUUID);
            }
            if (type.equals((Object)Material.SCULK_SHRIEKER)) {
                String shrieker = new Location(this.world, (double)x, (double)y, (double)z).toString();
                TimeRotor.updateRotorRecord(this.dbID, shrieker);
            }
            if (type.equals((Object)Material.NOTE_BLOCK)) {
                String storage = TARDISStaticLocationGetters.makeLocationStr(this.world, x, y, z);
                this.plugin.getQueryFactory().insertSyncControl(this.dbID, 14, storage, 0);
                if (!TARDISFloodgate.isFloodgateEnabled() || !TARDISFloodgate.isBedrockPlayer(this.player.getUniqueId())) {
                    data = TARDISConstants.BARRIER;
                    TARDISDisplayItemUtils.set(TARDISBlockDisplayItem.DISK_STORAGE, this.world, x, y, z);
                }
            }
            if (Tag.WOOL.isTagged((Keyed)type)) {
                block2 : switch (type) {
                    case ORANGE_WOOL: {
                        if (this.wall_type == Material.ORANGE_WOOL) {
                            switch (this.use_clay) {
                                case TERRACOTTA: {
                                    data = Material.ORANGE_TERRACOTTA.createBlockData();
                                    break block2;
                                }
                                case CONCRETE: {
                                    data = Material.ORANGE_CONCRETE.createBlockData();
                                    break block2;
                                }
                            }
                            if (TARDISFloodgate.isFloodgateEnabled() && TARDISFloodgate.isBedrockPlayer(this.player.getUniqueId())) break;
                            data = TARDISConstants.BARRIER;
                            TARDISDisplayItemUtils.set(TARDISBlockDisplayItem.HEXAGON, this.world, x, y, z);
                            break;
                        }
                        data = this.wall_type.createBlockData();
                        break;
                    }
                    case LIGHT_GRAY_WOOL: {
                        if (!this.schm.getPermission().equals("eleventh")) {
                            if (this.floor_type == Material.LIGHT_GRAY_WOOL) {
                                data = switch (this.use_clay) {
                                    case UseClay.TERRACOTTA -> Material.LIGHT_GRAY_TERRACOTTA.createBlockData();
                                    case UseClay.CONCRETE -> Material.LIGHT_GRAY_CONCRETE.createBlockData();
                                    default -> Material.LIGHT_GRAY_WOOL.createBlockData();
                                };
                                break;
                            }
                            data = this.floor_type.createBlockData();
                            break;
                        }
                        String[] split = type.toString().split("_");
                        String m = split.length > 2 ? split[0] + "_" + split[1] + "_" + this.use_clay.toString() : split[0] + "_" + this.use_clay.toString();
                        Material material = Material.getMaterial((String)m);
                        if (material != null) {
                            data = material.createBlockData();
                            break;
                        }
                        data = TARDISConstants.AIR;
                        break;
                    }
                    case BLUE_WOOL: {
                        switch (this.use_clay) {
                            case TERRACOTTA: {
                                data = Material.BLUE_TERRACOTTA.createBlockData();
                                break block2;
                            }
                            case CONCRETE: {
                                data = Material.BLUE_CONCRETE.createBlockData();
                                break block2;
                            }
                        }
                        if (TARDISFloodgate.isFloodgateEnabled() && TARDISFloodgate.isBedrockPlayer(this.player.getUniqueId())) break;
                        data = TARDISConstants.BARRIER;
                        TARDISDisplayItemUtils.set(TARDISBlockDisplayItem.BLUE_BOX, this.world, x, y, z);
                        break;
                    }
                    default: {
                        String[] split = type.toString().split("_");
                        String m = split.length > 2 ? split[0] + "_" + split[1] + "_" + this.use_clay.toString() : split[0] + "_" + this.use_clay.toString();
                        Material material = Material.getMaterial((String)m);
                        data = material != null ? material.createBlockData() : TARDISConstants.AIR;
                    }
                }
            }
            if ((type.equals((Object)Material.WARPED_FENCE) || type.equals((Object)Material.CRIMSON_FENCE)) && this.schm.getPermission().equals("delta")) {
                this.fractalBlocks.add(this.world.getBlockAt(x, y, z));
            }
            if (this.level == 0 && type.equals((Object)Material.PINK_STAINED_GLASS) && this.schm.getPermission().equals("division")) {
                this.postLightBlocks.add(this.world.getBlockAt(x, y - 1, z));
            }
            if (type.equals((Object)Material.DEEPSLATE_REDSTONE_ORE) && (this.schm.getPermission().equals("division") || this.schm.getPermission().equals("hospital"))) {
                BlockData blockData = data = this.schm.getPermission().equals("division") ? Material.GRAY_CONCRETE.createBlockData() : Material.LIGHT_GRAY_CONCRETE.createBlockData();
                if (this.plugin.getConfig().getBoolean("modules.weeping_angels")) {
                    this.postOod = new Location(this.world, (double)x, (double)(y + 1), (double)z);
                }
            }
            if (type.equals((Object)Material.WHITE_STAINED_GLASS) && this.schm.getPermission().equals("war") && (!TARDISFloodgate.isFloodgateEnabled() || !TARDISFloodgate.isBedrockPlayer(this.player.getUniqueId()))) {
                data = TARDISConstants.BARRIER;
                TARDISDisplayItemUtils.set(TARDISBlockDisplayItem.ROUNDEL, this.world, x, y, z);
            }
            if (type.equals((Object)Material.WHITE_TERRACOTTA) && this.schm.getPermission().equals("war") && (!TARDISFloodgate.isFloodgateEnabled() || !TARDISFloodgate.isBedrockPlayer(this.player.getUniqueId()))) {
                data = TARDISConstants.BARRIER;
                TARDISDisplayItemUtils.set(TARDISBlockDisplayItem.ROUNDEL_OFFSET, this.world, x, y, z);
            }
            if (type.equals((Object)Material.SPAWNER)) {
                String scanner = TARDISStaticLocationGetters.makeLocationStr(this.world, x, y, z);
                this.plugin.getQueryFactory().insertSyncControl(this.dbID, 33, scanner, 0);
            }
            if (type.equals((Object)Material.CHEST)) {
                String condenser = TARDISStaticLocationGetters.makeLocationStr(this.world, x, y, z);
                this.plugin.getQueryFactory().insertSyncControl(this.dbID, 34, condenser, 0);
            }
            if (type.equals((Object)Material.IRON_DOOR) && (bisected = (Bisected)data).getHalf().equals((Object)Bisected.Half.BOTTOM)) {
                HashMap<String, Object> setd = new HashMap<String, Object>();
                String doorLocation = this.world.getName() + ":" + x + ":" + y + ":" + z;
                setd.put("tardis_id", this.dbID);
                setd.put("door_type", 1);
                setd.put("door_location", doorLocation);
                setd.put("door_direction", "SOUTH");
                this.plugin.getQueryFactory().doInsert("doors", setd);
                if (this.plugin.getConfig().getBoolean("creation.create_worlds")) {
                    this.world.setSpawnLocation(x, y, z + 1);
                }
            }
            if (type.equals((Object)Material.STONE_BUTTON) && !this.schm.getPermission().equals("junk")) {
                String button = TARDISStaticLocationGetters.makeLocationStr(this.world, x, y, z);
                this.plugin.getQueryFactory().insertSyncControl(this.dbID, 1, button, 0);
            }
            if (type.equals((Object)Material.JUKEBOX) && (!this.schm.getPermission().equals("eighth") || this.world.getBlockAt(x, y, z).getRelative(BlockFace.DOWN).getType() != Material.ANDESITE)) {
                String advanced = TARDISStaticLocationGetters.makeLocationStr(this.world, x, y, z);
                this.plugin.getQueryFactory().insertSyncControl(this.dbID, 15, advanced, 0);
                this.plugin.getUtils().updateStorageId(this.playerUUID, this.dbID);
                if (!TARDISFloodgate.isFloodgateEnabled() || !TARDISFloodgate.isBedrockPlayer(this.player.getUniqueId())) {
                    data = TARDISConstants.BARRIER;
                    TARDISDisplayItemUtils.set(TARDISBlockDisplayItem.ADVANCED_CONSOLE, this.world, x, y, z);
                }
            }
            if (type.equals((Object)Material.CAKE) && !this.schm.getPermission().equals("junk")) {
                String control;
                if (!this.schm.getPermission().equals("rustic") && !this.schm.getPermission().equals("bone")) {
                    String handbrakeLocation = TARDISStaticLocationGetters.makeLocationStr(this.world, x, y, z);
                    this.plugin.getQueryFactory().insertSyncControl(this.dbID, 0, handbrakeLocation, 0);
                }
                if (this.schm.getPermission().equals("sidrat")) {
                    BlockData blockData = Material.LEVER.createBlockData();
                    Switch lever = (Switch)blockData;
                    lever.setAttachedFace(FaceAttachable.AttachedFace.WALL);
                    lever.setFacing(BlockFace.WEST);
                    data = lever;
                }
                String[][][] empty = new String[3][9][9];
                for (int ars_y = 0; ars_y < 3; ++ars_y) {
                    for (int ars_x = 0; ars_x < 9; ++ars_x) {
                        for (int ars_z = 0; ars_z < 9; ++ars_z) {
                            empty[ars_y][ars_x][ars_z] = "STONE";
                        }
                    }
                }
                empty[1][4][4] = control = this.schm.getSeedMaterial().toString();
                switch (this.schm.getConsoleSize()) {
                    case MASSIVE: {
                        empty[1][4][5] = control;
                        empty[1][4][6] = control;
                        empty[1][5][4] = control;
                        empty[1][5][5] = control;
                        empty[1][5][6] = control;
                        empty[1][6][4] = control;
                        empty[1][6][5] = control;
                        empty[1][6][6] = control;
                        empty[2][4][4] = control;
                        empty[2][4][5] = control;
                        empty[2][4][6] = control;
                        empty[2][5][4] = control;
                        empty[2][5][5] = control;
                        empty[2][5][6] = control;
                        empty[2][6][4] = control;
                        empty[2][6][5] = control;
                        empty[2][6][6] = control;
                        break;
                    }
                    case WIDE: {
                        empty[1][4][5] = control;
                        empty[1][4][6] = control;
                        empty[1][5][4] = control;
                        empty[1][5][5] = control;
                        empty[1][5][6] = control;
                        empty[1][6][4] = control;
                        empty[1][6][5] = control;
                        empty[1][6][6] = control;
                        break;
                    }
                    case TALL: {
                        empty[1][4][5] = control;
                        empty[1][5][4] = control;
                        empty[1][5][5] = control;
                        empty[2][4][4] = control;
                        empty[2][4][5] = control;
                        empty[2][5][4] = control;
                        empty[2][5][5] = control;
                        break;
                    }
                    case MEDIUM: {
                        empty[1][4][5] = control;
                        empty[1][5][4] = control;
                        empty[1][5][5] = control;
                        break;
                    }
                }
                Gson gson = new GsonBuilder().disableHtmlEscaping().create();
                JsonArray json = JsonParser.parseString((String)gson.toJson((Object)empty)).getAsJsonArray();
                HashMap<String, Object> seta = new HashMap<String, Object>();
                seta.put("tardis_id", this.dbID);
                seta.put("uuid", this.playerUUID);
                seta.put("json", json.toString());
                this.plugin.getQueryFactory().doInsert("ars", seta);
            }
            if (type.equals((Object)Material.LIGHT)) {
                HashMap<String, Object> setlb = new HashMap<String, Object>();
                Object lightLocation = this.world.getName() + ":" + x + ":" + y + ":" + z;
                setlb.put("tardis_id", this.dbID);
                setlb.put("location", lightLocation);
                this.plugin.getQueryFactory().doInsert("lamps", setlb);
            }
            if (type.equals((Object)Material.COMMAND_BLOCK) || (this.schm.getPermission().equals("bigger") || this.schm.getPermission().equals("coral") || this.schm.getPermission().equals("deluxe") || this.schm.getPermission().equals("twelfth")) && type.equals((Object)Material.BEACON)) {
                String creeperLocation = this.world.getName() + ":" + ((double)x + 0.5) + ":" + y + ":" + ((double)z + 0.5);
                this.set.put("creeper", creeperLocation);
                if (type.equals((Object)Material.COMMAND_BLOCK)) {
                    switch (this.schm.getPermission()) {
                        case "ender": {
                            BlockData blockData = Material.END_STONE_BRICKS.createBlockData();
                            break;
                        }
                        case "delta": 
                        case "cursed": {
                            BlockData blockData = Material.BLACKSTONE.createBlockData();
                            break;
                        }
                        case "ancient": 
                        case "bone": 
                        case "fugitive": {
                            BlockData blockData = Material.GRAY_WOOL.createBlockData();
                            break;
                        }
                        case "hospital": {
                            BlockData blockData = Material.LIGHT_GRAY_WOOL.createBlockData();
                            break;
                        }
                        case "sidrat": {
                            BlockData blockData = Material.RED_CONCRETE.createBlockData();
                            break;
                        }
                        default: {
                            BlockData blockData = data = Material.STONE_BRICKS.createBlockData();
                        }
                    }
                }
            }
            if (Tag.WOODEN_BUTTONS.isTagged((Keyed)type) && !this.schm.getPermission().equals("junk")) {
                String woodButtonLocation = TARDISStaticLocationGetters.makeLocationStr(this.world, x, y, z);
                this.plugin.getQueryFactory().insertSyncControl(this.dbID, 6, woodButtonLocation, 0);
            }
            if (type.equals((Object)Material.DAYLIGHT_DETECTOR)) {
                String telepathicLocation = TARDISStaticLocationGetters.makeLocationStr(this.world, x, y, z);
                this.plugin.getQueryFactory().insertSyncControl(this.dbID, 23, telepathicLocation, 0);
            }
            if (type.equals((Object)Material.BEACON) && this.schm.getPermission().equals("ender")) {
                this.ender = this.world.getBlockAt(x, y, z).getLocation().add(0.5, 4.0, 0.5);
            }
            if (TARDISBuilderInstanceKeeper.getPrecious().contains(type)) {
                HashMap<String, Object> setpb = new HashMap<String, Object>();
                String loc = TARDISStaticLocationGetters.makeLocationStr(this.world, x, y, z);
                setpb.put("tardis_id", this.dbID);
                setpb.put("location", loc);
                setpb.put("data", "minecraft:air");
                setpb.put("police_box", 0);
                this.plugin.getQueryFactory().doInsert("blocks", setpb);
                this.plugin.getGeneralKeeper().getProtectBlockMap().put(loc, this.dbID);
            }
            if (type.equals((Object)Material.PALE_OAK_FENCE) && this.schm.getPermission().equals("sidrat")) {
                this.sidratFenceBlocks.put(this.world.getBlockAt(x, y, z), data);
            }
            if (type.equals((Object)Material.ICE) && this.schm.getPermission().equals("cave")) {
                this.iceBlocks.add(this.world.getBlockAt(x, y, z));
            } else if (Tag.BEDS.isTagged((Keyed)type)) {
                this.postBedBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (type.equals((Object)Material.IRON_DOOR)) {
                this.postDoorBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (type.equals((Object)Material.REDSTONE_TORCH) || type.equals((Object)Material.REDSTONE_WALL_TORCH)) {
                this.postRedstoneTorchBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (type.equals((Object)Material.TORCH) || type.equals((Object)Material.WALL_TORCH) || type.equals((Object)Material.SOUL_TORCH) || type.equals((Object)Material.SOUL_WALL_TORCH)) {
                this.postTorchBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (type.equals((Object)Material.STICKY_PISTON)) {
                this.postStickyPistonBaseBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (type.equals((Object)Material.PISTON)) {
                this.postPistonBaseBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (type.equals((Object)Material.PISTON_HEAD)) {
                this.postPistonExtensionBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (type.equals((Object)Material.LEVER)) {
                this.postLeverBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (Tag.ALL_SIGNS.isTagged((Keyed)type)) {
                this.postSignBlocks.put(this.world.getBlockAt(x, y, z), c2);
            } else if (type.equals((Object)Material.POINTED_DRIPSTONE)) {
                this.postDripstoneBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (type.equals((Object)Material.GLOW_LICHEN)) {
                this.postLichenBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (type.equals((Object)Material.SCULK_VEIN)) {
                this.postSculkVeinBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (type.equals((Object)Material.LANTERN) || type.equals((Object)Material.SOUL_LANTERN)) {
                this.postLanternBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (TARDISStaticUtils.isBanner(type)) {
                JsonObject state;
                JsonObject jsonObject = state = c2.has("banner") ? c2.get("banner").getAsJsonObject() : null;
                if (state != null) {
                    TARDISBannerData tbd = new TARDISBannerData(data, state);
                    this.postBannerBlocks.put(this.world.getBlockAt(x, y, z), tbd);
                }
            } else if (type.equals((Object)Material.PLAYER_HEAD) || type.equals((Object)Material.PLAYER_WALL_HEAD)) {
                JsonObject head;
                TARDISBlockSetters.setBlock(this.world, x, y, z, data);
                if (c2.has("head") && (head = c2.get("head").getAsJsonObject()).has("uuid")) {
                    try {
                        UUID uuid = UUID.fromString(head.get("uuid").getAsString());
                        HeadSetter.textureSkull(this.plugin, uuid, head, this.world.getBlockAt(x, y, z));
                    }
                    catch (IllegalArgumentException uuid) {}
                }
            } else if (type.equals((Object)Material.DECORATED_POT)) {
                TARDISBlockSetters.setBlock(this.world, x, y, z, data);
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    if (c2.has("pot")) {
                        JsonObject pot = c2.get("pot").getAsJsonObject();
                        PotSetter.decorate(this.plugin, pot, this.world.getBlockAt(x, y, z));
                    }
                }, 1L);
            } else if (TARDISStaticUtils.isInfested(type)) {
                TARDISBlockSetters.setBlock(this.world, x, y, z, Material.VOID_AIR);
            } else if (type.equals((Object)Material.MUSHROOM_STEM)) {
                if (this.j < 6) {
                    String repeater = this.world.getName() + ":" + x + ":" + y + ":" + z;
                    data = Material.REPEATER.createBlockData();
                    Directional directional = (Directional)data;
                    switch (this.j) {
                        case 2: {
                            directional.setFacing(BlockFace.WEST);
                            this.postRepeaterBlocks.put(this.world.getBlockAt(x, y, z), (BlockData)directional);
                            this.plugin.getQueryFactory().insertSyncControl(this.dbID, 3, repeater, 0);
                            break;
                        }
                        case 3: {
                            directional.setFacing(BlockFace.NORTH);
                            this.postRepeaterBlocks.put(this.world.getBlockAt(x, y, z), (BlockData)directional);
                            this.plugin.getQueryFactory().insertSyncControl(this.dbID, 2, repeater, 0);
                            break;
                        }
                        case 4: {
                            directional.setFacing(BlockFace.SOUTH);
                            this.postRepeaterBlocks.put(this.world.getBlockAt(x, y, z), (BlockData)directional);
                            this.plugin.getQueryFactory().insertSyncControl(this.dbID, 5, repeater, 0);
                            break;
                        }
                        default: {
                            directional.setFacing(BlockFace.EAST);
                            this.postRepeaterBlocks.put(this.world.getBlockAt(x, y, z), (BlockData)directional);
                            this.plugin.getQueryFactory().insertSyncControl(this.dbID, 4, repeater, 0);
                        }
                    }
                    ++this.j;
                }
            } else if (type.equals((Object)Material.SPONGE)) {
                TARDISBlockSetters.setBlock(this.world, x, y, z, Material.VOID_AIR);
            } else if (type.equals((Object)Material.BEDROCK)) {
                String bedrockLocation = this.world.getName() + ":" + x + ":" + y + ":" + z;
                this.set.put("beacon", bedrockLocation);
                this.postBedrock = this.world.getBlockAt(x, y, z);
            } else if (type.equals((Object)Material.BROWN_MUSHROOM) && this.schm.getPermission().equals("master")) {
                TARDISBlockSetters.setBlock(this.world, x, y, z, Material.VOID_AIR);
                this.plugin.setTardisSpawn(true);
                this.world.spawnEntity(new Location(this.world, (double)x + 0.5, (double)y + 0.25, (double)z + 0.5), EntityType.VILLAGER);
            } else if (type.equals((Object)Material.BLACK_CARPET) && this.schm.getPermission().equals("master")) {
                this.postCarpetBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else {
                TARDISBlockSetters.setBlock(this.world, x, y, z, data);
            }
            double progress = (double)this.counter / this.div;
            if (progress > 1.0) {
                progress = 1.0;
            }
            this.bb.setProgress(progress);
            if (col == this.d && this.row < this.w) {
                ++this.row;
            }
            if (col != this.d || this.row != this.w || this.level >= this.h) continue;
            this.row = 0;
            ++this.level;
            if (this.level == this.h) {
                this.bb.setTitle(TARDISConstants.GROWTH_STATES.get(31));
                continue;
            }
            this.bb.setTitle(TARDISConstants.GROWTH_STATES.get(this.level));
        }
    }

    public void setTask(int task) {
        this.task = task;
    }
}

