/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.builders.exterior;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.builders.exterior.InstantBlockPresetBuilder;
import me.eccentric_nz.TARDIS.chameleon.utils.ChameleonColumn;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetShells;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.utility.TARDISBlockSetters;
import net.kyori.adventure.text.Component;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Lightable;
import org.bukkit.block.data.Rotatable;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;

public class ShellBuilder {
    private final TARDIS plugin;
    private final ChameleonColumn column;
    private final Location centre;
    private final ChameleonPreset preset;
    private final int cid;
    private final Material random_colour;
    private final List<InstantBlockPresetBuilder.ProblemBlock> do_at_end = new ArrayList<InstantBlockPresetBuilder.ProblemBlock>();

    public ShellBuilder(TARDIS plugin, ChameleonPreset preset, ChameleonColumn column, Location centre, int cid) {
        this.plugin = plugin;
        this.preset = preset;
        this.column = column;
        this.centre = centre;
        this.cid = cid;
        Material[] colours = new Material[]{Material.WHITE_WOOL, Material.ORANGE_WOOL, Material.MAGENTA_WOOL, Material.LIGHT_BLUE_WOOL, Material.YELLOW_WOOL, Material.LIME_WOOL, Material.PINK_WOOL, Material.CYAN_WOOL, Material.PURPLE_WOOL, Material.BLUE_WOOL, Material.BROWN_WOOL, Material.GREEN_WOOL, Material.RED_WOOL};
        this.random_colour = colours[TARDISConstants.RANDOM.nextInt(13)];
    }

    public void buildPreset() {
        int x = this.centre.getBlockX();
        int plusx = this.centre.getBlockX() + 1;
        int minusx = this.centre.getBlockX() - 1;
        int y = this.centre.getBlockY();
        int z = this.centre.getBlockZ();
        int plusz = this.centre.getBlockZ() + 1;
        int minusz = this.centre.getBlockZ() - 1;
        World world = this.centre.getWorld();
        int signx = minusx - 1;
        int signz = z;
        BlockData[][] data = this.column.blockData();
        for (int i = 0; i < 10; ++i) {
            int xx;
            BlockData[] colData = data[i];
            int zz = switch (i) {
                case 0 -> {
                    xx = minusx;
                    yield minusz;
                }
                case 1 -> {
                    xx = x;
                    yield minusz;
                }
                case 2 -> {
                    xx = plusx;
                    yield minusz;
                }
                case 3 -> {
                    xx = plusx;
                    yield z;
                }
                case 4 -> {
                    xx = plusx;
                    yield plusz;
                }
                case 5 -> {
                    xx = x;
                    yield plusz;
                }
                case 6 -> {
                    xx = minusx;
                    yield plusz;
                }
                case 7 -> {
                    xx = minusx;
                    yield z;
                }
                case 8 -> {
                    xx = x;
                    yield z;
                }
                default -> {
                    xx = signx;
                    yield signz;
                }
            };
            block18: for (int yy = 0; yy < 4; ++yy) {
                Material mat = colData[yy].getMaterial();
                switch (mat) {
                    case WHITE_WOOL: 
                    case ORANGE_WOOL: 
                    case MAGENTA_WOOL: 
                    case LIGHT_BLUE_WOOL: 
                    case YELLOW_WOOL: 
                    case LIME_WOOL: 
                    case PINK_WOOL: 
                    case GRAY_WOOL: 
                    case LIGHT_GRAY_WOOL: 
                    case CYAN_WOOL: 
                    case PURPLE_WOOL: 
                    case BLUE_WOOL: 
                    case BROWN_WOOL: 
                    case GREEN_WOOL: 
                    case RED_WOOL: 
                    case BLACK_WOOL: {
                        if (this.preset.equals((Object)ChameleonPreset.PARTY) || this.preset.equals((Object)ChameleonPreset.FLOWER) && mat.equals((Object)Material.WHITE_WOOL)) {
                            TARDISBlockSetters.setBlock(world, xx, y + yy, zz, this.random_colour);
                        }
                        TARDISBlockSetters.setBlock(world, xx, y + yy, zz, colData[yy]);
                        continue block18;
                    }
                    case TORCH: 
                    case GLOWSTONE: 
                    case REDSTONE_LAMP: {
                        if (mat.equals((Object)Material.TORCH)) {
                            this.do_at_end.add(new InstantBlockPresetBuilder.ProblemBlock(new Location(world, (double)xx, (double)(y + yy), (double)zz), colData[yy]));
                            continue block18;
                        }
                        BlockData blockData = colData[yy];
                        if (blockData instanceof Lightable) {
                            Lightable lit = (Lightable)blockData;
                            lit.setLit(true);
                            TARDISBlockSetters.setBlock(world, xx, y + yy, zz, (BlockData)lit);
                            continue block18;
                        }
                        TARDISBlockSetters.setBlock(world, xx, y + yy, zz, colData[yy]);
                        continue block18;
                    }
                    case NETHER_PORTAL: {
                        TARDISBlockSetters.setBlock(world, xx, y + yy + 1, zz, Material.OBSIDIAN);
                        TARDISBlockSetters.setBlock(world, xx, y + yy, zz, colData[yy]);
                        continue block18;
                    }
                    case SKELETON_SKULL: {
                        Rotatable rotatable = (Rotatable)colData[yy];
                        rotatable.setRotation(this.plugin.getPresetBuilder().getSkullDirection(COMPASS.EAST));
                        TARDISBlockSetters.setBlock(world, xx, y + yy, zz, (BlockData)rotatable);
                        continue block18;
                    }
                    default: {
                        if (mat.equals((Object)Material.LEVER) || mat.equals((Object)Material.STONE_BUTTON) || mat.equals((Object)Material.OAK_BUTTON)) {
                            this.do_at_end.add(new InstantBlockPresetBuilder.ProblemBlock(new Location(world, (double)xx, (double)(y + yy), (double)zz), colData[yy]));
                            continue block18;
                        }
                        TARDISBlockSetters.setBlock(world, xx, y + yy, zz, colData[yy]);
                        if (this.cid == -1 || !Tag.ALL_SIGNS.isTagged((Keyed)mat) || xx != signx || zz != signz) continue block18;
                        HashMap<String, Object> where = new HashMap<String, Object>();
                        where.put("chameleon_id", this.cid);
                        ResultSetShells rss = new ResultSetShells(this.plugin, where);
                        if (!rss.resultSet()) continue block18;
                        HashMap<String, String> map = rss.getData().getFirst();
                        Sign sign = (Sign)world.getBlockAt(xx, y + yy, zz).getState();
                        SignSide front = sign.getSide(Side.FRONT);
                        front.line(0, (Component)Component.text((String)map.get("line1")));
                        front.line(1, (Component)Component.text((String)map.get("line2")));
                        front.line(2, (Component)Component.text((String)map.get("line3")));
                        front.line(3, (Component)Component.text((String)map.get("line4")));
                        sign.update();
                    }
                }
            }
        }
        this.do_at_end.forEach(pb -> TARDISBlockSetters.setBlock(pb.getL().getWorld(), pb.getL().getBlockX(), pb.getL().getBlockY(), pb.getL().getBlockZ(), pb.getData()));
    }
}

