/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.artron;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.event.TARDISClaimEvent;
import me.eccentric_nz.TARDIS.commands.tardis.AbandonCommand;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisPreset;
import me.eccentric_nz.TARDIS.doors.inner.Inner;
import me.eccentric_nz.TARDIS.doors.inner.InnerDisplayDoorCloser;
import me.eccentric_nz.TARDIS.doors.inner.InnerDoor;
import me.eccentric_nz.TARDIS.doors.inner.InnerMinecraftDoorCloser;
import me.eccentric_nz.TARDIS.doors.outer.OuterDisplayDoorCloser;
import me.eccentric_nz.TARDIS.doors.outer.OuterDoor;
import me.eccentric_nz.TARDIS.doors.outer.OuterMinecraftDoorCloser;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ArtronAbandoned {
    private final TARDIS plugin;

    public ArtronAbandoned(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean claim(Player player, int id, Location location, Tardis tardis) {
        ResultSetCurrentFromId rs;
        boolean pu = this.plugin.getQueryFactory().claimTARDIS(player, id);
        if (this.plugin.isWorldGuardOnServer() && this.plugin.getConfig().getBoolean("preferences.use_worldguard")) {
            this.plugin.getWorldGuardUtils().updateRegionForClaim(location, player.getUniqueId());
        }
        if ((rs = new ResultSetCurrentFromId(this.plugin, id)).resultSet()) {
            Current current = rs.getCurrent();
            if (pu) {
                ResultSetTardisPreset rsp = new ResultSetTardisPreset(this.plugin);
                if (rsp.fromID(id)) {
                    boolean outerDisplayDoor = rsp.getPreset().usesArmourStand();
                    Inner innerDisplayDoor = new InnerDoor(this.plugin, id).get();
                    UUID playerUUID = player.getUniqueId();
                    if (innerDisplayDoor.display()) {
                        new InnerDisplayDoorCloser(this.plugin).close(innerDisplayDoor.block(), id, playerUUID, true);
                    } else {
                        new InnerMinecraftDoorCloser(this.plugin).close(innerDisplayDoor.block(), id, playerUUID);
                    }
                    if (outerDisplayDoor) {
                        new OuterDisplayDoorCloser(this.plugin).close(new OuterDoor(this.plugin, id).getDisplay(), id, playerUUID);
                    } else if (rsp.getPreset().hasDoor()) {
                        new OuterMinecraftDoorCloser(this.plugin).close(new OuterDoor(this.plugin, id).getMinecraft(), id, playerUUID);
                    }
                }
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ABANDON_CLAIMED");
                this.plugin.getPM().callEvent((Event)new TARDISClaimEvent(player, tardis, current.location()));
            }
            if (this.plugin.getConfig().getBoolean("police_box.name_tardis")) {
                ChameleonPreset preset = tardis.getPreset();
                Sign sign = AbandonCommand.getSign(current.location(), current.direction(), preset);
                if (sign != null) {
                    SignSide front = sign.getSide(Side.FRONT);
                    String player_name = TARDISStaticUtils.getNick(player);
                    Object owner = preset.equals((Object)ChameleonPreset.GRAVESTONE) || preset.equals((Object)ChameleonPreset.PUNKED) || preset.equals((Object)ChameleonPreset.ROBOT) ? (player_name.length() > 14 ? player_name.substring(0, 14) : player_name) : (player_name.length() > 14 ? player_name.substring(0, 12) + "'s" : player_name + "'s");
                    switch (preset) {
                        case GRAVESTONE: {
                            front.line(3, (Component)Component.text((String)owner));
                            break;
                        }
                        case ANGEL: 
                        case JAIL: {
                            front.line(2, (Component)Component.text((String)owner));
                            break;
                        }
                        default: {
                            front.line(0, (Component)Component.text((String)owner));
                        }
                    }
                    sign.update();
                }
            }
        }
        return pu;
    }
}

