/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.monsters.judoon;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.custommodels.keys.ArrowVariant;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import me.eccentric_nz.tardisweepingangels.nms.TWAJudoon;
import me.eccentric_nz.tardisweepingangels.utils.ResetMonster;
import net.kyori.adventure.text.Component;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Husk;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class JudoonListener
implements Listener {
    private final TARDIS plugin;

    public JudoonListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    /*
     * Enabled aggressive block sorting
     */
    @EventHandler(priority=EventPriority.NORMAL)
    public void onDamageJudoon(EntityDamageByEntityEvent event) {
        String message;
        Entity entity = event.getEntity();
        if (!(entity instanceof Husk)) return;
        Husk husk = (Husk)entity;
        entity = event.getDamager();
        if (!(entity instanceof Player)) return;
        Player player = (Player)entity;
        if (!husk.getPersistentDataContainer().has(TARDISWeepingAngels.OWNER_UUID, TARDISWeepingAngels.PersistentDataTypeUUID)) return;
        if (!husk.getPersistentDataContainer().has(TARDISWeepingAngels.JUDOON, TARDISWeepingAngels.PersistentDataTypeUUID)) return;
        event.setCancelled(true);
        player.playSound(husk.getLocation(), "judoon", 1.0f, 1.0f);
        if (!TARDISPermission.hasPermission(player, "tardisweepingangels.judoon")) {
            return;
        }
        UUID judoonId = (UUID)husk.getPersistentDataContainer().get(TARDISWeepingAngels.OWNER_UUID, TARDISWeepingAngels.PersistentDataTypeUUID);
        net.minecraft.world.entity.Entity entity2 = ((CraftEntity)husk).getHandle();
        if (!player.getUniqueId().equals(judoonId)) {
            if (!TARDISWeepingAngels.UNCLAIMED.equals(judoonId)) return;
            UUID pid = player.getUniqueId();
            husk.getPersistentDataContainer().set(TARDISWeepingAngels.OWNER_UUID, TARDISWeepingAngels.PersistentDataTypeUUID, (Object)pid);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.MONSTERS, "WA_CLAIMED", "Judoon");
            if (!(entity2 instanceof TWAJudoon)) return;
            TWAJudoon judoon = (TWAJudoon)entity2;
            judoon.setOwnerUUID(pid);
            return;
        }
        if (!(entity2 instanceof TWAJudoon)) {
            new ResetMonster(this.plugin, (Entity)husk).reset();
            return;
        }
        TWAJudoon judoon = (TWAJudoon)entity2;
        int ammo = judoon.getAmmo();
        if (Tag.SHULKER_BOXES.isTagged((Keyed)player.getInventory().getItemInMainHand().getType())) {
            ItemStack box = player.getInventory().getItemInMainHand();
            BlockStateMeta bsm = (BlockStateMeta)box.getItemMeta();
            ShulkerBox shulkerBox = (ShulkerBox)bsm.getBlockState();
            Inventory inv = shulkerBox.getInventory();
            if (!inv.contains(Material.ARROW)) return;
            int a = inv.first(Material.ARROW);
            ItemStack arrows = inv.getItem(a);
            ItemMeta aim = arrows.getItemMeta();
            if (!aim.hasItemModel()) return;
            if (!ArrowVariant.JUDOON_AMMO.getKey().equals((Object)aim.getItemModel())) return;
            int remove = this.plugin.getMonstersConfig().getInt("judoon.ammunition") - ammo;
            if (arrows.getAmount() > remove) {
                arrows.setAmount(arrows.getAmount() - remove);
            } else {
                remove = arrows.getAmount();
                arrows = null;
            }
            inv.setItem(a, arrows);
            shulkerBox.update();
            bsm.setBlockState((BlockState)shulkerBox);
            box.setItemMeta((ItemMeta)bsm);
            judoon.setAmmo(ammo + remove);
            husk.customName((Component)Component.text((String)("Ammunition: " + (ammo + remove))));
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.MONSTERS, "WA_RELOADED", remove);
            return;
        }
        if (!judoon.isGuard()) {
            if (TARDISWeepingAngels.getPlayersWithGuards().contains(player.getUniqueId())) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.MONSTERS, "WA_GUARD");
                return;
            }
            judoon.setGuard(true);
            message = "WA_ACTION";
            husk.customName((Component)Component.text((String)("Ammunition: " + ammo)));
            husk.setCustomNameVisible(true);
            TARDISWeepingAngels.getGuards().add(judoon.getUUID());
            TARDISWeepingAngels.getPlayersWithGuards().add(player.getUniqueId());
        } else {
            judoon.setGuard(false);
            message = "WA_EASE";
            husk.setCustomNameVisible(false);
            TARDISWeepingAngels.getGuards().remove(judoon.getUUID());
            TARDISWeepingAngels.getPlayersWithGuards().remove(player.getUniqueId());
        }
        this.plugin.getMessenger().send((CommandSender)player, TardisModule.MONSTERS, message);
    }
}

