/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisvortexmanipulator.command;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.tardisvortexmanipulator.database.TVMResultSetManipulator;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TVMCommandGive {
    private final TARDIS plugin;
    private final int full;

    public TVMCommandGive(TARDIS plugin) {
        this.plugin = plugin;
        this.full = this.plugin.getVortexConfig().getInt("tachyon_use.max");
    }

    public boolean process(CommandSender sender, String[] args) {
        if (!TARDISPermission.hasPermission(sender, "tardis.admin")) {
            this.plugin.getMessenger().send(sender, TardisModule.VORTEX_MANIPULATOR, "VM_PERM_CMD");
            return true;
        }
        if (args.length < 3) {
            this.plugin.getMessenger().send(sender, TardisModule.VORTEX_MANIPULATOR, "VM_UUID");
            return true;
        }
        Player p = this.plugin.getServer().getPlayer(args[1]);
        if (p == null || !p.isOnline()) {
            this.plugin.getMessenger().send(sender, TardisModule.VORTEX_MANIPULATOR, "NOT_ONLINE");
            return true;
        }
        UUID uuid = p.getUniqueId();
        TVMResultSetManipulator rs = new TVMResultSetManipulator(this.plugin, uuid.toString());
        if (rs.resultSet()) {
            int amount;
            int tachyon_level = rs.getTachyonLevel();
            if (args[2].equalsIgnoreCase("full")) {
                amount = this.full;
            } else if (args[2].equalsIgnoreCase("empty")) {
                amount = 0;
            } else {
                try {
                    amount = Integer.parseInt(args[2]);
                }
                catch (NumberFormatException e) {
                    this.plugin.getMessenger().send(sender, TardisModule.VORTEX_MANIPULATOR, "VM_LAST_ARG");
                    return true;
                }
                amount = tachyon_level + amount > this.full ? this.full : (amount += tachyon_level);
            }
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("tachyon_level", amount);
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", uuid.toString());
            this.plugin.getQueryFactory().doUpdate("manipulator", set, where);
            this.plugin.getMessenger().send(sender, TardisModule.VORTEX_MANIPULATOR, "VM_TACHYON_SET", "" + amount);
        } else {
            this.plugin.getMessenger().send(sender, TardisModule.VORTEX_MANIPULATOR, "VM_NONE", p.getName());
        }
        return true;
    }
}

