/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.utility;

import com.google.gson.JsonElement;
import java.util.Locale;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;

public class ComponentUtils {
    public static TextComponent toWhite(String plain) {
        return (TextComponent)Component.text((String)plain, (TextColor)NamedTextColor.WHITE).decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE);
    }

    public static TextComponent toGold(String plain) {
        return (TextComponent)Component.text((String)plain, (TextColor)NamedTextColor.GOLD).decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE);
    }

    public static String stripColour(Component component) {
        return component == null ? "" : ((TextComponent)component).content();
    }

    public static boolean endsWith(Component component, String end) {
        return ComponentUtils.stripColour(component).endsWith(end);
    }

    public static boolean startsWith(Component component, String start) {
        return ComponentUtils.stripColour(component).startsWith(start);
    }

    public static int parseInt(Component component) {
        return Integer.parseInt(ComponentUtils.stripColour(component));
    }

    public static boolean parseBoolean(Component component) {
        return Boolean.parseBoolean(ComponentUtils.stripColour(component));
    }

    public static String toEnumUppercase(Component component) {
        return ComponentUtils.stripColour(component).replace(" ", "_").replace("-", "_").replace("3", "THREE").toUpperCase(Locale.ROOT);
    }

    public static JsonElement getJson(Component component) {
        GsonComponentSerializer serializer = GsonComponentSerializer.gson();
        return serializer.serializeToTree(component);
    }

    public static Component fromJson(JsonElement element) {
        GsonComponentSerializer serializer = GsonComponentSerializer.gson();
        return serializer.deserializeFromTree(element);
    }
}

