/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.update;

import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.commands.sudo.TARDISSudoTracker;
import me.eccentric_nz.TARDIS.customblocks.TARDISBlockDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.database.QueryFactory;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.Control;
import me.eccentric_nz.TARDIS.enumeration.SmelterChest;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.Updateable;
import me.eccentric_nz.TARDIS.update.TARDISSmelterCommand;
import me.eccentric_nz.TARDIS.update.TARDISVaultCommand;
import me.eccentric_nz.TARDIS.update.UpdateARS;
import me.eccentric_nz.TARDIS.update.UpdateDoor;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Repeater;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;

public class TARDISUpdateListener
implements Listener {
    private final TARDIS plugin;

    public TARDISUpdateListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onUpdateInteract(PlayerInteractEvent event) {
        Updateable updateable;
        if (event.getHand() == null || event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            return;
        }
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        boolean secondary = false;
        if (this.plugin.getTrackerKeeper().getUpdatePlayers().containsKey(playerUUID)) {
            updateable = Updateable.valueOf(TARDISStringUtils.toScoredUppercase(this.plugin.getTrackerKeeper().getUpdatePlayers().get(playerUUID)));
        } else if (this.plugin.getTrackerKeeper().getSecondary().containsKey(playerUUID)) {
            updateable = this.plugin.getTrackerKeeper().getSecondary().get(playerUUID);
            secondary = true;
        } else {
            if (player.isSneaking() && this.plugin.getTrackerKeeper().getSecondaryRemovers().containsKey(playerUUID)) {
                Block block = event.getClickedBlock();
                HashMap<String, Object> wherec = new HashMap<String, Object>();
                wherec.put("tardis_id", this.plugin.getTrackerKeeper().getSecondaryRemovers().get(playerUUID));
                String location = block.getType().equals((Object)Material.REPEATER) ? TARDISStaticLocationGetters.makeLocationStr(block.getLocation()) : block.getLocation().toString();
                wherec.put("location", location);
                wherec.put("secondary", 1);
                ResultSetControls rsc = new ResultSetControls(this.plugin, wherec, false);
                if (rsc.resultSet()) {
                    HashMap<String, Object> whered = new HashMap<String, Object>();
                    whered.put("c_id", rsc.getC_id());
                    new QueryFactory(this.plugin).doDelete("controls", whered);
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SEC_REMOVED");
                } else {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SEC_REMOVE_NO_MATCH");
                }
                this.plugin.getTrackerKeeper().getSecondaryRemovers().remove(playerUUID);
                return;
            }
            return;
        }
        if (!updateable.equals((Object)Updateable.BACKDOOR) && !this.plugin.getUtils().inTARDISWorld(player)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "UPDATE_IN_WORLD");
            this.plugin.getTrackerKeeper().getUpdatePlayers().remove(playerUUID);
            return;
        }
        String uuid = TARDISSudoTracker.SUDOERS.containsKey(playerUUID) ? TARDISSudoTracker.SUDOERS.get(playerUUID).toString() : playerUUID.toString();
        UUID tuuid = TARDISSudoTracker.SUDOERS.containsKey(playerUUID) ? TARDISSudoTracker.SUDOERS.get(playerUUID) : playerUUID;
        Block block = event.getClickedBlock();
        if (block != null) {
            Sign s;
            Object blockLocStr;
            Bisected bisected;
            Material blockType = block.getType();
            Location block_loc = block.getLocation();
            World bw = block_loc.getWorld();
            int bx = block_loc.getBlockX();
            int by = block_loc.getBlockY();
            int bz = block_loc.getBlockZ();
            BlockData data = block.getBlockData();
            if (blockType.equals((Object)Material.IRON_DOOR) && (bisected = (Bisected)data).getHalf().equals((Object)Bisected.Half.TOP)) {
                --by;
                block = block.getRelative(BlockFace.DOWN);
            }
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", uuid);
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (!rs.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TARDIS");
                this.plugin.getTrackerKeeper().getUpdatePlayers().remove(playerUUID);
                return;
            }
            Tardis tardis = rs.getTardis();
            int id = tardis.getTardisId();
            HashMap<String, Object> tid = new HashMap<String, Object>();
            HashMap<String, Object> set = new HashMap<String, Object>();
            tid.put("tardis_id", id);
            Object object = blockLocStr = updateable.isControl() ? block_loc.toString() : bw.getName() + ":" + bx + ":" + by + ":" + bz;
            if (secondary) {
                this.plugin.getTrackerKeeper().getSecondary().remove(playerUUID);
            } else {
                this.plugin.getTrackerKeeper().getUpdatePlayers().remove(playerUUID);
            }
            if (!updateable.isAnyBlock() && !updateable.getMaterialChoices().contains(blockType)) {
                this.plugin.debug(player.getName() + " tried to update a " + String.valueOf((Object)updateable) + "... the type of block clicked was " + String.valueOf(blockType));
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "UPDATE_BAD_CLICK", updateable.getName());
                return;
            }
            switch (updateable) {
                case BACKDOOR: 
                case DOOR: {
                    new UpdateDoor(this.plugin).process(updateable, block, secondary, id, player);
                    break;
                }
                case TELEPATHIC: {
                    this.plugin.getTrackerKeeper().getTelepathicPlacements().remove(playerUUID);
                    this.plugin.getQueryFactory().insertControl(id, 23, (String)blockLocStr, secondary ? 1 : 0);
                    Block detector = block;
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> detector.setBlockData(TARDISConstants.DAYLIGHT), 3L);
                    break;
                }
                case BEACON: {
                    set.put("beacon", blockLocStr);
                    this.plugin.getQueryFactory().doUpdate("tardis", set, tid);
                    break;
                }
                case ALLAY: 
                case BAMBOO: 
                case BIRDCAGE: 
                case FARM: 
                case IGLOO: 
                case IISTUBIL: 
                case HUTCH: 
                case LAVA: 
                case PEN: 
                case STABLE: 
                case STALL: 
                case VILLAGE: {
                    set.put(updateable.getName(), blockLocStr);
                    this.plugin.getQueryFactory().doUpdate("farming", set, tid);
                    break;
                }
                case CHARGING_SENSOR: 
                case FLIGHT_SENSOR: 
                case HANDBRAKE_SENSOR: 
                case MALFUNCTION_SENSOR: 
                case POWER_SENSOR: {
                    String tmp = updateable.toString().toLowerCase(Locale.ROOT);
                    String type = tmp.substring(0, tmp.length() - 7);
                    this.plugin.getQueryFactory().upsertSensor(tardis.getTardisId(), type, (String)blockLocStr);
                    if (updateable == Updateable.HANDBRAKE_SENSOR && !tardis.isHandbrakeOn() || updateable == Updateable.POWER_SENSOR && tardis.isPoweredOn()) {
                        block.setType(Material.REDSTONE_BLOCK);
                        break;
                    }
                    block.setType(Material.STONE);
                    break;
                }
                case CREEPER: {
                    blockLocStr = bw.getName() + ":" + bx + ".5:" + by + ":" + bz + ".5";
                    set.put("creeper", blockLocStr);
                    this.plugin.getQueryFactory().doUpdate("tardis", set, tid);
                    break;
                }
                case EPS: {
                    blockLocStr = bw.getName() + ":" + bx + ".5:" + (by + 1) + ":" + bz + ".5";
                    set.put("eps", blockLocStr);
                    this.plugin.getQueryFactory().doUpdate("tardis", set, tid);
                    break;
                }
                case RAIL: {
                    set.put("rail", blockLocStr);
                    this.plugin.getQueryFactory().doUpdate("tardis", set, tid);
                    break;
                }
                case CHAMELEON: {
                    this.plugin.getQueryFactory().insertControl(id, 31, (String)blockLocStr, secondary ? 1 : 0);
                    Sign cs = (Sign)block.getState();
                    SignSide front = cs.getSide(Side.FRONT);
                    front.line(0, (Component)Component.text((String)((String)this.plugin.getSigns().getStringList("chameleon").getFirst())));
                    front.line(1, (Component)Component.text((String)((String)this.plugin.getSigns().getStringList("chameleon").get(1))));
                    front.line(2, (Component)Component.empty());
                    front.line(3, (Component)Component.text((String)tardis.getPreset().toString()));
                    cs.update();
                    break;
                }
                case KEYBOARD: {
                    this.plugin.getQueryFactory().insertControl(id, 7, (String)blockLocStr, secondary ? 1 : 0);
                    Sign ks = (Sign)block.getState();
                    SignSide front = ks.getSide(Side.FRONT);
                    front.line(0, (Component)Component.text((String)((String)this.plugin.getSigns().getStringList("keyboard").getFirst())));
                    for (int i = 1; i < 4; ++i) {
                        front.line(i, (Component)Component.empty());
                    }
                    ks.update();
                    break;
                }
                case SAVE_SIGN: {
                    this.plugin.getQueryFactory().insertControl(id, 32, (String)blockLocStr, secondary ? 1 : 0);
                    Sign ss = (Sign)block.getState();
                    SignSide front = ss.getSide(Side.FRONT);
                    front.line(0, (Component)Component.text((String)"TARDIS"));
                    front.line(1, (Component)Component.text((String)((String)this.plugin.getSigns().getStringList("saves").getFirst())));
                    front.line(2, (Component)Component.text((String)((String)this.plugin.getSigns().getStringList("saves").get(1))));
                    front.line(3, (Component)Component.empty());
                    ss.update();
                    break;
                }
                case TERMINAL: {
                    this.plugin.getQueryFactory().insertControl(id, 9, (String)blockLocStr, secondary ? 1 : 0);
                    Sign ts = (Sign)block.getState();
                    SignSide front = ts.getSide(Side.FRONT);
                    front.line(0, (Component)Component.empty());
                    front.line(1, (Component)Component.text((String)((String)this.plugin.getSigns().getStringList("terminal").getFirst())));
                    front.line(2, (Component)Component.text((String)((String)this.plugin.getSigns().getStringList("terminal").get(1))));
                    front.line(3, (Component)Component.empty());
                    ts.update();
                    break;
                }
                case CONTROL: {
                    this.plugin.getQueryFactory().insertControl(id, 22, (String)blockLocStr, secondary ? 1 : 0);
                    Sign os = (Sign)block.getState();
                    SignSide front = os.getSide(Side.FRONT);
                    front.line(0, (Component)Component.empty());
                    front.line(1, (Component)Component.text((String)((String)this.plugin.getSigns().getStringList("control").getFirst())));
                    front.line(2, (Component)Component.text((String)((String)this.plugin.getSigns().getStringList("control").get(1))));
                    front.line(3, (Component)Component.empty());
                    os.update();
                    break;
                }
                case ARS: {
                    new UpdateARS(this.plugin).process(block, tardis.getSchematic(), id, uuid);
                    break;
                }
                case BACK: {
                    this.plugin.getQueryFactory().insertControl(id, 8, (String)blockLocStr, secondary ? 1 : 0);
                    ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
                    if (!rsc.resultSet()) break;
                    Current current = rsc.getCurrent();
                    HashMap<String, Object> setb = new HashMap<String, Object>();
                    setb.put("world", current.location().getWorld().getName());
                    setb.put("x", current.location().getBlockX());
                    setb.put("y", current.location().getBlockY());
                    setb.put("z", current.location().getBlockZ());
                    setb.put("direction", current.direction().toString());
                    setb.put("submarine", current.submarine() ? 1 : 0);
                    HashMap<String, Object> whereb = new HashMap<String, Object>();
                    whereb.put("tardis_id", id);
                    this.plugin.getQueryFactory().doUpdate("back", setb, whereb);
                    break;
                }
                case TEMPORAL: {
                    this.plugin.getQueryFactory().insertControl(id, 11, (String)blockLocStr, secondary ? 1 : 0);
                    Sign es = (Sign)block.getState();
                    SignSide front = es.getSide(Side.FRONT);
                    front.line(0, (Component)Component.empty());
                    front.line(1, (Component)Component.text((String)((String)this.plugin.getSigns().getStringList("temporal").getFirst())));
                    front.line(2, (Component)Component.text((String)((String)this.plugin.getSigns().getStringList("temporal").get(1))));
                    front.line(3, (Component)Component.empty());
                    es.update();
                    break;
                }
                case ADVANCED: 
                case STORAGE: {
                    this.plugin.getQueryFactory().insertControl(id, Control.getUPDATE_CONTROLS().get(updateable.getName()), (String)blockLocStr, secondary ? 1 : 0);
                    this.plugin.getUtils().updateStorageId(uuid, id);
                    block.setBlockData(TARDISConstants.BARRIER);
                    TARDISBlockDisplayItem tdi = updateable.equals((Object)Updateable.ADVANCED) ? TARDISBlockDisplayItem.ADVANCED_CONSOLE : TARDISBlockDisplayItem.DISK_STORAGE;
                    TARDISDisplayItemUtils.remove(block);
                    TARDISDisplayItemUtils.set(tdi, block, id);
                    break;
                }
                case INFO: {
                    this.plugin.getQueryFactory().insertControl(id, 13, (String)blockLocStr, secondary ? 1 : 0);
                    s = (Sign)block.getState();
                    SignSide front = s.getSide(Side.FRONT);
                    front.line(0, (Component)Component.text((String)"-----"));
                    front.line(1, (Component)Component.text((String)"TARDIS"));
                    front.line(2, (Component)Component.text((String)((String)this.plugin.getSigns().getStringList("info").getFirst())));
                    front.line(3, (Component)Component.text((String)((String)this.plugin.getSigns().getStringList("info").get(1))));
                    s.update();
                    break;
                }
                case THROTTLE: {
                    this.plugin.getQueryFactory().insertControl(id, 39, (String)blockLocStr, secondary ? 1 : 0);
                    Block rblock = block;
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        Repeater repeater = (Repeater)rblock.getBlockData();
                        repeater.setLocked(true);
                        repeater.setDelay(4);
                        rblock.setBlockData((BlockData)repeater);
                    }, 2L);
                    break;
                }
                case SMELT: 
                case FUEL: {
                    new TARDISSmelterCommand(this.plugin).addDropChest(player, updateable, id, block);
                    break;
                }
                case UNSORTED: {
                    new TARDISVaultCommand(this.plugin).addDropChest(player, id, block, SmelterChest.UNSORTED);
                    break;
                }
                case VAULT: {
                    new TARDISVaultCommand(this.plugin).addDropChest(player, id, block, SmelterChest.DROP);
                    break;
                }
                default: {
                    this.plugin.getQueryFactory().insertControl(id, Control.getUPDATE_CONTROLS().get(updateable.getName()), (String)blockLocStr, secondary ? 1 : 0);
                }
            }
            if (Tag.SIGNS.isTagged((Keyed)blockType)) {
                s = (Sign)block.getState();
                s.setWaxed(true);
                s.update();
            }
            if (!updateable.equals((Object)Updateable.FUEL) && !updateable.equals((Object)Updateable.SMELT)) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "UPDATE_SET", updateable.getName());
            }
            TARDISSudoTracker.SUDOERS.remove(playerUUID);
        }
    }
}

