/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.sonic;

import com.destroystokyo.paper.MaterialTags;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.custommodels.keys.SonicVariant;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.playerprefs.TARDISPrefsMenuInventory;
import me.eccentric_nz.TARDIS.sonic.SonicData;
import me.eccentric_nz.TARDIS.sonic.SonicLore;
import me.eccentric_nz.TARDIS.sonic.SonicUpgradeData;
import me.eccentric_nz.TARDIS.sonic.actions.SonicAdmin;
import me.eccentric_nz.TARDIS.sonic.actions.SonicAtmosphericExcitation;
import me.eccentric_nz.TARDIS.sonic.actions.SonicBlockConverter;
import me.eccentric_nz.TARDIS.sonic.actions.SonicBrush;
import me.eccentric_nz.TARDIS.sonic.actions.SonicDispersed;
import me.eccentric_nz.TARDIS.sonic.actions.SonicDisruptor;
import me.eccentric_nz.TARDIS.sonic.actions.SonicFreeze;
import me.eccentric_nz.TARDIS.sonic.actions.SonicIgnite;
import me.eccentric_nz.TARDIS.sonic.actions.SonicKnockback;
import me.eccentric_nz.TARDIS.sonic.actions.SonicPainter;
import me.eccentric_nz.TARDIS.sonic.actions.SonicRedstone;
import me.eccentric_nz.TARDIS.sonic.actions.SonicScanner;
import me.eccentric_nz.TARDIS.sonic.actions.SonicSound;
import me.eccentric_nz.TARDIS.sonic.actions.SonicStandard;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class SonicListener
implements Listener {
    private final TARDIS plugin;
    private final Set<Material> diamond = new HashSet<Material>();
    private final Set<Material> doors = new HashSet<Material>();
    private final Set<Material> redstone = new HashSet<Material>();
    private final Set<Material> ignite = new HashSet<Material>();
    private final Set<Material> suspicious = new HashSet<Material>();
    private final Set<Material> converts = new HashSet<Material>();

    public SonicListener(TARDIS plugin) {
        this.plugin = plugin;
        this.diamond.add(Material.COBWEB);
        this.diamond.add(Material.IRON_BARS);
        this.diamond.add(Material.SNOW);
        this.diamond.add(Material.SNOW_BLOCK);
        this.diamond.addAll(MaterialTags.GLASS.getValues());
        this.diamond.addAll(MaterialTags.GLASS_PANES.getValues());
        this.doors.addAll(Tag.DOORS.getValues());
        this.doors.addAll(Tag.TRAPDOORS.getValues());
        this.redstone.add(Material.DETECTOR_RAIL);
        this.redstone.add(Material.IRON_DOOR);
        this.redstone.add(Material.IRON_TRAPDOOR);
        this.redstone.add(Material.MUSHROOM_STEM);
        this.redstone.add(Material.PISTON);
        this.redstone.add(Material.STICKY_PISTON);
        this.redstone.add(Material.POWERED_RAIL);
        this.redstone.add(Material.REDSTONE_LAMP);
        this.redstone.add(Material.REDSTONE_WIRE);
        this.redstone.add(Material.COPPER_BULB);
        this.redstone.add(Material.EXPOSED_COPPER_BULB);
        this.redstone.add(Material.OXIDIZED_COPPER_BULB);
        this.redstone.add(Material.WAXED_COPPER_BULB);
        this.redstone.add(Material.WAXED_EXPOSED_COPPER_BULB);
        this.redstone.add(Material.WAXED_OXIDIZED_COPPER_BULB);
        this.redstone.add(Material.WAXED_WEATHERED_COPPER_BULB);
        this.redstone.add(Material.WEATHERED_COPPER_BULB);
        this.ignite.addAll(Tag.CAMPFIRES.getValues());
        this.ignite.addAll(Tag.CANDLES.getValues());
        this.ignite.addAll(Tag.CANDLE_CAKES.getValues());
        this.ignite.add(Material.NETHERRACK);
        this.ignite.add(Material.OBSIDIAN);
        this.ignite.add(Material.SOUL_SAND);
        this.ignite.add(Material.SOUL_SOIL);
        this.suspicious.add(Material.SUSPICIOUS_GRAVEL);
        this.suspicious.add(Material.SUSPICIOUS_SAND);
        this.converts.addAll(Tag.CONCRETE_POWDER.getValues());
        this.converts.add(Material.MUD);
        this.converts.add(Material.DIRT);
        this.converts.add(Material.COARSE_DIRT);
        this.converts.add(Material.ROOTED_DIRT);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInteract(PlayerInteractEvent event) {
        ItemMeta im;
        if (event.getHand() == null || event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            return;
        }
        Player player = event.getPlayer();
        long now = System.currentTimeMillis();
        ItemStack is = player.getInventory().getItemInMainHand();
        if (is.getType().equals((Object)Material.BLAZE_ROD) && is.hasItemMeta() && ComponentUtils.endsWith((im = is.getItemMeta()).displayName(), "Sonic Screwdriver")) {
            if (this.plugin.getConfig().getBoolean("sonic.charge")) {
                int charge;
                PersistentDataContainer pdc = im.getPersistentDataContainer();
                int needs = this.plugin.getConfig().getInt("sonic.usage");
                if (pdc.has(this.plugin.getSonicChargeKey(), PersistentDataType.INTEGER)) {
                    charge = (Integer)pdc.get(this.plugin.getSonicChargeKey(), PersistentDataType.INTEGER);
                    if (needs > charge) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SONIC_RECHARGE");
                        return;
                    }
                } else {
                    charge = 500;
                    HashMap<String, Object> set = new HashMap<String, Object>();
                    if (!pdc.has(this.plugin.getSonicUuidKey(), this.plugin.getPersistentDataTypeUUID())) {
                        UUID sonic_uuid = UUID.randomUUID();
                        pdc.set(this.plugin.getSonicUuidKey(), this.plugin.getPersistentDataTypeUUID(), (Object)sonic_uuid);
                        set.put("sonic_uuid", sonic_uuid.toString());
                        set.put("uuid", player.getUniqueId().toString());
                        if (im.hasLore()) {
                            List<Integer> settings = SonicData.getSonicData(im.lore());
                            for (int i = 0; i < settings.size(); ++i) {
                                set.put(SonicUpgradeData.upgrades.get(SonicUpgradeData.sonicKeys.get(i)), settings.get(i));
                            }
                        }
                        this.plugin.getQueryFactory().doInsert("sonic", set);
                    }
                }
                pdc.set(this.plugin.getSonicChargeKey(), PersistentDataType.INTEGER, (Object)(charge - needs));
                is.setItemMeta(im);
                SonicLore.setChargeLevel(is);
            }
            List lore = im.lore();
            Action action = event.getAction();
            if (action.equals((Object)Action.RIGHT_CLICK_AIR) && !player.isSneaking()) {
                UUID uuid = player.getUniqueId();
                if (this.plugin.getTrackerKeeper().getDispersed().containsKey(uuid)) {
                    SonicSound.playSonicSound(this.plugin, player, now, 3050L, "sonic_screwdriver");
                    SonicDispersed.assemble(this.plugin, player);
                } else if (lore != null && (lore.contains(Component.text((String)"Bio-scanner Upgrade")) || lore.contains(Component.text((String)"Knockback Upgrade")))) {
                    Entity target;
                    SonicSound.playSonicSound(this.plugin, player, now, 3050L, "sonic_screwdriver");
                    if (TARDISPermission.hasPermission(player, "tardis.sonic.freeze")) {
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                            Player target = SonicFreeze.getTargetPlayer(player);
                            if (target != null) {
                                SonicFreeze.immobilise(this.plugin, player, target);
                            }
                        }, 20L);
                    }
                    if (TARDISPermission.hasPermission(player, "tardis.sonic.knockback") && (target = SonicKnockback.getTargetEntity(player)) != null) {
                        SonicKnockback.knockback(player, target);
                    }
                }
                if (TARDISPermission.hasPermission(player, "tardis.sonic.standard")) {
                    Object display;
                    SonicStandard.action(this.plugin, player, now);
                    if (this.plugin.getTrackerKeeper().getFlyingReturnLocation().containsKey(uuid) && (display = (ItemDisplay)player.getPassengers().getFirst()) != null) {
                        ItemStack box = display.getItemStack();
                        ItemMeta meta = box.getItemMeta();
                        NamespacedKey model = meta.getItemModel();
                        String value = model.getKey();
                        if (this.plugin.getTrackerKeeper().getSonicDoorToggle().contains(uuid)) {
                            this.plugin.getTrackerKeeper().getSonicDoorToggle().remove(uuid);
                            NamespacedKey closed = NamespacedKey.fromString((String)value.replace("open", "closed"), (Plugin)this.plugin);
                            meta.setItemModel(closed);
                        } else {
                            this.plugin.getTrackerKeeper().getSonicDoorToggle().add(uuid);
                            NamespacedKey open = NamespacedKey.fromString((String)value.replace("closed", "open"), (Plugin)this.plugin);
                            meta.setItemModel(open);
                        }
                        box.setItemMeta(meta);
                        display.setItemStack(box);
                    }
                    return;
                }
            }
            if (action.equals((Object)Action.RIGHT_CLICK_AIR) && player.isSneaking() && TARDISPermission.hasPermission(player, "tardis.sonic.standard")) {
                player.openInventory(new TARDISPrefsMenuInventory(this.plugin, player.getUniqueId()).getInventory());
                return;
            }
            if (action.equals((Object)Action.RIGHT_CLICK_BLOCK)) {
                Block block = event.getClickedBlock();
                if (this.doors.contains(block.getType()) && player.hasPermission("tardis.admin") && lore != null && lore.contains(Component.text((String)"Admin Upgrade"))) {
                    SonicAdmin.displayInfo(this.plugin, player, block);
                }
                if (Tag.WALL_SIGNS.isTagged((Keyed)block.getType()) && TARDISPermission.hasPermission(player, "tardis.atmospheric")) {
                    SonicAtmosphericExcitation.makeItSnow(this.plugin, player, block);
                    return;
                }
                if (TARDISPermission.hasPermission(player, "tardis.sonic.arrow") && lore != null && lore.contains(Component.text((String)"Pickup Arrows Upgrade"))) {
                    if (!block.getType().isInteractable()) {
                        SonicSound.playSonicSound(this.plugin, player, now, 600L, "sonic_short");
                    }
                    for (Entity e : block.getWorld().getNearbyEntities(block.getLocation(), 2.0, 2.0, 2.0)) {
                        if (!(e instanceof Arrow)) continue;
                        Arrow arrow = (Arrow)e;
                        arrow.setPickupStatus(AbstractArrow.PickupStatus.ALLOWED);
                        return;
                    }
                }
                if (this.redstone.contains(block.getType()) && TARDISPermission.hasPermission(player, "tardis.sonic.redstone") && lore != null && lore.contains(Component.text((String)"Redstone Upgrade"))) {
                    SonicRedstone.togglePoweredState(this.plugin, player, block);
                    return;
                }
                if (this.converts.contains(block.getType()) && TARDISPermission.hasPermission(player, "tardis.sonic.conversion") && lore != null && lore.contains(Component.text((String)"Conversion Upgrade"))) {
                    SonicBlockConverter.transform(this.plugin, block, player);
                    SonicSound.playSonicSound(this.plugin, player, now, 600L, "sonic_short");
                    return;
                }
                if (this.suspicious.contains(block.getType()) && TARDISPermission.hasPermission(player, "tardis.sonic.brush") && lore != null && lore.contains(Component.text((String)"Brush Upgrade"))) {
                    SonicSound.playSonicSound(this.plugin, player, now, 600L, "sonic_short");
                    SonicBrush.dust(this.plugin, block, player);
                    return;
                }
                if (TARDISPermission.hasPermission(player, "tardis.sonic.emerald") && lore != null && lore.contains(Component.text((String)"Emerald Upgrade")) && !block.getType().isInteractable()) {
                    SonicSound.playSonicSound(this.plugin, player, now, 3050L, "sonic_screwdriver");
                    Location scanned = block.getLocation();
                    SonicScanner.scan(this.plugin, scanned, player);
                    if (!this.plugin.getUtils().inTARDISWorld(player)) {
                        new SonicData().saveOrUpdate(this.plugin, scanned.add(0.0, 1.0, 0.0).toString(), 0, is, player);
                    }
                }
            }
            if (action.equals((Object)Action.LEFT_CLICK_BLOCK)) {
                Block block = event.getClickedBlock();
                if (!player.isSneaking()) {
                    if ((block.getType().isBurnable() || this.ignite.contains(block.getType())) && TARDISPermission.hasPermission(player, "tardis.sonic.ignite") && lore != null && lore.contains(Component.text((String)"Ignite Upgrade"))) {
                        SonicSound.playSonicSound(this.plugin, player, now, 3050L, "sonic_short");
                        event.setCancelled(true);
                        SonicIgnite.ignite(this.plugin, block, player);
                    }
                    if (this.diamond.contains(block.getType()) && TARDISPermission.hasPermission(player, "tardis.sonic.diamond") && lore != null && lore.contains(Component.text((String)"Diamond Upgrade"))) {
                        SonicDisruptor.breakBlock(this.plugin, player, block);
                    }
                } else if (TARDISPermission.hasPermission(player, "tardis.sonic.paint") && lore != null && lore.contains(Component.text((String)"Painter Upgrade"))) {
                    event.setCancelled(true);
                    SonicPainter.paint(this.plugin, player, block);
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerFrozenMove(PlayerMoveEvent event) {
        if (this.plugin.getTrackerKeeper().getFrozenPlayers().contains(event.getPlayer().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onSonicDrop(PlayerDropItemEvent event) {
        ItemMeta im;
        Item item = event.getItemDrop();
        ItemStack is = item.getItemStack();
        if (is.getType().equals((Object)Material.BLAZE_ROD) && is.hasItemMeta() && ComponentUtils.endsWith((im = is.getItemMeta()).displayName(), "Sonic Screwdriver")) {
            CustomModelDataComponent component = im.getCustomModelDataComponent();
            if (!component.getFloats().isEmpty()) {
                if (((Float)component.getFloats().getFirst()).floatValue() > 200.0f) {
                    component.setFloats(List.of(Float.valueOf(((Float)component.getFloats().getFirst()).floatValue() - 100.0f)));
                    im.setCustomModelDataComponent(component);
                }
            } else {
                component.setFloats(SonicVariant.ELEVENTH.getFloats());
                im.setCustomModelDataComponent(component);
            }
            is.setItemMeta(im);
            item.setItemStack(is);
        }
    }
}

