/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.particles;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.particles.ParticleRunnable;
import me.eccentric_nz.TARDIS.rooms.eye.Capacitor;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.Vector;

public class Sphere
extends ParticleRunnable {
    public final Set<Vector> coords = new HashSet<Vector>();
    private final Location location;
    private final Capacitor capacitor;

    public Sphere(TARDIS plugin, UUID uuid, Location location, Capacitor capacitor) {
        super(plugin, uuid);
        this.location = location;
        this.capacitor = capacitor;
        this.init();
    }

    public void init() {
        for (double i = 0.0; i <= Math.PI; i += Math.PI / this.capacitor.getRings()) {
            double r = Math.sin(i);
            double y = this.capacitor.getRadius() * Math.cos(i);
            for (double a = 0.0; a < Math.PI * 2; a += Math.PI / this.capacitor.getRings()) {
                double x = this.capacitor.getRadius() * Math.cos(a) * r;
                double z = this.capacitor.getRadius() * Math.sin(a) * r;
                this.coords.add(new Vector(x, y, z));
            }
        }
        ItemDisplay display = TARDISDisplayItemUtils.get(this.location.getBlock());
        if (display == null) {
            display = (ItemDisplay)this.location.getWorld().spawnEntity(this.location, EntityType.ITEM_DISPLAY);
        }
        ItemStack is = ItemStack.of((Material)Material.MAGMA_BLOCK);
        ItemMeta im = is.getItemMeta();
        im.displayName((Component)Component.text((String)("Sphere " + TARDISStringUtils.capitalise(this.capacitor.toString()))));
        is.setItemMeta(im);
        display.setItemStack(is);
        display.setItemDisplayTransform(ItemDisplay.ItemDisplayTransform.GROUND);
    }

    @Override
    public void run() {
        if (this.playerInChunk(this.location)) {
            for (Vector v : this.coords) {
                this.location.add(v.getX(), v.getY(), v.getZ());
                this.spawnParticle(Particle.ENTITY_EFFECT, this.location, 3, 0.0, TARDISConstants.RANDOM.nextBoolean() ? Color.ORANGE : Color.YELLOW);
                this.location.subtract(v.getX(), v.getY(), v.getZ());
            }
        }
    }

    private boolean playerInChunk(Location location) {
        int r = location.getBlockY() % 16;
        int upperY = location.getBlockY() + (16 - r);
        int lowerY = location.getBlockY() - r;
        for (Entity e : location.getChunk().getEntities()) {
            Player p;
            int pl;
            if (!(e instanceof Player) || (pl = (p = (Player)e).getLocation().getBlockY()) >= upperY || pl <= lowerY) continue;
            return true;
        }
        return false;
    }
}

