/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.move;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.api.event.TARDISEnterEvent;
import me.eccentric_nz.TARDIS.api.event.TARDISExitEvent;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDoors;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.mobfarming.TARDISPet;
import me.eccentric_nz.TARDIS.mobfarming.types.TARDISCat;
import me.eccentric_nz.TARDIS.mobfarming.types.TARDISParrot;
import me.eccentric_nz.TARDIS.mobfarming.types.TARDISWolf;
import me.eccentric_nz.TARDIS.travel.TARDISDoorLocation;
import me.eccentric_nz.TARDIS.upgrades.SystemUpgradeRecord;
import me.eccentric_nz.TARDIS.utility.TARDISItemRenamer;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import net.kyori.adventure.text.Component;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wolf;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class DoorListener {
    public final float[][] adjustYaw = new float[4][8];
    public final TARDIS plugin;
    private final int player_artron;

    public DoorListener(TARDIS plugin) {
        this.plugin = plugin;
        this.player_artron = this.plugin.getArtronConfig().getInt("player");
        this.adjustYaw[0][0] = 0.0f;
        this.adjustYaw[0][1] = 45.0f;
        this.adjustYaw[0][2] = 90.0f;
        this.adjustYaw[0][3] = 135.0f;
        this.adjustYaw[0][4] = 180.0f;
        this.adjustYaw[0][5] = -45.0f;
        this.adjustYaw[0][6] = -90.0f;
        this.adjustYaw[0][7] = -135.0f;
        this.adjustYaw[1][0] = -90.0f;
        this.adjustYaw[1][1] = -45.0f;
        this.adjustYaw[1][2] = 0.0f;
        this.adjustYaw[1][3] = 45.0f;
        this.adjustYaw[1][4] = 90.0f;
        this.adjustYaw[1][5] = 135.0f;
        this.adjustYaw[1][6] = 180.0f;
        this.adjustYaw[1][7] = -135.0f;
        this.adjustYaw[2][0] = 135.0f;
        this.adjustYaw[2][1] = 180.0f;
        this.adjustYaw[2][2] = -90.0f;
        this.adjustYaw[2][3] = -45.0f;
        this.adjustYaw[2][4] = 0.0f;
        this.adjustYaw[2][5] = 45.0f;
        this.adjustYaw[2][6] = 90.0f;
        this.adjustYaw[2][7] = 135.0f;
        this.adjustYaw[3][0] = 90.0f;
        this.adjustYaw[3][1] = 135.0f;
        this.adjustYaw[3][2] = 180.0f;
        this.adjustYaw[3][3] = -45.0f;
        this.adjustYaw[3][4] = -90.0f;
        this.adjustYaw[3][5] = -135.0f;
        this.adjustYaw[3][6] = 0.0f;
        this.adjustYaw[3][7] = 45.0f;
    }

    public static TARDISDoorLocation getDoor(int doortype, int id) {
        TARDISDoorLocation tdl = new TARDISDoorLocation();
        HashMap<String, Object> wherei = new HashMap<String, Object>();
        wherei.put("door_type", doortype);
        wherei.put("tardis_id", id);
        ResultSetDoors rsd = new ResultSetDoors(TARDIS.plugin, wherei, false);
        if (rsd.resultSet()) {
            COMPASS d = rsd.getDoor_direction();
            tdl.setD(d);
            String doorLocStr = rsd.getDoor_location();
            World cw = TARDISStaticLocationGetters.getWorldFromSplitString(doorLocStr);
            tdl.setW(cw);
            Location tmp_loc = TARDISStaticLocationGetters.getLocationFromDB(doorLocStr);
            int getx = tmp_loc.getBlockX();
            int getz = tmp_loc.getBlockZ();
            switch (d) {
                case NORTH: {
                    tmp_loc.setX((double)getx + 0.5);
                    tmp_loc.setZ((double)getz - 0.5);
                    break;
                }
                case EAST: {
                    tmp_loc.setX((double)getx + 1.5);
                    tmp_loc.setZ((double)getz + 0.5);
                    break;
                }
                case SOUTH: {
                    tmp_loc.setX((double)getx + 0.5);
                    tmp_loc.setZ((double)getz + 1.5);
                    break;
                }
                default: {
                    tmp_loc.setX((double)getx - 0.5);
                    tmp_loc.setZ((double)getz + 0.5);
                }
            }
            tdl.setL(tmp_loc);
        }
        return tdl;
    }

    public void movePlayer(Player player, Location location, boolean exit, World from, boolean quotes, int sound, boolean minecart, boolean instant) {
        if (instant) {
            this.playDoorSound(player, sound, location, minecart);
            this.doPlayerMove(player, location, exit, from, quotes);
        } else {
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.playDoorSound(player, sound, location, minecart), 5L);
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.doPlayerMove(player, location, exit, from, quotes), 10L);
        }
    }

    private void doPlayerMove(Player player, Location location, boolean exit, World from, boolean quotes) {
        int i = TARDISConstants.RANDOM.nextInt(this.plugin.getGeneralKeeper().getQuotes().size());
        World to = location.getWorld();
        boolean allowFlight = player.getAllowFlight();
        boolean crossWorlds = from != to;
        boolean isSurvival = this.checkSurvival(to);
        player.teleport(location);
        if (player.getGameMode() == GameMode.CREATIVE || allowFlight && crossWorlds && !isSurvival) {
            player.setAllowFlight(true);
        }
        if (quotes) {
            if (TARDISConstants.RANDOM.nextInt(100) < 3) {
                this.plugin.getMessenger().sendEyebrows((CommandSender)player);
            } else {
                this.plugin.getMessenger().message((CommandSender)player, TardisModule.TARDIS, this.plugin.getGeneralKeeper().getQuotes().get(i));
            }
        }
        if (exit) {
            this.plugin.getPM().callEvent((Event)new TARDISExitEvent(player, to));
            HashMap<String, Object> where = new HashMap<String, Object>();
            UUID uuid = player.getUniqueId();
            where.put("uuid", uuid.toString());
            if (this.plugin.getTrackerKeeper().getHasTravelled().contains(uuid)) {
                this.plugin.getQueryFactory().alterEnergyLevel("player_prefs", this.player_artron, where, player);
                this.plugin.getTrackerKeeper().getHasTravelled().remove(uuid);
                new SystemUpgradeRecord(this.plugin).make(uuid.toString());
            }
            if (this.plugin.getTrackerKeeper().getSetTime().containsKey(uuid)) {
                this.setTemporalLocation(player, this.plugin.getTrackerKeeper().getSetTime().get(uuid), true);
                this.plugin.getTrackerKeeper().getSetTime().remove(uuid);
            } else {
                this.setTemporalLocation(player, -1L, true);
            }
            this.plugin.getTrackerKeeper().getEjecting().remove(uuid);
        } else {
            this.plugin.getPM().callEvent((Event)new TARDISEnterEvent(player, from));
            if (this.plugin.getConfig().getBoolean("creation.keep_night")) {
                this.setTemporalLocation(player, 18000L, false);
            }
            TARDISSounds.playTARDISHum(player);
        }
        this.giveKey(player);
    }

    public boolean checkSurvival(World world) {
        boolean bool = false;
        switch (this.plugin.getWorldManager()) {
            case MULTIVERSE: {
                bool = this.plugin.getMVHelper().isWorldSurvival(world);
                break;
            }
            case NONE: {
                bool = this.plugin.getPlanetsConfig().getString("planets." + world.getName() + ".gamemode").equalsIgnoreCase("SURVIVAL");
            }
        }
        return bool;
    }

    public void movePets(List<TARDISPet> pets, Location location, Player player, COMPASS direction, boolean enter) {
        Location pl = location.clone();
        World w = location.getWorld();
        if (enter) {
            pl.setZ(location.getZ() + 1.0);
        } else {
            switch (direction) {
                case NORTH: {
                    pl.setX(location.getX() + 1.0);
                    pl.setZ(location.getZ() + 1.0);
                    break;
                }
                case WEST: {
                    pl.setX(location.getX() + 1.0);
                    pl.setZ(location.getZ() - 1.0);
                    break;
                }
                case SOUTH: {
                    pl.setX(location.getX() - 1.0);
                    pl.setZ(location.getZ() - 1.0);
                    break;
                }
                default: {
                    pl.setX(location.getX() - 1.0);
                    pl.setZ(location.getZ() + 1.0);
                }
            }
        }
        block10: for (TARDISPet pet : pets) {
            String pet_name;
            this.plugin.setTardisSpawn(true);
            LivingEntity ent = (LivingEntity)w.spawnEntity(pl, pet.getType());
            if (ent.isDead()) {
                ent.remove();
                this.plugin.debug("Entity is dead! Spawning again...");
                ent = (LivingEntity)w.spawnEntity(pl, pet.getType());
            }
            if ((pet_name = pet.getName()) != null && !pet_name.isEmpty()) {
                ent.customName((Component)Component.text((String)pet.getName()));
            }
            ent.setHealth(pet.getHealth());
            ((Tameable)ent).setTamed(true);
            ((Tameable)ent).setOwner((AnimalTamer)player);
            switch (pet.getType()) {
                case WOLF: {
                    TARDISWolf tw = (TARDISWolf)pet;
                    Wolf wolf = (Wolf)ent;
                    wolf.setVariant(tw.getWolfVariant());
                    wolf.setCollarColor(tw.getCollarColour());
                    wolf.setSitting(pet.getSitting());
                    wolf.setAge(pet.getAge());
                    if (!pet.isBaby()) continue block10;
                    wolf.setBaby();
                    break;
                }
                case CAT: {
                    TARDISCat tc = (TARDISCat)pet;
                    Cat cat = (Cat)ent;
                    cat.setCollarColor(tc.getCollarColour());
                    cat.setCatType(tc.getCatType());
                    cat.setSitting(pet.getSitting());
                    cat.setAge(pet.getAge());
                    if (!pet.isBaby()) continue block10;
                    cat.setBaby();
                    break;
                }
                case PARROT: {
                    TARDISParrot tp = (TARDISParrot)pet;
                    Parrot parrot = (Parrot)ent;
                    parrot.setSitting(pet.getSitting());
                    parrot.setAge(pet.getAge());
                    if (pet.isBaby()) {
                        parrot.setBaby();
                    }
                    parrot.setVariant(tp.getParrotVariant());
                    if (tp.isOnLeftShoulder()) {
                        player.setShoulderEntityLeft((Entity)parrot);
                    }
                    if (!tp.isOnRightShoulder()) continue block10;
                    player.setShoulderEntityRight((Entity)parrot);
                    break;
                }
            }
        }
        pets.clear();
    }

    private void giveKey(Player player) {
        ResultSetPlayerPrefs rsp;
        String key;
        if (this.plugin.getConfig().getBoolean("travel.give_key") && !(key = (rsp = new ResultSetPlayerPrefs(this.plugin, player.getUniqueId().toString())).resultSet() ? (!rsp.getKey().isEmpty() ? rsp.getKey() : this.plugin.getConfig().getString("preferences.key")) : this.plugin.getConfig().getString("preferences.key")).equals("AIR")) {
            PlayerInventory inv = player.getInventory();
            Material m = Material.valueOf((String)key);
            ItemStack oh = inv.getItemInOffHand();
            if (!inv.contains(m) && !oh.getType().equals((Object)m)) {
                ItemStack is = ItemStack.of((Material)m, (int)1);
                TARDISItemRenamer ir = new TARDISItemRenamer(this.plugin, player, is);
                ir.setName("TARDIS Key", true);
                inv.addItem(new ItemStack[]{is});
                player.updateInventory();
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "KEY_REMIND");
            }
        }
    }

    public float adjustYaw(COMPASS d1, COMPASS d2) {
        return switch (d1) {
            case COMPASS.EAST -> this.adjustYaw[0][d2.ordinal()];
            case COMPASS.SOUTH -> this.adjustYaw[1][d2.ordinal()];
            case COMPASS.WEST -> this.adjustYaw[2][d2.ordinal()];
            default -> this.adjustYaw[3][d2.ordinal()];
        };
    }

    private void playDoorSound(Player player, int sound, Location location, boolean minecart) {
        switch (sound) {
            case 1: {
                if (!minecart) {
                    TARDISSounds.playTARDISSound(location, "tardis_door_open");
                    break;
                }
                player.playSound(player.getLocation(), Sound.BLOCK_IRON_DOOR_OPEN, 1.0f, 1.0f);
                break;
            }
            case 2: {
                if (!minecart) {
                    TARDISSounds.playTARDISSound(location, "tardis_door_close");
                    break;
                }
                player.playSound(player.getLocation(), Sound.BLOCK_IRON_DOOR_OPEN, 1.0f, 1.0f);
                break;
            }
            case 3: {
                if (!minecart) {
                    TARDISSounds.playTARDISSound(location, "tardis_enter");
                    break;
                }
                player.playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
                break;
            }
        }
    }

    private void setTemporalLocation(Player player, long ticks, boolean relative) {
        if (player.isOnline()) {
            if (ticks != -1L) {
                if (relative) {
                    player.resetPlayerTime();
                    long time = player.getPlayerTime();
                    time -= time % 24000L;
                    long calculatedtime = (time += 24000L + ticks) - player.getWorld().getTime();
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        player.setPlayerTime(calculatedtime, true);
                        if (this.plugin.getConfig().getBoolean("allow.perception_filter")) {
                            this.plugin.getFilter().addPerceptionFilter(player);
                        }
                        this.plugin.getTrackerKeeper().getTemporallyLocated().add(player.getUniqueId());
                    }, 10L);
                } else {
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.setPlayerTime(18000L, false), 10L);
                }
            } else {
                player.resetPlayerTime();
                boolean remove = true;
                Material m = this.plugin.getFigura().getShapedRecipes().get("Perception Filter").getResult().getType();
                for (ItemStack is : player.getInventory().getArmorContents()) {
                    if (is == null || !is.getType().equals((Object)m)) continue;
                    remove = false;
                    break;
                }
                if (remove && this.plugin.getTrackerKeeper().getTemporallyLocated().contains(player.getUniqueId())) {
                    if (this.plugin.getConfig().getBoolean("allow.perception_filter")) {
                        this.plugin.getFilter().removePerceptionFilter(player);
                    }
                    this.plugin.getTrackerKeeper().getTemporallyLocated().remove(player.getUniqueId());
                }
            }
        }
    }

    public void removeTraveller(UUID uuid) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", uuid.toString());
        this.plugin.getQueryFactory().doSyncDelete("travellers", where);
    }
}

