/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.arch.ArchInventory;
import me.eccentric_nz.TARDIS.arch.ArchPersister;
import me.eccentric_nz.TARDIS.autonomous.AutonomousDeath;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.flight.FlightReturnData;
import me.eccentric_nz.TARDIS.travel.save.TARDISDeathLocation;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngelSpawnEvent;
import me.eccentric_nz.tardisweepingangels.equip.Equipper;
import me.eccentric_nz.tardisweepingangels.nms.MonsterSpawner;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.persistence.PersistentDataType;

public class TARDISTimeLordDeathListener
implements Listener {
    private final TARDIS plugin;

    public TARDISTimeLordDeathListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onTimeLordDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        UUID uuid = player.getUniqueId();
        if (this.plugin.getConfig().getBoolean("allow.autonomous") && TARDISPermission.hasPermission(player, "tardis.autonomous")) {
            new AutonomousDeath(this.plugin).automate(player);
        }
        if (TARDISPermission.hasPermission(player, "tardis.save.death")) {
            TARDISDeathLocation death = new TARDISDeathLocation(this.plugin);
            Location location = death.getLocation(player);
            death.record(player, location);
        }
        if (this.plugin.getConfig().getBoolean("modules.weeping_angels") && this.plugin.getConfig().getBoolean("eye_of_harmony.ossified") && this.plugin.getTrackerKeeper().getEyeDamage().contains(uuid)) {
            Location l = player.getLocation();
            LivingEntity e = new MonsterSpawner().create(l, Monster.OSSIFIED);
            new Equipper(Monster.OSSIFIED, e, false).setHelmetAndInvisibility();
            this.plugin.getServer().getPluginManager().callEvent((Event)new TARDISWeepingAngelSpawnEvent((Entity)e, EntityType.ZOMBIE, Monster.OSSIFIED, l));
            String name = player.getName();
            e.customName((Component)Component.text((String)name));
            e.setCustomNameVisible(true);
        }
        this.plugin.getTrackerKeeper().getEyeDamage().remove(uuid);
        if (this.plugin.isDisguisesOnServer() && this.plugin.getConfig().getBoolean("arch.enabled") && this.plugin.getTrackerKeeper().getJohnSmith().containsKey(uuid)) {
            new ArchPersister(this.plugin).save(uuid);
            if (this.plugin.getConfig().getBoolean("arch.clear_inv_on_death")) {
                new ArchInventory().clear(uuid);
            }
        }
        if (this.plugin.getTrackerKeeper().getFlyingReturnLocation().containsKey(uuid)) {
            FlightReturnData frd = this.plugin.getTrackerKeeper().getFlyingReturnLocation().get(player.getUniqueId());
            this.plugin.getServer().getScheduler().cancelTask(frd.sound());
        } else if (player.getPersistentDataContainer().has(this.plugin.getLoopKey(), PersistentDataType.INTEGER)) {
            int task = (Integer)player.getPersistentDataContainer().get(this.plugin.getLoopKey(), PersistentDataType.INTEGER);
            this.plugin.getServer().getScheduler().cancelTask(task);
            player.getPersistentDataContainer().remove(this.plugin.getLoopKey());
        }
    }
}

