/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.flight;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.event.TARDISTravelEvent;
import me.eccentric_nz.TARDIS.database.data.Throticle;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetThrottle;
import me.eccentric_nz.TARDIS.enumeration.TravelType;
import me.eccentric_nz.TARDIS.flight.DematerialiseToVortex;
import me.eccentric_nz.TARDIS.flight.LoopingFlightSound;
import me.eccentric_nz.TARDIS.flight.MaterialseFromVortex;
import me.eccentric_nz.TARDIS.flight.TARDISHandbrake;
import me.eccentric_nz.TARDIS.flight.TravelBar;
import me.eccentric_nz.TARDIS.sensor.BeaconSensor;
import me.eccentric_nz.TARDIS.sensor.HandbrakeSensor;
import me.eccentric_nz.TARDIS.travel.TARDISMalfunction;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class TARDISTakeoff {
    private final TARDIS plugin;

    public TARDISTakeoff(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void run(int id, Block block, Location handbrake, Player player, boolean beac_on, String beacon, boolean bar, Throticle throticle) {
        if (block != null) {
            TARDISHandbrake.setLevers(block, false, true, handbrake.toString(), id, this.plugin);
        }
        if (this.plugin.getConfig().getBoolean("circuits.damage")) {
            this.plugin.getTrackerKeeper().getHasNotClickedHandbrake().remove(id);
        }
        TARDISSounds.playTARDISSound(handbrake, "tardis_handbrake_release");
        if (!beac_on && !beacon.isEmpty()) {
            new BeaconSensor().toggle(beacon, true);
        }
        new HandbrakeSensor(this.plugin, id).toggle();
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("handbrake_on", 0);
        HashMap<String, Object> whereh = new HashMap<String, Object>();
        whereh.put("tardis_id", id);
        this.plugin.getQueryFactory().doUpdate("tardis", set, whereh);
        this.plugin.getMessenger().sendStatus(player, "HANDBRAKE_OFF");
        this.plugin.getTrackerKeeper().getInVortex().add(id);
        if (!this.plugin.getTrackerKeeper().getMalfunction().containsKey(id)) {
            boolean malfunction = new TARDISMalfunction(this.plugin).isMalfunction();
            this.plugin.getTrackerKeeper().getMalfunction().put(id, malfunction);
        }
        new DematerialiseToVortex(this.plugin, id, player, handbrake, throticle).run();
        if (this.plugin.getTrackerKeeper().getHasDestination().containsKey(id)) {
            this.plugin.getPM().callEvent((Event)new TARDISTravelEvent(player, null, this.plugin.getTrackerKeeper().getHasDestination().get(id).travelType(), id));
            new MaterialseFromVortex(this.plugin, id, player, handbrake, throticle).run();
        } else {
            if (!this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new LoopingFlightSound(this.plugin, handbrake, id), throticle.throttle().getFlightTime());
            }
            this.plugin.getPM().callEvent((Event)new TARDISTravelEvent(player, null, TravelType.VORTEX, id));
        }
        if (bar) {
            new TravelBar(this.plugin, id).showTravelRemaining(player, throticle.throttle().getFlightTime(), true);
        }
    }

    public void run(int id, Player player, String beacon) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        where.put("type", 0);
        where.put("secondary", 0);
        ResultSetControls rs = new ResultSetControls(this.plugin, where, false);
        if (rs.resultSet()) {
            Location handbrake = TARDISStaticLocationGetters.getLocationFromBukkitString(rs.getLocation());
            String uuid = player.getUniqueId().toString();
            ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, uuid);
            boolean beac_on = true;
            boolean bar = false;
            if (rsp.resultSet()) {
                beac_on = rsp.isBeaconOn();
                bar = rsp.isTravelbarOn();
            }
            Throticle throticle = new ResultSetThrottle(this.plugin).getSpeedAndParticles(uuid);
            TARDISHandbrake.setLevers(handbrake.getBlock(), false, true, rs.getLocation(), rs.getTardis_id(), this.plugin);
            if (this.plugin.getConfig().getBoolean("circuits.damage")) {
                this.plugin.getTrackerKeeper().getHasNotClickedHandbrake().remove(id);
            }
            TARDISSounds.playTARDISSound(handbrake, "tardis_handbrake_release");
            if (!beac_on && !beacon.isEmpty()) {
                new BeaconSensor().toggle(beacon, true);
            }
            new HandbrakeSensor(this.plugin, id).toggle();
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("handbrake_on", 0);
            HashMap<String, Object> whereh = new HashMap<String, Object>();
            whereh.put("tardis_id", id);
            this.plugin.getQueryFactory().doUpdate("tardis", set, whereh);
            this.plugin.getMessenger().sendStatus(player, "HANDBRAKE_OFF");
            this.plugin.getTrackerKeeper().getInVortex().add(id);
            boolean malfunction = new TARDISMalfunction(this.plugin).isMalfunction();
            this.plugin.getTrackerKeeper().getMalfunction().put(id, malfunction);
            new DematerialiseToVortex(this.plugin, id, player, handbrake, throticle).run();
            if (this.plugin.getTrackerKeeper().getHasDestination().containsKey(id)) {
                new MaterialseFromVortex(this.plugin, id, player, handbrake, throticle).run();
            } else if (!this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new LoopingFlightSound(this.plugin, handbrake, id), throticle.throttle().getFlightTime());
            }
            if (bar) {
                new TravelBar(this.plugin, id).showTravelRemaining(player, throticle.throttle().getFlightTime(), true);
            }
        }
    }
}

