/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.files;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;

public class SystemUpgradesConfigUpdater {
    private final TARDIS plugin;
    private final FileConfiguration system_upgrades_config;
    private final HashMap<String, Integer> integerOptions = new HashMap();
    private final HashMap<String, List<String>> comments = new HashMap();

    public SystemUpgradesConfigUpdater(TARDIS plugin) {
        this.plugin = plugin;
        this.system_upgrades_config = plugin.getSystemUpgradesConfig();
        this.integerOptions.put("throttle.faster", 1000);
        this.integerOptions.put("throttle.rapid", 2000);
        this.integerOptions.put("throttle.warp", 3000);
        this.comments.put("branch", List.of("system upgrade costs", "https://tardis.pages.dev/system-upgrades#configuration-options"));
        this.comments.put("architecture", List.of("architecture branch"));
        this.comments.put("feature", List.of("feature branch"));
        this.comments.put("tools", List.of("tools branch"));
        this.comments.put("navigation", List.of("navigation branch"));
        this.comments.put("throttle", List.of("throttle branch"));
    }

    public void checkSystemUpgradesConfig() {
        List feature;
        int i = 0;
        for (Map.Entry<String, Integer> entry : this.integerOptions.entrySet()) {
            if (this.system_upgrades_config.contains(entry.getKey())) continue;
            this.system_upgrades_config.set(entry.getKey(), (Object)entry.getValue());
            ++i;
        }
        if (this.system_upgrades_config.contains("tools.biome_reader")) {
            this.system_upgrades_config.set("tools.biome_reader", null);
            this.system_upgrades_config.set("feature.saves", (Object)this.system_upgrades_config.getInt("navigation.saves"));
            this.system_upgrades_config.set("navigation.saves", null);
            this.system_upgrades_config.set("feature.monitor", (Object)this.system_upgrades_config.getInt("tools.monitor"));
            this.system_upgrades_config.set("tools.monitor", null);
            this.system_upgrades_config.set("feature.force_field", (Object)this.system_upgrades_config.getInt("tools.force_field"));
            this.system_upgrades_config.set("tools.force_field", null);
            this.system_upgrades_config.set("tools.telepathic_circuit", (Object)this.system_upgrades_config.getInt("navigation.telepathic_circuit"));
            this.system_upgrades_config.set("navigation.telepathic_circuit", null);
            this.system_upgrades_config.set("throttle.exterior_flight", (Object)4000);
            this.system_upgrades_config.set("navigation.exterior_flight", null);
            ++i;
        }
        if (this.system_upgrades_config.contains("throttle.exterior_flight") && this.system_upgrades_config.getInt("throttle.exterior_flight") == 3000) {
            this.system_upgrades_config.set("throttle.exterior_flight", (Object)4000);
            ++i;
        }
        if (this.system_upgrades_config.contains("tools.telepathic_circuit") && this.system_upgrades_config.getInt("tools.telepathic_circuit") == 0) {
            this.system_upgrades_config.set("tools.telepathic_circuit", (Object)2000);
            this.system_upgrades_config.set("feature.saves", (Object)1000);
            this.system_upgrades_config.set("feature.monitor", (Object)2000);
            this.system_upgrades_config.set("feature.force_field", (Object)3000);
            ++i;
        }
        if ((feature = this.system_upgrades_config.getComments("feature")).isEmpty()) {
            for (Map.Entry entry : this.comments.entrySet()) {
                this.system_upgrades_config.setComments((String)entry.getKey(), (List)entry.getValue());
                ++i;
            }
        }
        try {
            if (i > 0) {
                this.system_upgrades_config.save(new File(this.plugin.getDataFolder(), "system_upgrades.yml"));
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Added " + i + " new items to system_upgrades.yml");
            }
        }
        catch (IOException io) {
            this.plugin.debug("Could not save system_upgrades.yml, " + io.getMessage());
        }
    }
}

