/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.destroyers;

import java.util.Collections;
import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.chameleon.utils.TARDISChameleonCircuit;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDoors;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.destroyers.DematerialiseBlockPreset;
import me.eccentric_nz.TARDIS.destroyers.DematerialiseModelledPreset;
import me.eccentric_nz.TARDIS.destroyers.DestroyData;
import me.eccentric_nz.TARDIS.destroyers.InstantPresetDestroyer;
import me.eccentric_nz.TARDIS.enumeration.Adaption;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.junk.JunkDestroyer;
import me.eccentric_nz.TARDIS.utility.TARDISBlockSetters;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.plugin.Plugin;

public class PresetDestroyerFactory {
    private final TARDIS plugin;

    public PresetDestroyerFactory(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void destroyPreset(DestroyData dd) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", dd.getTardisID());
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (rs.resultSet()) {
            Tardis tardis = rs.getTardis();
            ChameleonPreset demat = tardis.getDemat();
            ChameleonPreset preset = tardis.getPreset();
            if (!dd.getLocation().getWorld().isChunkLoaded(dd.getLocation().getChunk())) {
                dd.getLocation().getWorld().loadChunk(dd.getLocation().getChunk());
            }
            if (!demat.equals((Object)ChameleonPreset.INVISIBLE)) {
                int loops;
                Material cham_id = Material.LIGHT_GRAY_TERRACOTTA;
                if (tardis.getAdaption().equals((Object)Adaption.BIOME) && demat.equals((Object)ChameleonPreset.FACTORY) || demat.equals((Object)ChameleonPreset.SUBMERGED) || tardis.getAdaption().equals((Object)Adaption.BLOCK)) {
                    Block chameleonBlock = dd.getLocation().getBlock().getType() == Material.SNOW ? dd.getLocation().getBlock() : dd.getLocation().getBlock().getRelative(BlockFace.DOWN);
                    TARDISChameleonCircuit tcc = new TARDISChameleonCircuit(this.plugin);
                    cham_id = tcc.getChameleonBlock(chameleonBlock, dd.getPlayer());
                }
                if ((loops = dd.getThrottle().getLoops()) == 3) {
                    TARDISSounds.playTARDISSound(dd.getLocation(), "tardis_takeoff_fast");
                    if (dd.getPlayer() != null && dd.getPlayer().getPlayer() != null && this.plugin.getUtils().inTARDISWorld(dd.getPlayer().getPlayer())) {
                        TARDISSounds.playTARDISSound(dd.getPlayer().getPlayer().getLocation(), "tardis_takeoff_fast");
                    }
                }
                if (preset.equals((Object)ChameleonPreset.JUNK_MODE)) {
                    dd.setThrottle(SpaceTimeThrottle.JUNK);
                }
                if (demat.equals((Object)ChameleonPreset.JUNK)) {
                    JunkDestroyer runnable = new JunkDestroyer(this.plugin, dd);
                    int taskID = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)runnable, 10L, 20L);
                    runnable.setTask(taskID);
                } else {
                    this.plugin.getTrackerKeeper().getDematerialising().add(dd.getTardisID());
                    if (demat.equals((Object)ChameleonPreset.SWAMP)) {
                        this.destroyDoor(dd.getTardisID());
                    }
                    if (demat.usesArmourStand()) {
                        DematerialiseModelledPreset frame = new DematerialiseModelledPreset(this.plugin, dd, demat);
                        int taskID = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)frame, 10L, 20L);
                        frame.setTask(taskID);
                    } else {
                        DematerialiseBlockPreset runnable = new DematerialiseBlockPreset(this.plugin, dd, demat, cham_id.createBlockData());
                        int taskID = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)runnable, 10L, 20L);
                        runnable.setTask(taskID);
                    }
                }
            } else {
                new InstantPresetDestroyer(this.plugin).instaDestroyPreset(dd, dd.isHide(), demat);
            }
        }
    }

    public void destroyDoor(int id) {
        Location l;
        String dl;
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        where.put("door_type", 0);
        ResultSetDoors rsd = new ResultSetDoors(this.plugin, where, false);
        if (rsd.resultSet() && (dl = rsd.getDoor_location()) != null && (l = TARDISStaticLocationGetters.getLocationFromDB(dl)) != null) {
            Block b = l.getBlock();
            b.setBlockData(TARDISConstants.AIR);
            b.getRelative(BlockFace.UP).setBlockData(TARDISConstants.AIR);
        }
    }

    public void destroySign(Location l, COMPASS d, ChameleonPreset p) {
        int signx;
        World w = l.getWorld();
        int signy = switch (p) {
            case ChameleonPreset.GAZEBO, ChameleonPreset.JAIL, ChameleonPreset.SHROOM, ChameleonPreset.SWAMP -> 3;
            case ChameleonPreset.TORCH, ChameleonPreset.TOILET, ChameleonPreset.TOPSYTURVEY -> 1;
            case ChameleonPreset.APPERTURE, ChameleonPreset.ANGEL, ChameleonPreset.LAMP -> 0;
            default -> 2;
        };
        TARDISBlockSetters.setBlock(w, l.getBlockX() + signx, l.getBlockY() + signy, l.getBlockZ() + signz, Material.AIR);
        if (p.equals((Object)ChameleonPreset.SWAMP)) {
            TARDISBlockSetters.setBlock(w, l.getBlockX() + signx, l.getBlockY(), l.getBlockZ() + signz, Material.AIR);
        }
    }

    public void destroyHandbrake(Location l, COMPASS d) {
        int lx;
        int lz = switch (d) {
            case COMPASS.EAST -> {
                lx = -1;
                yield 1;
            }
            case COMPASS.SOUTH -> {
                lx = -1;
                yield -1;
            }
            case COMPASS.WEST -> {
                lx = 1;
                yield -1;
            }
            default -> {
                lx = 1;
                yield 1;
            }
        };
        World w = l.getWorld();
        int tx = l.getBlockX() + lx;
        int ty = l.getBlockY() + 2;
        int tz = l.getBlockZ() + lz;
        TARDISBlockSetters.setBlock(w, tx, ty, tz, Material.AIR);
    }

    public void destroyLamp(Location l, ChameleonPreset p) {
        World w = l.getWorld();
        int tx = l.getBlockX();
        int ty = l.getBlockY() + 3;
        int tz = l.getBlockZ();
        if (p.equals((Object)ChameleonPreset.CAKE)) {
            for (int i = tx - 1; i < tx + 2; ++i) {
                for (int j = tz - 1; j < tz + 2; ++j) {
                    TARDISBlockSetters.setBlock(w, i, ty, j, Material.AIR);
                }
            }
        } else {
            TARDISBlockSetters.setBlock(w, tx, ty, tz, Material.AIR);
        }
    }

    public void destroyDuckEyes(Location l, COMPASS d) {
        int rightx;
        int leftz;
        int leftx;
        World w = l.getWorld();
        int eyey = l.getBlockY() + 3;
        int rightz = switch (d) {
            case COMPASS.NORTH -> {
                leftx = l.getBlockX() - 1;
                leftz = l.getBlockZ() + 1;
                rightx = l.getBlockX() + 1;
                yield l.getBlockZ() + 1;
            }
            case COMPASS.WEST -> {
                leftx = l.getBlockX() + 1;
                leftz = l.getBlockZ() + 1;
                rightx = l.getBlockX() + 1;
                yield l.getBlockZ() - 1;
            }
            case COMPASS.SOUTH -> {
                leftx = l.getBlockX() + 1;
                leftz = l.getBlockZ() - 1;
                rightx = l.getBlockX() - 1;
                yield l.getBlockZ() - 1;
            }
            default -> {
                leftx = l.getBlockX() - 1;
                leftz = l.getBlockZ() - 1;
                rightx = l.getBlockX() - 1;
                yield l.getBlockZ() + 1;
            }
        };
        TARDISBlockSetters.setBlock(w, leftx, eyey, leftz, Material.AIR);
        TARDISBlockSetters.setBlock(w, rightx, eyey, rightz, Material.AIR);
    }

    public void destroyMineshaftTorches(Location l, COMPASS d) {
        int rightx;
        int leftz;
        int leftx;
        World w = l.getWorld();
        int eyey = l.getBlockY() + 2;
        int rightz = switch (d) {
            case COMPASS.SOUTH, COMPASS.NORTH -> {
                leftx = l.getBlockX() - 1;
                leftz = l.getBlockZ();
                rightx = l.getBlockX() + 1;
                yield l.getBlockZ();
            }
            default -> {
                leftx = l.getBlockX();
                leftz = l.getBlockZ() - 1;
                rightx = l.getBlockX();
                yield l.getBlockZ() + 1;
            }
        };
        TARDISBlockSetters.setBlock(w, leftx, eyey, leftz, Material.AIR);
        TARDISBlockSetters.setBlock(w, rightx, eyey, rightz, Material.AIR);
    }

    public void destroyLampTrapdoors(Location l, COMPASS d) {
        Block lamp = l.getBlock().getRelative(BlockFace.UP, 3).getRelative(this.plugin.getPresetBuilder().getOppositeFace(d));
        this.plugin.getGeneralKeeper().getFaces().forEach(f -> lamp.getRelative(f).setBlockData(TARDISConstants.AIR));
    }

    public void destroyPistons(Location l) {
        Block piston = l.getBlock();
        Block piston_head = l.getBlock().getRelative(BlockFace.UP);
        this.plugin.getGeneralKeeper().getFaces().forEach(f -> piston.getRelative(f).setBlockData(TARDISConstants.AIR));
        this.plugin.getGeneralKeeper().getFaces().forEach(f -> piston_head.getRelative(f).setBlockData(TARDISConstants.AIR));
    }

    public void removeBlockProtection(int id) {
        HashMap<String, Object> whereb = new HashMap<String, Object>();
        whereb.put("tardis_id", id);
        whereb.put("police_box", 1);
        this.plugin.getQueryFactory().doDelete("blocks", whereb);
        this.plugin.getGeneralKeeper().getProtectBlockMap().values().removeAll(Collections.singleton(id));
    }
}

