/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;

public class ResultSetDoors {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final HashMap<String, Object> where;
    private final boolean multiple;
    private final ArrayList<HashMap<String, String>> data = new ArrayList();
    private final String prefix;
    private int door_id;
    private int tardis_id;
    private int door_type;
    private String door_location;
    private COMPASS door_direction;
    private boolean locked;

    public ResultSetDoors(TARDIS plugin, HashMap<String, Object> where, boolean multiple) {
        this.plugin = plugin;
        this.where = where;
        this.multiple = multiple;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block24: {
            Statement statement = null;
            ResultSet rs = null;
            Object wheres = "";
            if (this.where != null) {
                StringBuilder sbw = new StringBuilder();
                this.where.forEach((key, value) -> sbw.append((String)key).append(" = ? AND "));
                wheres = " WHERE " + sbw.substring(0, sbw.length() - 5);
            }
            String query = "SELECT * FROM " + this.prefix + "doors" + (String)wheres;
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                if (this.where != null) {
                    int s = 1;
                    for (Map.Entry<String, Object> entry : this.where.entrySet()) {
                        if (entry.getValue() instanceof String) {
                            statement.setString(s, entry.getValue().toString());
                        } else {
                            statement.setInt(s, (Integer)entry.getValue());
                        }
                        ++s;
                    }
                    this.where.clear();
                }
                if ((rs = statement.executeQuery()).isBeforeFirst()) {
                    while (rs.next()) {
                        if (this.multiple) {
                            HashMap<String, String> row = new HashMap<String, String>();
                            ResultSetMetaData rsmd = rs.getMetaData();
                            int columns = rsmd.getColumnCount();
                            for (int i = 1; i < columns + 1; ++i) {
                                row.put(rsmd.getColumnName(i).toLowerCase(Locale.ROOT), rs.getString(i));
                            }
                            this.data.add(row);
                        }
                        this.door_id = rs.getInt("door_id");
                        this.tardis_id = rs.getInt("tardis_id");
                        this.door_type = rs.getInt("door_type");
                        this.door_location = rs.getString("door_location");
                        this.door_direction = COMPASS.valueOf(rs.getString("door_direction"));
                        this.locked = rs.getBoolean("locked");
                    }
                    break block24;
                }
                boolean row = false;
                return row;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for doors table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing doors table! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public int getDoor_id() {
        return this.door_id;
    }

    public int getTardis_id() {
        return this.tardis_id;
    }

    public int getDoor_type() {
        return this.door_type;
    }

    public String getDoor_location() {
        return this.door_location;
    }

    public COMPASS getDoor_direction() {
        return this.door_direction;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public ArrayList<HashMap<String, String>> getData() {
        return this.data;
    }
}

