/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.CircuitChecker;
import me.eccentric_nz.TARDIS.control.TARDISInfoMenuButton;
import me.eccentric_nz.TARDIS.control.TARDISSaveSign;
import me.eccentric_nz.TARDIS.control.TARDISScanner;
import me.eccentric_nz.TARDIS.control.actions.ARSAction;
import me.eccentric_nz.TARDIS.control.actions.ChameleonSignAction;
import me.eccentric_nz.TARDIS.control.actions.CloisterBellAction;
import me.eccentric_nz.TARDIS.control.actions.ControlMenuAction;
import me.eccentric_nz.TARDIS.control.actions.CustardCreamAction;
import me.eccentric_nz.TARDIS.control.actions.DifferentiatorAction;
import me.eccentric_nz.TARDIS.control.actions.DiskStorageAction;
import me.eccentric_nz.TARDIS.control.actions.FastReturnAction;
import me.eccentric_nz.TARDIS.control.actions.FlightModeAction;
import me.eccentric_nz.TARDIS.control.actions.ForceFieldAction;
import me.eccentric_nz.TARDIS.control.actions.HandlesAction;
import me.eccentric_nz.TARDIS.control.actions.LightSwitchAction;
import me.eccentric_nz.TARDIS.control.actions.MazeAction;
import me.eccentric_nz.TARDIS.control.actions.RandomAction;
import me.eccentric_nz.TARDIS.control.actions.RepeaterAction;
import me.eccentric_nz.TARDIS.control.actions.ShellRoomAction;
import me.eccentric_nz.TARDIS.control.actions.SiegeAction;
import me.eccentric_nz.TARDIS.control.actions.TelevisionAction;
import me.eccentric_nz.TARDIS.control.actions.TemporarlLocatorAction;
import me.eccentric_nz.TARDIS.control.actions.TerminalAction;
import me.eccentric_nz.TARDIS.control.actions.ThrottleAction;
import me.eccentric_nz.TARDIS.control.actions.WeatherAction;
import me.eccentric_nz.TARDIS.control.actions.ZeroRoomAction;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetJunk;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.Control;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.floodgate.FloodgateSavesForm;
import me.eccentric_nz.TARDIS.floodgate.TARDISFloodgate;
import me.eccentric_nz.TARDIS.move.BlackWoolToggler;
import me.eccentric_nz.TARDIS.rooms.eye.EyeOfHarmonyAction;
import me.eccentric_nz.TARDIS.rooms.happy.HappyGhastRelease;
import me.eccentric_nz.TARDIS.upgrades.SystemTree;
import me.eccentric_nz.TARDIS.upgrades.SystemUpgradeChecker;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.data.type.Repeater;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;

public class ControlListener
implements Listener {
    private final TARDIS plugin;
    private final List<Material> validBlocks = new ArrayList<Material>();
    private final List<Integer> onlythese = List.of(1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 16, 17, 20, 21, 22, 25, 26, 28, 29, 30, 31, 32, 33, 35, 38, 39, 40, 41, 42, 43, 47, 54, 55, 58);
    private final Set<UUID> cooldown = new HashSet<UUID>();

    public ControlListener(TARDIS plugin) {
        this.plugin = plugin;
        this.validBlocks.add(Material.COMPARATOR);
        this.validBlocks.add(Material.DISPENSER);
        this.validBlocks.add(Material.LEVER);
        this.validBlocks.add(Material.MUSHROOM_STEM);
        this.validBlocks.add(Material.BARRIER);
        this.validBlocks.add(Material.NOTE_BLOCK);
        this.validBlocks.add(Material.REPEATER);
        this.validBlocks.add(Material.STONE_PRESSURE_PLATE);
        this.validBlocks.addAll(Tag.ALL_SIGNS.getValues());
        this.validBlocks.addAll(Tag.BUTTONS.getValues());
        this.validBlocks.addAll(Tag.WOODEN_PRESSURE_PLATES.getValues());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onControlInteract(PlayerInteractEvent event) {
        Material blockType;
        Action action = event.getAction();
        if ((event.getHand() == null || event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) && action != Action.PHYSICAL) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        if (block != null && this.validBlocks.contains(blockType = block.getType())) {
            Repeater repeater;
            Location blockLocation = block.getLocation();
            Object locStr = blockLocation.toString();
            if (blockType.equals((Object)Material.REPEATER) && !(repeater = (Repeater)block.getBlockData()).isLocked()) {
                locStr = blockLocation.getWorld().getName() + ":" + blockLocation.getBlockX() + ":" + blockLocation.getBlockY() + ":" + blockLocation.getBlockZ();
            }
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("location", locStr);
            ResultSetControls rsc = new ResultSetControls(this.plugin, where, false);
            if (rsc.resultSet()) {
                int id = rsc.getTardis_id();
                int type = rsc.getType();
                if (this.plugin.getTrackerKeeper().getJohnSmith().containsKey(player.getUniqueId()) && type != 13) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ISO_HANDS_OFF");
                    return;
                }
                if (!this.onlythese.contains(type)) {
                    return;
                }
                Control control = Control.getById().get(type);
                HashMap<String, Object> whereid = new HashMap<String, Object>();
                whereid.put("tardis_id", id);
                ResultSetTardis rs = new ResultSetTardis(this.plugin, whereid, "", false);
                if (rs.resultSet()) {
                    Tardis tardis = rs.getTardis();
                    if (tardis.getPreset().equals((Object)ChameleonPreset.JUNK)) {
                        return;
                    }
                    if (!tardis.isTardisInit()) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ENERGY_NO_INIT");
                        return;
                    }
                    if (tardis.isIsomorphicOn() && !player.getUniqueId().equals(tardis.getUuid())) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ISO_HANDS_OFF");
                        return;
                    }
                    if (this.plugin.getConfig().getBoolean("allow.power_down") && !tardis.isPoweredOn() && !control.allowUnpowered()) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "POWER_DOWN");
                        return;
                    }
                    if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id) && control.isNoSiege()) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
                        return;
                    }
                    boolean lights = tardis.isLightsOn();
                    if (!lights && type == 12 && this.plugin.getConfig().getBoolean("allow.power_down") && !tardis.isPoweredOn()) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "POWER_DOWN");
                        return;
                    }
                    UUID ownerUUID = tardis.getUuid();
                    UUID playerUUID = player.getUniqueId();
                    CircuitChecker tcc = null;
                    if (this.plugin.getConfig().getBoolean("difficulty.circuits")) {
                        tcc = new CircuitChecker(this.plugin, id);
                        tcc.getCircuits();
                    }
                    if (action == Action.RIGHT_CLICK_BLOCK) {
                        switch (type) {
                            case 1: {
                                new RandomAction(this.plugin).process(this.cooldown, player, id, tardis, rsc.getSecondary());
                                break;
                            }
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: {
                                new RepeaterAction(this.plugin).announce(player, block, type);
                                break;
                            }
                            case 8: {
                                new FastReturnAction(this.plugin).clickButton(player, id, tardis);
                                break;
                            }
                            case 9: {
                                new TerminalAction(this.plugin).openGUI(player, id, tardis, tcc);
                                break;
                            }
                            case 10: {
                                new ARSAction(this.plugin).openGUI(player, tardis, tcc, id);
                                break;
                            }
                            case 11: {
                                new TemporarlLocatorAction(this.plugin).openGUI(player, tcc);
                                break;
                            }
                            case 12: {
                                new LightSwitchAction(this.plugin, id, lights, player, tardis.getSchematic().getLights()).flickSwitch();
                                break;
                            }
                            case 13: {
                                new TARDISInfoMenuButton(this.plugin, player).clickButton();
                                break;
                            }
                            case 14: {
                                new DiskStorageAction(this.plugin).openGUI(ownerUUID, player, id, block);
                                break;
                            }
                            case 16: {
                                new ZeroRoomAction(this.plugin).doEntry(player, tardis, id);
                                break;
                            }
                            case 17: {
                                new ZeroRoomAction(this.plugin).doExit(player, id);
                                break;
                            }
                            case 20: {
                                new BlackWoolToggler(this.plugin).toggleBlocks(id, player);
                                break;
                            }
                            case 21: {
                                new SiegeAction(this.plugin).clickButton(tcc, player, tardis.isPoweredOn(), id);
                                break;
                            }
                            case 22: {
                                event.setCancelled(true);
                                new ControlMenuAction(this.plugin).openGUI(player, id);
                                break;
                            }
                            case 25: {
                                new ShellRoomAction(this.plugin).openGUI(player, id);
                                break;
                            }
                            case 26: {
                                new HandlesAction(this.plugin).cyberIt(player);
                                break;
                            }
                            case 28: {
                                event.setCancelled(true);
                                new CustardCreamAction(this.plugin, player, block, id).dispense();
                                break;
                            }
                            case 29: {
                                new ForceFieldAction(this.plugin).toggleSheilds(player, blockLocation, tardis.getArtronLevel());
                                break;
                            }
                            case 30: {
                                new FlightModeAction(this.plugin).setMode(ownerUUID.toString(), player);
                                break;
                            }
                            case 31: {
                                new ChameleonSignAction(this.plugin).openGUI(player, tardis, id);
                                break;
                            }
                            case 32: {
                                if (this.plugin.getConfig().getBoolean("difficulty.system_upgrades") && !new SystemUpgradeChecker(this.plugin).has(playerUUID.toString(), SystemTree.SAVES)) {
                                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Saves");
                                    return;
                                }
                                if (TARDISFloodgate.isFloodgateEnabled() && TARDISFloodgate.isBedrockPlayer(playerUUID)) {
                                    new FloodgateSavesForm(this.plugin, playerUUID, id).send();
                                    break;
                                }
                                new TARDISSaveSign(this.plugin).openGUI(player, id);
                                break;
                            }
                            case 33: {
                                new TARDISScanner(this.plugin).scan(id, player, tardis.getRenderer(), tardis.getArtronLevel());
                                break;
                            }
                            case 35: {
                                new CloisterBellAction(this.plugin).ring(id, tardis);
                                break;
                            }
                            case 38: {
                                new WeatherAction(this.plugin).openGUI(player);
                                break;
                            }
                            case 39: {
                                new ThrottleAction(this.plugin).setSpaceTime(block, player);
                                break;
                            }
                            case 47: {
                                new DifferentiatorAction(this.plugin).bleep(block, id, player);
                                break;
                            }
                            case 54: {
                                event.setCancelled(true);
                                new EyeOfHarmonyAction(this.plugin).openGUI(id, player);
                                break;
                            }
                            case 55: {
                                new TelevisionAction(this.plugin).openGUI(player);
                                break;
                            }
                            case 58: {
                                new HappyGhastRelease(this.plugin).undock(block, id, player);
                                break;
                            }
                        }
                    } else if (action.equals((Object)Action.PHYSICAL)) {
                        switch (type) {
                            case 16: {
                                new ZeroRoomAction(this.plugin).doEntry(player, tardis, id);
                                break;
                            }
                            case 40: 
                            case 41: 
                            case 42: 
                            case 43: {
                                new MazeAction(this.plugin).reconfigure(type, player, id, blockLocation);
                                break;
                            }
                        }
                    }
                }
            } else if (blockType.equals((Object)Material.OAK_WALL_SIGN)) {
                HashMap<String, Object> wherej = new HashMap<String, Object>();
                wherej.put("save_sign", blockLocation.toString());
                ResultSetJunk rsj = new ResultSetJunk(this.plugin, wherej);
                if (rsj.resultSet()) {
                    new TARDISSaveSign(this.plugin).openGUI(player, rsj.getTardis_id());
                }
            }
        }
    }
}

