/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.companionGUI;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.companionGUI.CompanionAddInventory;
import me.eccentric_nz.TARDIS.companionGUI.CompanionInventory;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class CompanionGUIListener
extends TARDISMenuListener {
    private final TARDIS plugin;
    private final HashMap<UUID, Integer> selected_head = new HashMap();

    public CompanionGUIListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    public static void removeCompanion(int id, String comps, String uuid, Player player) {
        if (comps.equalsIgnoreCase("everyone")) {
            TARDIS.plugin.getMessenger().sendColouredCommand((CommandSender)player, "COMPANIONS_ALL", "/tardis remove all", TARDIS.plugin);
        } else {
            HashMap<String, Object> tid = new HashMap<String, Object>();
            HashMap<String, Object> set = new HashMap<String, Object>();
            String newList = "";
            String[] split = comps.split(":");
            StringBuilder buf = new StringBuilder();
            if (split.length > 1) {
                for (String c : split) {
                    if (c.equals(uuid)) continue;
                    buf.append(c).append(":");
                }
                if (!buf.isEmpty()) {
                    newList = buf.substring(0, buf.length() - 1);
                }
                set.put("companions", newList);
            } else {
                set.put("companions", "");
            }
            tid.put("tardis_id", id);
            TARDIS.plugin.getQueryFactory().doUpdate("tardis", set, tid);
        }
    }

    public static void removeFromRegion(String world, String owner, UUID uuid) {
        World w = TARDISAliasResolver.getWorldFromAlias(world);
        if (w != null) {
            TARDIS.plugin.getWorldGuardUtils().removeMemberFromRegion(w, owner, uuid);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCompanionGUIClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof CompanionInventory)) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        Player player = (Player)event.getWhoClicked();
        UUID uuid = player.getUniqueId();
        if (slot < 0 || slot > 53) {
            return;
        }
        ItemStack is = event.getView().getItem(slot);
        if (is == null) {
            return;
        }
        switch (slot) {
            case 45: {
                break;
            }
            case 48: {
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.openInventory(new CompanionAddInventory(this.plugin, player).getInventory()), 2L);
                break;
            }
            case 51: {
                if (!this.selected_head.containsKey(uuid)) break;
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("uuid", uuid.toString());
                ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
                if (!rs.resultSet()) break;
                Tardis tardis = rs.getTardis();
                int id = tardis.getTardisId();
                String comps = tardis.getCompanions();
                ItemStack h = event.getView().getItem(this.selected_head.get(uuid).intValue());
                ItemMeta m = h.getItemMeta();
                List l = m.lore();
                String u = ComponentUtils.stripColour((Component)l.getFirst());
                CompanionGUIListener.removeCompanion(id, comps, u, player);
                if (this.plugin.isWorldGuardOnServer() && this.plugin.getConfig().getBoolean("preferences.use_worldguard") && !comps.equalsIgnoreCase("everyone")) {
                    String[] data = tardis.getChunk().split(":");
                    CompanionGUIListener.removeFromRegion(data[0], tardis.getOwner(), UUID.fromString(u));
                }
                this.close(player);
                break;
            }
            case 53: {
                this.close(player);
                break;
            }
            default: {
                this.selected_head.put(uuid, slot);
            }
        }
    }
}

