/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.builders.interior.TARDISInteriorPostioning;
import me.eccentric_nz.TARDIS.builders.interior.TIPSData;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.desktop.PluginThemeInventory;
import me.eccentric_nz.TARDIS.desktop.UpgradeData;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.upgrades.SystemTree;
import me.eccentric_nz.TARDIS.upgrades.SystemUpgradeChecker;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

class UpgradeCommand {
    private final TARDIS plugin;

    UpgradeCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    boolean openUpgradeGUI(Player player) {
        boolean own;
        if (!TARDISPermission.hasPermission(player, "tardis.upgrade")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERM_UPGRADE");
            return true;
        }
        UUID uuid = player.getUniqueId();
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", uuid.toString());
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (!rs.resultSet()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TARDIS");
            return true;
        }
        if (this.plugin.getConfig().getBoolean("difficulty.system_upgrades") && !new SystemUpgradeChecker(this.plugin).has(uuid.toString(), SystemTree.DESKTOP_THEME)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Desktop Theme");
            return true;
        }
        Tardis tardis = rs.getTardis();
        if (!this.plugin.getUtils().canGrowRooms(tardis.getChunk())) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "UPGRADE_ABORT_WORLD");
            return true;
        }
        if (this.plugin.getTrackerKeeper().getIsGrowingRooms().contains(tardis.getTardisId())) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_UPGRADE_WHILE_GROWING");
            return true;
        }
        Location pl = player.getLocation();
        String current_world = pl.getWorld().getName();
        String[] split = tardis.getChunk().split(":");
        if (this.plugin.getConfig().getBoolean("creation.default_world")) {
            if (this.plugin.getConfig().getBoolean("creation.create_worlds_with_perms") && TARDISPermission.hasPermission(player, "tardis.create_world")) {
                own = current_world.equals(split[0]);
            } else {
                TARDISInteriorPostioning tintpos = new TARDISInteriorPostioning(this.plugin);
                TIPSData pos = tintpos.getTIPSData(tardis.getTIPS());
                own = pl.getBlockX() > pos.getMinX() && pl.getBlockZ() > pos.getMinZ() && pl.getBlockX() < pos.getMaxX() && pl.getBlockZ() < pos.getMaxZ();
            }
        } else {
            own = current_world.equals(split[0]);
        }
        if (!own) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_OWNER");
            return true;
        }
        Schematic current_console = tardis.getSchematic();
        int level = tardis.getArtronLevel();
        UpgradeData tud = new UpgradeData();
        tud.setPrevious(current_console);
        tud.setLevel(level);
        this.plugin.getTrackerKeeper().getUpgrades().put(uuid, tud);
        player.openInventory(new PluginThemeInventory(this.plugin, player, current_console.getPermission(), level).getInventory());
        return true;
    }
}

