/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.CircuitChecker;
import me.eccentric_nz.TARDIS.advanced.CircuitDamager;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.builders.exterior.BuildData;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisPreset;
import me.eccentric_nz.TARDIS.doors.inner.Inner;
import me.eccentric_nz.TARDIS.doors.inner.InnerDisplayDoorCloser;
import me.eccentric_nz.TARDIS.doors.inner.InnerDoor;
import me.eccentric_nz.TARDIS.doors.inner.InnerMinecraftDoorCloser;
import me.eccentric_nz.TARDIS.doors.outer.OuterDisplayDoorCloser;
import me.eccentric_nz.TARDIS.doors.outer.OuterDoor;
import me.eccentric_nz.TARDIS.doors.outer.OuterMinecraftDoorCloser;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.DiskCircuit;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Rotation;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DirectionCommand {
    private final TARDIS plugin;

    public DirectionCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean changeDirection(Player player, String[] args) {
        if (TARDISPermission.hasPermission(player, "tardis.timetravel")) {
            String locToCheck;
            Location dfl;
            int amount;
            int level;
            COMPASS compass;
            if (args.length < 2) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DIRECTION_NEED");
                return true;
            }
            try {
                compass = COMPASS.valueOf(args[1].toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DIRECTION_NEED");
                return true;
            }
            UUID uuid = player.getUniqueId();
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", uuid.toString());
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (!rs.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TARDIS");
                return true;
            }
            Tardis tardis = rs.getTardis();
            if (!tardis.getPreset().usesArmourStand() && (args[1].equalsIgnoreCase("north_east") || args[1].equalsIgnoreCase("north_west") || args[1].equalsIgnoreCase("south_west") || args[1].equalsIgnoreCase("south_east"))) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DIRECTION_PRESET");
                return true;
            }
            if (this.plugin.getConfig().getBoolean("allow.power_down") && !tardis.isPoweredOn()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "POWER_DOWN");
                return true;
            }
            int id = tardis.getTardisId();
            CircuitChecker tcc = new CircuitChecker(this.plugin, id);
            tcc.getCircuits();
            if (this.plugin.getConfig().getBoolean("difficulty.circuits") && !this.plugin.getUtils().inGracePeriod(player, true) && !tcc.hasMaterialisation()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_MAT_CIRCUIT");
                return true;
            }
            if (this.plugin.getConfig().getBoolean("circuits.damage") && this.plugin.getConfig().getInt("circuits.uses.materialisation") > 0) {
                int uses_left = tcc.getMaterialisationUses();
                new CircuitDamager(this.plugin, DiskCircuit.MATERIALISATION, uses_left, id, player).damage();
            }
            if ((level = tardis.getArtronLevel()) < (amount = this.plugin.getArtronConfig().getInt("random"))) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ENERGY_NO_DIRECTION");
                return true;
            }
            if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "NOT_IN_VORTEX");
                return true;
            }
            if (this.plugin.getTrackerKeeper().getInVortex().contains(id) || this.plugin.getTrackerKeeper().getMaterialising().contains(id) || this.plugin.getTrackerKeeper().getDematerialising().contains(id)) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_WHILE_MAT");
                return true;
            }
            if (this.plugin.getTrackerKeeper().getDispersedTARDII().contains(id)) {
                this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "NOT_WHILE_DISPERSED");
                return true;
            }
            boolean hid = tardis.isHidden();
            ChameleonPreset demat = tardis.getDemat();
            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
            if (!rsc.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
                return true;
            }
            Current current = rsc.getCurrent();
            COMPASS old_d = current.direction();
            HashMap<String, Object> tid = new HashMap<String, Object>();
            HashMap<String, Object> set = new HashMap<String, Object>();
            tid.put("tardis_id", id);
            set.put("direction", compass.toString());
            this.plugin.getQueryFactory().doUpdate("current", set, tid);
            HashMap<String, Object> did = new HashMap<String, Object>();
            HashMap<String, Object> setd = new HashMap<String, Object>();
            did.put("door_type", 0);
            did.put("tardis_id", id);
            setd.put("door_direction", compass.forPreset().toString());
            this.plugin.getQueryFactory().doUpdate("doors", setd, did);
            ResultSetTardisPreset rsp = new ResultSetTardisPreset(this.plugin);
            if (rsp.fromID(id)) {
                boolean outerDisplayDoor = rsp.getPreset().usesArmourStand();
                Inner innerDisplayDoor = new InnerDoor(this.plugin, id).get();
                if (innerDisplayDoor.display()) {
                    new InnerDisplayDoorCloser(this.plugin).close(innerDisplayDoor.block(), id, uuid, true);
                } else {
                    new InnerMinecraftDoorCloser(this.plugin).close(innerDisplayDoor.block(), id, uuid);
                }
                if (outerDisplayDoor) {
                    new OuterDisplayDoorCloser(this.plugin).close(new OuterDoor(this.plugin, id).getDisplay(), id, uuid);
                } else if (rsp.getPreset().hasDoor()) {
                    new OuterMinecraftDoorCloser(this.plugin).close(new OuterDoor(this.plugin, id).getMinecraft(), id, uuid);
                }
            }
            if (!hid) {
                if (demat.equals((Object)ChameleonPreset.DUCK)) {
                    this.plugin.getPresetDestroyer().destroyDuckEyes(current.location(), old_d);
                }
                if (demat.equals((Object)ChameleonPreset.MINESHAFT)) {
                    this.plugin.getPresetDestroyer().destroyMineshaftTorches(current.location(), old_d);
                }
                if (demat.equals((Object)ChameleonPreset.LAMP)) {
                    this.plugin.getPresetDestroyer().destroyLampTrapdoors(current.location(), old_d);
                }
                if (demat.equals((Object)ChameleonPreset.JUNK_MODE)) {
                    this.plugin.getPresetDestroyer().destroyHandbrake(current.location(), old_d);
                }
                this.plugin.getPresetDestroyer().destroyDoor(id);
                this.plugin.getPresetDestroyer().destroySign(current.location(), old_d, demat);
                BuildData bd = new BuildData(uuid.toString());
                bd.setDirection(compass);
                bd.setLocation(current.location());
                bd.setMalfunction(false);
                bd.setOutside(false);
                bd.setPlayer((OfflinePlayer)player);
                bd.setRebuild(true);
                bd.setSubmarine(current.submarine());
                bd.setTardisID(id);
                bd.setThrottle(SpaceTimeThrottle.REBUILD);
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getPresetBuilder().buildPreset(bd), 10L);
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DIRECTION_CHANGED");
            }
            HashMap<String, Object> wherea = new HashMap<String, Object>();
            wherea.put("tardis_id", id);
            this.plugin.getQueryFactory().alterEnergyLevel("tardis", -amount, wherea, player);
            HashMap<String, Object> wheredf = new HashMap<String, Object>();
            wheredf.put("tardis_id", id);
            wheredf.put("type", 18);
            ResultSetControls rsdf = new ResultSetControls(this.plugin, wheredf, false);
            if (rsdf.resultSet() && (dfl = TARDISStaticLocationGetters.getLocationFromBukkitString(locToCheck = rsdf.getLocation())) != null) {
                Chunk chunk = dfl.getChunk();
                if (!chunk.isLoaded()) {
                    chunk.load();
                }
                for (Entity e : chunk.getEntities()) {
                    if (!(e instanceof ItemFrame)) continue;
                    ItemFrame frame = (ItemFrame)e;
                    if (!e.getLocation().toString().equals(locToCheck)) continue;
                    Rotation r = switch (compass) {
                        case COMPASS.EAST -> Rotation.COUNTER_CLOCKWISE;
                        case COMPASS.SOUTH_EAST -> Rotation.COUNTER_CLOCKWISE_45;
                        case COMPASS.SOUTH -> Rotation.NONE;
                        case COMPASS.SOUTH_WEST -> Rotation.CLOCKWISE_45;
                        case COMPASS.WEST -> Rotation.CLOCKWISE;
                        case COMPASS.NORTH_WEST -> Rotation.CLOCKWISE_135;
                        case COMPASS.NORTH -> Rotation.FLIPPED;
                        default -> Rotation.FLIPPED_45;
                    };
                    frame.setRotation(r);
                    break;
                }
            }
            return true;
        }
        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERMS");
        return false;
    }
}

