/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.dev;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.schematic.setters.ArmourStandSetter;
import me.eccentric_nz.TARDIS.schematic.setters.BannerSetter;
import me.eccentric_nz.TARDIS.schematic.setters.HeadSetter;
import me.eccentric_nz.TARDIS.schematic.setters.ItemDisplaySetter;
import me.eccentric_nz.TARDIS.schematic.setters.ItemFrameSetter;
import me.eccentric_nz.TARDIS.schematic.setters.MannequinSetter;
import me.eccentric_nz.TARDIS.schematic.setters.PaintingSetter;
import me.eccentric_nz.TARDIS.schematic.setters.PotSetter;
import me.eccentric_nz.TARDIS.schematic.setters.SignSetter;
import me.eccentric_nz.TARDIS.utility.TARDISBannerData;
import me.eccentric_nz.TARDIS.utility.TARDISBlockSetters;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class RoomPaster
implements Runnable {
    private final TARDIS plugin;
    private final Player player;
    private final HashMap<Block, BlockData> postRedstoneTorches = new HashMap();
    private final HashMap<Block, BlockData> postRedstoneDust = new HashMap();
    private final HashMap<Block, BlockData> postPistons = new HashMap();
    private final HashMap<Block, TARDISBannerData> postBanners = new HashMap();
    private final JsonObject json;
    private final Location location;
    private int task;
    private int l;
    private int r;
    private int h;
    private int w;
    private int d;
    private int x;
    private int y;
    private int z;
    private World world;
    private JsonArray arr;
    private boolean running = false;

    public RoomPaster(TARDIS plugin, Player player, JsonObject json, Location location) {
        this.plugin = plugin;
        this.player = player;
        this.l = 0;
        this.r = 0;
        this.json = json;
        this.location = location;
    }

    @Override
    public void run() {
        if (this.json == null) {
            this.plugin.debug("Schematic was null!");
            return;
        }
        if (!this.running) {
            JsonObject dimensions = this.json.get("dimensions").getAsJsonObject();
            this.h = dimensions.get("height").getAsInt() - 1;
            this.w = dimensions.get("width").getAsInt();
            this.d = dimensions.get("length").getAsInt() - 1;
            JsonObject jsonObject = this.json.get("relative").getAsJsonObject();
            int rx = jsonObject.get("x").getAsInt();
            int ry = jsonObject.get("y").getAsInt();
            int rz = jsonObject.get("z").getAsInt();
            this.x = this.location.getBlockX() - rx;
            this.y = this.location.getBlockY() - ry;
            this.z = this.location.getBlockZ() - rz;
            this.world = this.player.getWorld();
            this.arr = this.json.get("input").getAsJsonArray();
            this.running = true;
        }
        if (this.l == this.h && this.r == this.w - 1) {
            int i;
            for (Map.Entry entry : this.postRedstoneTorches.entrySet()) {
                ((Block)entry.getKey()).setBlockData((BlockData)entry.getValue());
                if (!TARDIS.plugin.getBlockLogger().isLogging()) continue;
                TARDIS.plugin.getBlockLogger().logPlacement((Block)entry.getKey());
            }
            for (Map.Entry entry : this.postRedstoneDust.entrySet()) {
                ((Block)entry.getKey()).setBlockData((BlockData)entry.getValue());
                if (!TARDIS.plugin.getBlockLogger().isLogging()) continue;
                TARDIS.plugin.getBlockLogger().logPlacement((Block)entry.getKey());
            }
            for (Map.Entry entry : this.postPistons.entrySet()) {
                ((Block)entry.getKey()).setBlockData((BlockData)entry.getValue());
                if (!TARDIS.plugin.getBlockLogger().isLogging()) continue;
                TARDIS.plugin.getBlockLogger().logPlacement((Block)entry.getKey());
            }
            BannerSetter.setBanners(this.postBanners);
            if (this.json.has("mannequins")) {
                JsonArray mannequins = this.json.get("mannequins").getAsJsonArray();
                MannequinSetter.setMannequins(mannequins, this.world, this.x, this.y, this.z);
            }
            if (this.json.has("armour_stands")) {
                JsonArray stands = this.json.get("armour_stands").getAsJsonArray();
                ArmourStandSetter.setStands(stands, this.world, this.x, this.y, this.z);
            }
            if (this.json.has("paintings")) {
                JsonArray paintings = (JsonArray)this.json.get("paintings");
                PaintingSetter.setArt(paintings, this.world, this.x, this.y, this.z);
            }
            Location start = new Location(this.world, (double)this.x, (double)this.y, (double)this.z);
            if (this.json.has("item_frames")) {
                JsonArray jsonArray = this.json.get("item_frames").getAsJsonArray();
                for (i = 0; i < jsonArray.size(); ++i) {
                    ItemFrameSetter.curate(jsonArray.get(i).getAsJsonObject(), start, -1);
                }
            }
            if (this.json.has("item_displays")) {
                JsonArray jsonArray = this.json.get("item_displays").getAsJsonArray();
                for (i = 0; i < jsonArray.size(); ++i) {
                    ItemDisplaySetter.fakeBlock(jsonArray.get(i).getAsJsonObject(), start, -1);
                }
            }
            this.plugin.getServer().getScheduler().cancelTask(this.task);
            this.task = -1;
        }
        JsonArray level = (JsonArray)this.arr.get(this.l);
        JsonArray jsonArray = (JsonArray)level.get(this.r);
        for (int c = 0; c <= this.d; ++c) {
            JsonObject col = jsonArray.get(c).getAsJsonObject();
            BlockData data = this.plugin.getServer().createBlockData(col.get("data").getAsString());
            Block block = this.world.getBlockAt(this.x + this.r, this.y + this.l, this.z + c);
            if (!block.getType().isAir() && this.plugin.getBlockLogger().isLogging()) {
                this.plugin.getBlockLogger().logRemoval(block);
            }
            switch (data.getMaterial()) {
                case AIR: 
                case CAVE_AIR: 
                case VOID_AIR: {
                    block.setBlockData(data, true);
                    break;
                }
                case REDSTONE_TORCH: {
                    this.postRedstoneTorches.put(block, data);
                    break;
                }
                case REDSTONE: {
                    this.postRedstoneDust.put(block, data);
                    break;
                }
                case STICKY_PISTON: {
                    this.postPistons.put(block, data);
                    break;
                }
                case PLAYER_HEAD: 
                case PLAYER_WALL_HEAD: {
                    UUID uuid;
                    JsonObject head;
                    block.setBlockData(data, true);
                    JsonObject jsonObject = head = col.has("head") ? col.get("head").getAsJsonObject() : null;
                    if (head == null || !head.has("uuid") || (uuid = UUID.fromString(head.get("uuid").getAsString())) == null) break;
                    HeadSetter.textureSkull(this.plugin, uuid, head, block);
                    break;
                }
                case DECORATED_POT: {
                    TARDISBlockSetters.setBlock(this.world, this.x, this.y, this.z, data);
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        if (col.has("pot")) {
                            JsonObject pot = col.get("pot").getAsJsonObject();
                            PotSetter.decorate(this.plugin, pot, block);
                        }
                    }, 1L);
                    break;
                }
                default: {
                    JsonObject state;
                    if (Tag.BANNERS.isTagged((Keyed)data.getMaterial())) {
                        JsonObject jsonObject = state = col.has("banner") ? col.get("banner").getAsJsonObject() : null;
                        if (state == null) break;
                        TARDISBannerData tbd = new TARDISBannerData(data, state);
                        this.postBanners.put(block, tbd);
                        break;
                    }
                    if (Tag.ALL_SIGNS.isTagged((Keyed)data.getMaterial())) {
                        JsonObject jsonObject = state = col.has("sign") ? col.get("sign").getAsJsonObject() : null;
                        if (state == null) break;
                        block.setBlockData(data, true);
                        SignSetter.setSign(block, state, null, 0);
                        break;
                    }
                    block.setBlockData(data, true);
                    if (!this.plugin.getBlockLogger().isLogging()) break;
                    this.plugin.getBlockLogger().logPlacement(block);
                }
            }
            if (c == this.d && this.r < this.w) {
                ++this.r;
            }
            if (c != this.d || this.r != this.w || this.l >= this.h) continue;
            this.r = 0;
            ++this.l;
        }
    }

    public void setTask(int task) {
        this.task = task;
    }
}

