/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.dev;

import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.builders.interior.TARDISInteriorPostioning;
import me.eccentric_nz.TARDIS.builders.interior.TIPSData;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.floodgate.TARDISFloodgate;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;

public class AddRegionsCommand {
    private final TARDIS plugin;
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final String prefix;
    private WorldGuardPlugin wg;

    public AddRegionsCommand(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
        if (plugin.isWorldGuardOnServer()) {
            this.wg = (WorldGuardPlugin)plugin.getPM().getPlugin("WorldGuard");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doCheck(CommandSender sender) {
        if (!this.plugin.isWorldGuardOnServer()) {
            this.plugin.getMessenger().message(sender, TardisModule.TARDIS, "WorldGuard is not enabled on this server!");
            return true;
        }
        if (!this.plugin.getConfig().getBoolean("creation.default_world")) {
            this.plugin.getMessenger().message(sender, TardisModule.TARDIS, "This command only works if TARDISes are created in a default world!");
            return true;
        }
        String dw = this.plugin.getConfig().getString("creation.default_world_name");
        String world_folder = "worlds" + File.separator + dw + File.separator;
        File configFile = new File(this.wg.getDataFolder(), world_folder + "regions.yml");
        if (!configFile.exists()) {
            this.plugin.debug("Can't find default world regions.yml file!");
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        Statement statement = null;
        ResultSet rs = null;
        String query = "SELECT uuid, owner, tips FROM " + this.prefix + "tardis";
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.createStatement();
            rs = statement.executeQuery(query);
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    String rn;
                    String tl = rs.getString("owner");
                    int t = rs.getInt("tips");
                    UUID uuid = UUID.fromString(rs.getString("uuid"));
                    if (t < 0 || config.contains("regions." + (rn = TARDISFloodgate.isFloodgateEnabled() && TARDISFloodgate.isBedrockPlayer(uuid) ? "TARDIS_" + TARDISFloodgate.sanitisePlayerName(tl) : "TARDIS_" + tl))) continue;
                    TARDISInteriorPostioning tintpos = new TARDISInteriorPostioning(this.plugin);
                    TIPSData td = tintpos.getTIPSData(t);
                    this.plugin.getWorldGuardUtils().addWGProtection(uuid, tl, td, TARDISAliasResolver.getWorldFromAlias(dw));
                }
            }
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for tardis table! " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing tardis table! " + e.getMessage());
            }
        }
        return true;
    }
}

