/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.chameleon.shell;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.advanced.DamageUtility;
import me.eccentric_nz.TARDIS.chameleon.utils.ChameleonFrame;
import me.eccentric_nz.TARDIS.chameleon.utils.StainedGlassLookup;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.Control;
import me.eccentric_nz.TARDIS.enumeration.DiskCircuit;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISMaterials;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ShellRoomConstructor {
    public static final int[] orderx = new int[]{0, 1, 2, 2, 2, 1, 0, 0, 1, -1};
    public static final int[] orderz = new int[]{0, 0, 0, 1, 2, 2, 2, 1, 1, 1};
    private final TARDIS plugin;
    private final String GLASS = ShellRoomConstructor.addQuotes(TARDISConstants.GLASS.getAsString());
    private Block sign;

    public ShellRoomConstructor(TARDIS plugin) {
        this.plugin = plugin;
    }

    public static String addQuotes(String s) {
        return "\"" + s + "\"";
    }

    public void createShell(Player player, int id, Block block, int cid) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (rs.resultSet()) {
            Location block_loc = block.getLocation();
            World w = block_loc.getWorld();
            int fx = block_loc.getBlockX() + 2;
            int fy = block_loc.getBlockY() + 1;
            int fz = block_loc.getBlockZ() - 1;
            boolean hasBlock = false;
            boolean hasDoor = false;
            boolean hasPrecious = false;
            for (int c = 0; c < 10; ++c) {
                for (int y = fy; y < fy + 4; ++y) {
                    Block fb = w.getBlockAt(fx + orderx[c], y, fz + orderz[c]);
                    if (fb.getType().isAir()) continue;
                    if (TARDISMaterials.doors.contains(fb.getType())) {
                        hasDoor = true;
                        continue;
                    }
                    if (!this.plugin.getConfig().getBoolean("allow.all_blocks") && TARDISMaterials.precious.contains(fb.getType()) || Tag.WOOL_CARPETS.isTagged((Keyed)fb.getType())) {
                        hasPrecious = true;
                    }
                    hasBlock = true;
                }
            }
            if (!hasBlock || !hasDoor) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SHELL_MIN_BLOCKS");
                return;
            }
            if (hasPrecious) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CHAM_NOT_CUSTOM");
                return;
            }
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PRESET_SCAN");
            StringBuilder sb_blue_data = new StringBuilder("[");
            StringBuilder sb_stain_data = new StringBuilder("[");
            StringBuilder sb_glass_data = new StringBuilder("[");
            for (int c = 0; c < 10; ++c) {
                sb_blue_data.append("[");
                sb_stain_data.append("[");
                sb_glass_data.append("[");
                for (int y = fy; y < fy + 4; ++y) {
                    Material colour;
                    Block b = w.getBlockAt(fx + orderx[c], y, fz + orderz[c]);
                    Material material = b.getType();
                    BlockData data = b.getBlockData();
                    String dataStr = ShellRoomConstructor.addQuotes(data.getAsString());
                    if (Tag.WALL_SIGNS.isTagged((Keyed)material)) {
                        this.sign = b;
                    }
                    if (y == fy + 3) {
                        sb_blue_data.append(ShellRoomConstructor.addQuotes(data.getAsString()));
                        if (TARDISMaterials.not_glass.contains(material)) {
                            sb_stain_data.append(dataStr);
                            sb_glass_data.append(dataStr);
                            continue;
                        }
                        colour = StainedGlassLookup.stainedGlassFromMaterial(w, material);
                        sb_stain_data.append(ShellRoomConstructor.addQuotes(colour.createBlockData().getAsString()));
                        sb_glass_data.append(this.GLASS);
                        continue;
                    }
                    sb_blue_data.append(ShellRoomConstructor.addQuotes(data.getAsString())).append(",");
                    if (TARDISMaterials.not_glass.contains(material)) {
                        sb_stain_data.append(dataStr).append(",");
                        sb_glass_data.append(dataStr).append(",");
                        continue;
                    }
                    colour = StainedGlassLookup.stainedGlassFromMaterial(w, material);
                    sb_stain_data.append(ShellRoomConstructor.addQuotes(colour.createBlockData().getAsString())).append(",");
                    sb_glass_data.append(this.GLASS).append(",");
                }
                if (c == 9) {
                    sb_blue_data.append("]");
                    sb_stain_data.append("]");
                    sb_glass_data.append("]");
                    continue;
                }
                sb_blue_data.append("],");
                sb_stain_data.append("],");
                sb_glass_data.append("],");
            }
            sb_blue_data.append("]");
            sb_stain_data.append("]");
            sb_glass_data.append("]");
            String jsonBlue = sb_blue_data.toString();
            String jsonStain = sb_stain_data.toString();
            String jsonGlass = sb_glass_data.toString();
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("blueprintData", jsonBlue);
            set.put("stainData", jsonStain);
            set.put("glassData", jsonGlass);
            if (this.sign != null) {
                Sign s = (Sign)this.sign.getState();
                SignSide front = s.getSide(Side.FRONT);
                Object s1 = ComponentUtils.stripColour(front.line(0)).contains("&PLAYER") ? player.getName() + "'s" : ComponentUtils.stripColour(front.line(0));
                Object s2 = ComponentUtils.stripColour(front.line(1)).contains("&PLAYER") ? player.getName() + "'s" : ComponentUtils.stripColour(front.line(1));
                Object s3 = ComponentUtils.stripColour(front.line(2)).contains("&PLAYER") ? player.getName() + "'s" : ComponentUtils.stripColour(front.line(2));
                Object s4 = ComponentUtils.stripColour(front.line(3)).contains("&PLAYER") ? player.getName() + "'s" : ComponentUtils.stripColour(front.line(3));
                set.put("line1", s1);
                set.put("line2", s2);
                set.put("line3", s3);
                set.put("line4", s4);
            }
            set.put("active", 1);
            set.put("tardis_id", id);
            if (cid != -1) {
                HashMap<String, Object> wherec = new HashMap<String, Object>();
                wherec.put("chameleon_id", cid);
                this.plugin.getQueryFactory().doUpdate("chameleon", set, wherec);
            } else {
                this.plugin.getQueryFactory().doInsert("chameleon", set);
            }
            this.buildConstruct(rs.getTardis().getPreset().toString(), id, player);
        }
    }

    private void buildConstruct(String preset, int id, Player player) {
        HashMap<String, Object> wheree = new HashMap<String, Object>();
        wheree.put("tardis_id", id);
        this.plugin.getQueryFactory().alterEnergyLevel("tardis", this.plugin.getArtronConfig().getInt("shell") * -1, wheree, player);
        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PRESET_CONSTRUCTED");
        HashMap<String, Object> sett = new HashMap<String, Object>();
        sett.put("chameleon_preset", "CONSTRUCT");
        sett.put("chameleon_demat", preset);
        sett.put("adapti_on", 0);
        HashMap<String, Object> wheret = new HashMap<String, Object>();
        wheret.put("tardis_id", id);
        this.plugin.getQueryFactory().doUpdate("tardis", sett, wheret);
        HashMap<String, Object> whereh = new HashMap<String, Object>();
        whereh.put("tardis_id", id);
        whereh.put("type", 31);
        ResultSetControls rsc = new ResultSetControls(this.plugin, whereh, true);
        if (rsc.resultSet()) {
            for (HashMap<String, String> map : rsc.getData()) {
                TARDISStaticUtils.setSign(map.get("location"), 3, "CONSTRUCT", player);
            }
        }
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        where.put("type", Control.FRAME.getId());
        ResultSetControls rsf = new ResultSetControls(this.plugin, where, false);
        if (rsf.resultSet()) {
            new ChameleonFrame().updateChameleonFrame(ChameleonPreset.CONSTRUCT, rsf.getLocation());
        }
        this.plugin.getMessenger().sendInsertedColour((CommandSender)player, "CHAM_SET", "Construct", this.plugin);
        player.performCommand("tardis rebuild");
        DamageUtility.run(this.plugin, DiskCircuit.CHAMELEON, id, player);
    }
}

