/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.builders.utility;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.builders.interior.TARDISBuildData;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.Desktops;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;

public class SeedBlockPersister {
    private final TARDIS plugin;
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final String prefix;
    private PreparedStatement ps = null;
    private ResultSet rs = null;
    private int count = 0;

    public SeedBlockPersister(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        try {
            this.ps = this.connection.prepareStatement("INSERT INTO " + this.prefix + "seeds (schematic, wall, floor, location) VALUES (?,?,?,?)");
            for (Map.Entry<Location, TARDISBuildData> map : this.plugin.getBuildKeeper().getTrackTARDISSeed().entrySet()) {
                TARDISBuildData data = map.getValue();
                this.ps.setString(1, data.getSchematic().getPermission());
                this.ps.setString(2, data.getWallType().toString());
                this.ps.setString(3, data.getFloorType().toString());
                this.ps.setString(4, map.getKey().toString());
                this.count += this.ps.executeUpdate();
            }
            if (this.count > 0) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Saved " + this.count + " placed seed blocks.");
            }
        }
        catch (SQLException ex) {
            this.plugin.debug("Insert error for seeds table: " + ex.getMessage());
        }
        finally {
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.debug("Error closing portals statement: " + ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        try {
            this.ps = this.connection.prepareStatement("SELECT * FROM " + this.prefix + "seeds");
            this.rs = this.ps.executeQuery();
            if (this.rs.isBeforeFirst()) {
                while (this.rs.next()) {
                    Location location;
                    String l = this.rs.getString("location");
                    if (l.contains("null") || (location = TARDISStaticLocationGetters.getLocationFromBukkitString(l)) == null) continue;
                    TARDISBuildData data = new TARDISBuildData();
                    Schematic schm = Desktops.schematicFor(this.rs.getString("schematic"));
                    Material wall = Material.valueOf((String)this.rs.getString("wall"));
                    Material floor = Material.valueOf((String)this.rs.getString("floor"));
                    data.setSchematic(schm);
                    data.setWallType(wall);
                    data.setFloorType(floor);
                    this.plugin.getBuildKeeper().getTrackTARDISSeed().put(location, data);
                    ++this.count;
                }
            }
            if (this.count > 0) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Loaded " + this.count + " placed seed blocks.");
            }
            this.ps = this.connection.prepareStatement("DELETE FROM " + this.prefix + "seeds");
            this.ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.debug("ResultSet error for seeds table: " + ex.getMessage());
        }
        finally {
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
                if (this.rs != null) {
                    this.rs.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.debug("Error closing seeds statement or resultset: " + ex.getMessage());
            }
        }
    }
}

