/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.artron;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.achievement.TARDISAchievementFactory;
import me.eccentric_nz.TARDIS.artron.ArtronCondenserInventory;
import me.eccentric_nz.TARDIS.blueprints.BlueprintProcessor;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetArtronStorageAndLevel;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCondenser;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.Advancement;
import me.eccentric_nz.TARDIS.enumeration.CraftingDifficulty;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;

public class ArtronCondenserListener
implements Listener {
    private final TARDIS plugin;
    private final List<String> zero;

    public ArtronCondenserListener(TARDIS plugin) {
        this.plugin = plugin;
        this.zero = this.plugin.getBlocksConfig().getStringList("no_artron_value");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventHandler(ignoreCancelled=true)
    public void onCondenserClose(InventoryCloseEvent event) {
        ItemStack[] contents;
        boolean isCondenser;
        ResultSetTardis rs;
        InventoryView view = event.getView();
        InventoryHolder holder = event.getInventory().getHolder(false);
        if (!(holder instanceof ArtronCondenserInventory)) return;
        ArtronCondenserInventory chest = (ArtronCondenserInventory)holder;
        if (!chest.getTitle().equals("Artron Condenser") && !chest.getTitle().equals("Server Condenser")) {
            return;
        }
        Player player = (Player)event.getPlayer();
        Location location = chest.getLocation();
        String chestLocation = location.toString();
        HashMap<String, Object> where = new HashMap<String, Object>();
        if (chest.getTitle().equals("Artron Condenser")) {
            if (this.plugin.getConfig().getBoolean("preferences.no_creative_condense")) {
                switch (this.plugin.getWorldManager()) {
                    case MULTIVERSE: {
                        if (this.plugin.getMVHelper().isWorldSurvival(location.getWorld())) break;
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CONDENSE_NO_CREATIVE");
                        return;
                    }
                    case NONE: {
                        if (!this.plugin.getPlanetsConfig().getString("planets." + location.getWorld().getName() + ".gamemode", "SURVIVAL").equalsIgnoreCase("CREATIVE")) break;
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CONDENSE_NO_CREATIVE");
                        return;
                    }
                }
            }
            where.put("type", 34);
            where.put("location", chestLocation);
            ResultSetControls rsc = new ResultSetControls(this.plugin, where, false);
            if (!rsc.resultSet()) return;
            HashMap<String, Object> wheret = new HashMap<String, Object>();
            wheret.put("tardis_id", rsc.getTardis_id());
            rs = new ResultSetTardis(this.plugin, wheret, "", false);
            isCondenser = rs.resultSet();
        } else {
            where.put("uuid", player.getUniqueId().toString());
            rs = new ResultSetTardis(this.plugin, where, "", false);
            if (!this.plugin.getArtronConfig().contains("condenser")) return;
            if (!this.plugin.getArtronConfig().getString("condenser", "").equals(chestLocation)) return;
            if (!rs.resultSet()) return;
            boolean bl = true;
            isCondenser = bl;
        }
        if (!isCondenser) {
            return;
        }
        player.playSound(player.getLocation(), Sound.BLOCK_CHEST_CLOSE, 0.5f, 1.0f);
        int amount = 0;
        ArrayList<ItemStack> returnedItems = new ArrayList<ItemStack>();
        int savedEnchantedItems = 0;
        HashMap<String, Integer> item_counts = new HashMap<String, Integer>();
        Inventory inv = event.getInventory();
        for (ItemStack is : contents = inv.getContents()) {
            if (is == null) continue;
            String item = is.getType().toString();
            if (item.equals("BLAZE_ROD") && TARDISStaticUtils.isSonic(is)) {
                double full = this.plugin.getArtronConfig().getDouble("full_charge") / 75.0;
                amount += (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.standard") * full);
                if (is.getItemMeta().hasLore()) {
                    List lore = is.getItemMeta().lore();
                    if (lore.contains(Component.text((String)"Bio-scanner Upgrade"))) {
                        amount += (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.bio") * full);
                    }
                    if (lore.contains(Component.text((String)"Diamond Upgrade"))) {
                        amount += (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.diamond") * full);
                    }
                    if (lore.contains(Component.text((String)"Emerald Upgrade"))) {
                        amount += (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.emerald") * full);
                    }
                    if (lore.contains(Component.text((String)"Redstone Upgrade"))) {
                        amount += (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.bio") * full);
                    }
                    if (lore.contains(Component.text((String)"Painter Upgrade"))) {
                        amount += (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.painter") * full);
                    }
                    if (lore.contains(Component.text((String)"Ignite Upgrade"))) {
                        amount += (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.ignite") * full);
                    }
                    if (lore.contains(Component.text((String)"Pickup Arrows Upgrade"))) {
                        amount += (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.arrow") * full);
                    }
                    if (lore.contains(Component.text((String)"Knockback Upgrade"))) {
                        amount += (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.knockback") * full);
                    }
                    if (lore.contains(Component.text((String)"Brush Upgrade"))) {
                        amount += (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.brush") * full);
                    }
                    if (lore.contains(Component.text((String)"Conversion Upgrade"))) {
                        amount += (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.conversion") * full);
                    }
                }
                inv.remove(is);
                continue;
            }
            if (item.equals("MUSIC_DISC_MELLOHI") && this.isBlueprint(is)) {
                BlueprintProcessor.addPermission(this.plugin, is, player);
                amount += this.plugin.getCondensables().get(item).intValue();
                inv.remove(is);
                continue;
            }
            if (this.plugin.getConfig().getBoolean("preferences.no_enchanted_condense") && !is.getEnchantments().keySet().stream().allMatch(ench -> ench.equals(Enchantment.BINDING_CURSE) || ench.equals(Enchantment.VANISHING_CURSE))) {
                ++savedEnchantedItems;
                returnedItems.add(is);
                inv.remove(is);
                continue;
            }
            if (this.plugin.getCondensables().containsKey(item) && !this.zero.contains(item)) {
                int stack_size = is.getAmount();
                amount += stack_size * this.plugin.getCondensables().get(item);
                String block_data = is.getType().toString();
                if (this.plugin.getConfig().getBoolean("growth.rooms_require_blocks") || this.plugin.getConfig().getBoolean("allow.repair")) {
                    if (item_counts.containsKey(block_data)) {
                        Integer add_this = (Integer)item_counts.get(block_data) + stack_size;
                        item_counts.put(block_data, add_this);
                    } else {
                        item_counts.put(block_data, stack_size);
                    }
                }
                inv.remove(is);
                continue;
            }
            returnedItems.add(is);
            inv.remove(is);
        }
        HashMap didntFit = player.getInventory().addItem(returnedItems.toArray(new ItemStack[0]));
        player.updateInventory();
        for (ItemStack is : didntFit.values()) {
            player.getWorld().dropItem(player.getLocation(), is);
        }
        Tardis tardis = rs.getTardis();
        if (tardis == null) {
            this.plugin.debug("TARDIS data was null!");
            return;
        }
        int id = tardis.getTardisId();
        if (this.plugin.getConfig().getBoolean("growth.rooms_require_blocks") || this.plugin.getConfig().getBoolean("allow.repair")) {
            item_counts.forEach((key, value) -> {
                HashMap<String, Object> wherec = new HashMap<String, Object>();
                wherec.put("tardis_id", id);
                wherec.put("block_data", key);
                ResultSetCondenser rsc = new ResultSetCondenser(this.plugin, wherec);
                HashMap<String, Object> setc = new HashMap<String, Object>();
                if (rsc.resultSet()) {
                    int new_stack_size = value + rsc.getBlock_count();
                    this.plugin.getQueryFactory().updateCondensedBlockCount(new_stack_size, id, (String)key);
                } else {
                    setc.put("tardis_id", id);
                    setc.put("block_data", key);
                    setc.put("block_count", value);
                    this.plugin.getQueryFactory().doInsert("condenser", setc);
                }
            });
        }
        if (savedEnchantedItems > 0) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CONDENSE_NO_ENCHANTED", Integer.toString(savedEnchantedItems));
        }
        amount = Math.round((float)amount / 2.0f);
        ResultSetArtronStorageAndLevel rsas = new ResultSetArtronStorageAndLevel(this.plugin);
        int full = this.plugin.getArtronConfig().getInt("full_charge", 5000);
        if (rsas.fromID(id)) {
            int damage = full / 2 * rsas.getDamageCount();
            int max = full * rsas.getCapacitorCount() - damage;
            int current = rsas.getCurrentLevel();
            if (current + amount > max) {
                int toMax = max - current;
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CAPACITOR_CONDENSE", max);
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CAPACITOR_TRY", toMax);
                if (rsas.getCapacitorCount() > 1) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CAPACITOR_ADD");
                } else {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CAPACITOR_ADD_ROOM");
                }
                this.giveBack(player, amount, full, contents);
                return;
            }
        } else {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CAPACITOR_NOT_FOUND");
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CAPACITOR_ADD_ROOM");
            this.giveBack(player, amount, full, contents);
            return;
        }
        HashMap<String, Object> wheret = new HashMap<String, Object>();
        wheret.put("tardis_id", id);
        this.plugin.getQueryFactory().alterEnergyLevel("tardis", amount, wheret, player);
        if (amount > 0) {
            if (this.plugin.getAchievementConfig().getBoolean("energy.enabled")) {
                int current_level = tardis.getArtronLevel() + amount;
                int fc = this.plugin.getArtronConfig().getInt("full_charge");
                int percent = Math.round((float)current_level * 100.0f / (float)fc);
                TARDISAchievementFactory taf = new TARDISAchievementFactory(this.plugin, player, Advancement.ENERGY, 1);
                if (percent >= this.plugin.getAchievementConfig().getInt("energy.required")) {
                    taf.doAchievement(percent);
                } else {
                    taf.doAchievement(Math.round((float)amount * 100.0f / (float)fc));
                }
            }
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ENERGY_CONDENSED", String.format("%d", amount));
            return;
        } else {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CONDENSE_NO_VALID");
        }
    }

    private void giveBack(Player player, int amount, int full, ItemStack[] items) {
        ShapedRecipe recipe = this.plugin.getFigura().getShapedRecipes().get("Artron Storage Cell");
        ItemStack result = recipe.getResult();
        int cellCost = this.plugin.getCraftingDifficulty() == CraftingDifficulty.HARD ? 406 : 86;
        int initialFullCellCount = amount / full;
        int totalCost = cellCost * (initialFullCellCount + 1);
        int remainder = 0;
        int finalFullCellCount = 0;
        if (amount - totalCost > 0) {
            finalFullCellCount = (amount -= totalCost) / full;
            remainder = amount % full;
        }
        if (finalFullCellCount == 0 && remainder == 0) {
            for (ItemStack item : items) {
                if (item == null) continue;
                player.getInventory().addItem(new ItemStack[]{item});
            }
            return;
        }
        if (remainder > 0) {
            ItemStack leftover = result.clone();
            ItemMeta lim = leftover.getItemMeta();
            List lore = lim.lore();
            lore.set(1, Component.text((int)remainder));
            lim.lore(lore);
            lim.setEnchantmentGlintOverride(Boolean.valueOf(true));
            lim.addItemFlags(ItemFlag.values());
            lim.setAttributeModifiers((Multimap)Multimaps.forMap(Map.of()));
            leftover.setItemMeta(lim);
            player.getInventory().addItem(new ItemStack[]{leftover});
        }
        if (finalFullCellCount > 0) {
            result.setAmount(finalFullCellCount);
            ItemMeta im = result.getItemMeta();
            List lore = im.lore();
            lore.set(1, Component.text((int)full));
            im.lore(lore);
            im.setEnchantmentGlintOverride(Boolean.valueOf(true));
            im.addItemFlags(ItemFlag.values());
            im.setAttributeModifiers((Multimap)Multimaps.forMap(Map.of()));
            result.setItemMeta(im);
            player.getInventory().addItem(new ItemStack[]{result});
        }
        if (finalFullCellCount > 0 || remainder > 0) {
            player.updateInventory();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onChestOpen(PlayerInteractEvent event) {
        if (event.getHand() == null || event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            return;
        }
        Block b = event.getClickedBlock();
        if (b != null && b.getType().equals((Object)Material.CHEST) && event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            Location loc = b.getLocation();
            String chest_loc = loc.toString();
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("type", 34);
            where.put("location", chest_loc);
            ResultSetControls rsc = new ResultSetControls(this.plugin, where, false);
            if (rsc.resultSet()) {
                event.setCancelled(true);
                this.openCondenser(b, event.getPlayer(), "Artron Condenser");
            } else {
                if (!this.plugin.getArtronConfig().contains("condenser")) {
                    return;
                }
                if (this.plugin.getArtronConfig().getString("condenser", "").equals(loc.toString())) {
                    event.setCancelled(true);
                    this.openCondenser(b, event.getPlayer(), "Server Condenser");
                }
            }
        }
    }

    private void openCondenser(Block block, Player player, String title) {
        Chest holder = (Chest)block.getState();
        player.playSound(player.getLocation(), Sound.BLOCK_CHEST_OPEN, 0.5f, 1.0f);
        player.openInventory(new ArtronCondenserInventory(this.plugin, (InventoryHolder)holder, title, block.getLocation()).getInventory());
    }

    private boolean isBlueprint(ItemStack is) {
        ItemMeta im;
        if (!this.plugin.getConfig().getBoolean("modules.blueprints")) {
            return false;
        }
        if (is.hasItemMeta() && (im = is.getItemMeta()).hasDisplayName()) {
            return ComponentUtils.endsWith(im.displayName(), "TARDIS Blueprint Disk");
        }
        return false;
    }
}

