/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.advanced;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.AdvancedConsoleInventory;
import me.eccentric_nz.TARDIS.advanced.AreaDisks;
import me.eccentric_nz.TARDIS.advanced.SerializeInventory;
import me.eccentric_nz.TARDIS.advanced.StorageConverter;
import me.eccentric_nz.TARDIS.advanced.StorageInventory;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDiskStorage;
import me.eccentric_nz.TARDIS.enumeration.DiskCircuit;
import me.eccentric_nz.TARDIS.enumeration.Storage;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.handles.HandlesProgramInventory;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class StorageListener
extends TARDISMenuListener {
    private final TARDIS plugin;
    private final List<Material> onlythese = new ArrayList<Material>();

    public StorageListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
        for (DiskCircuit dc : DiskCircuit.values()) {
            if (this.onlythese.contains(dc.getMaterial())) continue;
            this.onlythese.add(dc.getMaterial());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onDiskStorageClose(InventoryCloseEvent event) {
        InventoryView view = event.getView();
        if (event.getInventory().getHolder(false) instanceof StorageInventory) {
            String title = ComponentUtils.stripColour(view.title());
            String[] split = title.split(" ");
            Object tmp = split[0].toUpperCase(Locale.ROOT);
            if (split.length > 2) {
                tmp = (String)tmp + "_" + split[2];
            }
            Storage store = Storage.valueOf((String)tmp);
            this.saveCurrentStorage(event.getInventory(), store.getColumn(), (Player)event.getPlayer());
        } else if (!(event.getInventory().getHolder(false) instanceof AdvancedConsoleInventory) && !(event.getInventory().getHolder(false) instanceof HandlesProgramInventory)) {
            for (int i = 0; i < event.getInventory().getSize(); ++i) {
                ItemStack stack = view.getItem(i);
                if (stack == null || !stack.getType().equals((Object)Material.MUSIC_DISC_BLOCKS) || !stack.hasItemMeta()) {
                    return;
                }
                ItemMeta ims = stack.getItemMeta();
                if (!ims.hasDisplayName() || !ComponentUtils.endsWith(ims.displayName(), "Area Storage Disk")) {
                    return;
                }
                Player p = (Player)event.getPlayer();
                Location loc = p.getLocation();
                loc.getWorld().dropItemNaturally(loc, stack);
                view.setItem(i, ItemStack.of((Material)Material.AIR));
                this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "ADV_NO_STORE");
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onDiskStorageInteract(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof StorageInventory)) {
            return;
        }
        int slot = event.getRawSlot();
        if (slot >= 0 && slot < 27 || event.isShiftClick()) {
            event.setCancelled(true);
        }
        Player player = (Player)event.getWhoClicked();
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", player.getUniqueId().toString());
        ResultSetDiskStorage rs = new ResultSetDiskStorage(this.plugin, where);
        if (!rs.resultSet()) {
            return;
        }
        String title = ComponentUtils.stripColour(event.getView().title());
        String[] split = title.split(" ");
        Object tmp = split[0].toUpperCase(Locale.ROOT);
        if (split.length > 2) {
            tmp = (String)tmp + "_" + split[2];
        }
        Storage store = Storage.valueOf((String)tmp);
        if (slot >= 0 && slot < 6 || slot == 18 || slot == 26) {
            this.saveCurrentStorage(event.getClickedInventory(), store.getColumn(), player);
        }
        String[] versions = rs.getVersions().split(",");
        switch (slot) {
            case 0: {
                if (store.equals((Object)Storage.SAVE_1)) break;
                this.loadInventory(rs.getSavesOne(), player, Storage.SAVE_1, versions);
                break;
            }
            case 1: {
                if (store.equals((Object)Storage.AREA)) break;
                this.loadInventory(rs.getAreas(), player, Storage.AREA, versions);
                break;
            }
            case 2: {
                if (store.equals((Object)Storage.PLAYER)) break;
                this.loadInventory(rs.getPlayers(), player, Storage.PLAYER, versions);
                break;
            }
            case 3: {
                if (store.equals((Object)Storage.BIOME_1)) break;
                this.loadInventory(rs.getBiomesOne(), player, Storage.BIOME_1, versions);
                break;
            }
            case 4: {
                if (store.equals((Object)Storage.PRESET_1)) break;
                this.loadInventory(rs.getPresetsOne(), player, Storage.PRESET_1, versions);
                break;
            }
            case 5: {
                if (store.equals((Object)Storage.CIRCUIT)) break;
                this.loadInventory(rs.getCircuits(), player, Storage.CIRCUIT, versions);
                break;
            }
        }
        switch (store) {
            case BIOME_1: {
                if (slot != 26) break;
                this.loadInventory(rs.getBiomesTwo(), player, Storage.BIOME_2, versions);
                break;
            }
            case BIOME_2: {
                if (slot != 18) break;
                this.loadInventory(rs.getBiomesOne(), player, Storage.BIOME_1, versions);
                break;
            }
            case PRESET_1: {
                if (slot != 26) break;
                this.loadInventory(rs.getPresetsTwo(), player, Storage.PRESET_2, versions);
                break;
            }
            case PRESET_2: {
                if (slot != 18) break;
                this.loadInventory(rs.getPresetsOne(), player, Storage.PRESET_1, versions);
                break;
            }
            case SAVE_1: {
                if (slot != 26) break;
                this.loadInventory(rs.getSavesTwo(), player, Storage.SAVE_2, versions);
                break;
            }
            case SAVE_2: {
                if (slot != 18) break;
                this.loadInventory(rs.getSavesOne(), player, Storage.SAVE_1, versions);
                break;
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerDropAreaDisk(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        ItemStack is = event.getItemDrop().getItemStack();
        if (!is.getType().equals((Object)Material.MUSIC_DISC_BLOCKS) || !is.hasItemMeta()) {
            return;
        }
        ItemMeta im = is.getItemMeta();
        if (im == null || !im.hasDisplayName() || !ComponentUtils.endsWith(im.displayName(), "Area Storage Disk")) {
            return;
        }
        event.setCancelled(true);
        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ADV_NO_DROP");
    }

    private void saveCurrentStorage(Inventory inv, String column, Player p) {
        for (int i = 27; i < 54; ++i) {
            ItemStack is = inv.getItem(i);
            if (is == null || this.onlythese.contains(is.getType())) continue;
            p.getLocation().getWorld().dropItemNaturally(p.getLocation(), is);
            inv.setItem(i, ItemStack.of((Material)Material.AIR));
        }
        String serialized = SerializeInventory.itemStacksToString(inv.getContents());
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put(column, serialized);
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", p.getUniqueId().toString());
        this.plugin.getQueryFactory().doUpdate("storage", set, where);
    }

    private void loadInventory(String serialized, Player p, Storage s, String[] versions) {
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            ItemStack[] stack = null;
            try {
                if (!serialized.isEmpty()) {
                    if (s == Storage.AREA) {
                        if (versions[0].equals("0")) {
                            stack = StorageConverter.updateDisks(new AreaDisks(this.plugin).checkDisksForNewAreas(p));
                            versions[0] = "1";
                            this.updateVersions(versions, p.getUniqueId().toString());
                        } else {
                            stack = SerializeInventory.itemStacksFromString(new AreaDisks(this.plugin).checkDisksForNewAreas(p));
                        }
                    } else if (s == Storage.CIRCUIT) {
                        int version = TARDISNumberParsers.parseInt(versions[3]);
                        if (version < 2) {
                            stack = StorageConverter.updateCircuits(serialized);
                            versions[3] = version == 0 ? "1" : "2";
                            this.updateVersions(versions, p.getUniqueId().toString());
                        } else {
                            stack = SerializeInventory.itemStacksFromString(serialized);
                        }
                    } else if (versions[s.ordinal()].equals("0")) {
                        stack = StorageConverter.updateDisks(serialized);
                        versions[s.ordinal()] = "1";
                        this.updateVersions(versions, p.getUniqueId().toString());
                    } else {
                        stack = SerializeInventory.itemStacksFromString(serialized);
                    }
                } else {
                    stack = s.equals((Object)Storage.AREA) ? new AreaDisks(this.plugin).makeDisks(p) : SerializeInventory.itemStacksFromString(s.getEmpty());
                }
            }
            catch (IOException ex) {
                this.plugin.debug("Could not get inventory from database! " + String.valueOf(ex));
            }
            p.closeInventory();
            if (stack != null) {
                p.openInventory(new StorageInventory(this.plugin, s.getTitle(), stack).getInventory());
            }
        }, 1L);
    }

    private void updateVersions(String[] versions, String uuid) {
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("versions", String.join((CharSequence)",", versions));
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", uuid);
        this.plugin.getQueryFactory().doSyncUpdate("storage", set, where);
    }
}

