/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.advanced;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class SerializeInventory {
    public static String itemStacksToString(ItemStack[] stack) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try (BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);){
                dataOutput.writeInt(stack.length);
                for (ItemStack is : stack) {
                    dataOutput.writeObject((Object)is);
                }
            }
            return Base64Coder.encodeLines((byte[])outputStream.toByteArray());
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to save item stacks.", e);
        }
    }

    public static ItemStack[] itemStacksFromString(String data) throws IOException {
        try {
            ItemStack[] stack;
            ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)data));
            try (BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);){
                stack = new ItemStack[dataInput.readInt()];
                for (int i = 0; i < stack.length; ++i) {
                    CustomModelDataComponent component;
                    ItemMeta im;
                    ItemStack is = (ItemStack)dataInput.readObject();
                    if (is != null && is.getType() == Material.GLOWSTONE_DUST && (im = is.getItemMeta()).hasDisplayName() && im.displayName().equals((Object)"Circuits") && (component = im.getCustomModelDataComponent()).getFloats().size() > 0 && ((Float)component.getFloats().getFirst()).floatValue() != 130.0f) {
                        component.setFloats(List.of(Float.valueOf(130.0f)));
                        im.setCustomModelDataComponent(component);
                        is.setItemMeta(im);
                    }
                    stack[i] = is;
                }
            }
            return stack;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Unable to decode class type.", e);
        }
    }
}

