/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.advanced;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.ARS.ARSInventory;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.AdvancedConsoleInventory;
import me.eccentric_nz.TARDIS.chameleon.gui.ChameleonInventory;
import me.eccentric_nz.TARDIS.console.telepathic.TelepathicInventory;
import me.eccentric_nz.TARDIS.control.TARDISScanner;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.travel.TARDISTemporalLocatorInventory;
import me.eccentric_nz.TARDIS.travel.TARDISTerminalInventory;
import me.eccentric_nz.TARDIS.travel.save.TARDISSavesPlanetInventory;
import me.eccentric_nz.TARDIS.upgrades.SystemTree;
import me.eccentric_nz.TARDIS.upgrades.SystemUpgradeChecker;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class AdvancedConsoleSwitchListener
implements Listener {
    private final TARDIS plugin;
    private final List<String> gui_circuits = List.of("TARDIS Telepathic Circuit", "TARDIS Chameleon Circuit", "TARDIS ARS Circuit", "TARDIS Temporal Circuit", "TARDIS Memory Circuit", "TARDIS Input Circuit", "TARDIS Scanner Circuit");

    public AdvancedConsoleSwitchListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onConsoleInventoryClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof AdvancedConsoleInventory)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        UUID uuid = player.getUniqueId();
        HashMap<String, Object> wheret = new HashMap<String, Object>();
        wheret.put("uuid", uuid.toString());
        ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wheret, false);
        if (!rst.resultSet()) {
            event.setCancelled(true);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_IN_TARDIS");
        }
        if (!event.getClick().equals((Object)ClickType.SHIFT_RIGHT)) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        if (slot < 0 || slot >= 18) {
            return;
        }
        ItemStack item = event.getView().getItem(slot);
        if (item == null || !item.getType().equals((Object)Material.GLOWSTONE_DUST) || !item.hasItemMeta()) {
            return;
        }
        ItemMeta im = item.getItemMeta();
        if (!im.hasDisplayName()) {
            return;
        }
        String dn = ComponentUtils.stripColour(im.displayName());
        if (!this.gui_circuits.contains(dn)) {
            return;
        }
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", uuid);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (!rs.resultSet()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TARDIS");
            return;
        }
        Tardis tardis = rs.getTardis();
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            Object holder = null;
            if (dn.contains("Chameleon")) {
                holder = new ChameleonInventory(this.plugin, tardis.getAdaption(), tardis.getPreset(), tardis.getItemPreset());
            }
            if (dn.contains("ARS")) {
                holder = new ARSInventory(this.plugin, player);
            }
            if (dn.contains("Telepathic")) {
                holder = new TelepathicInventory(this.plugin, player);
            }
            if (dn.contains("Temporal")) {
                holder = new TARDISTemporalLocatorInventory(this.plugin);
            }
            if (dn.contains("Memory")) {
                if (this.plugin.getConfig().getBoolean("difficulty.system_upgrades") && !new SystemUpgradeChecker(this.plugin).has(uuid.toString(), SystemTree.SAVES)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Saves");
                    return;
                }
                holder = new TARDISSavesPlanetInventory(this.plugin, tardis.getTardisId(), player);
            }
            if (dn.contains("Input")) {
                holder = new TARDISTerminalInventory(this.plugin);
            } else {
                new TARDISScanner(this.plugin).scan(tardis.getTardisId(), player, tardis.getRenderer(), tardis.getArtronLevel());
            }
            player.closeInventory();
            if (holder != null) {
                player.openInventory(holder.getInventory());
            }
        }, 1L);
    }
}

