/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.achievement;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.achievement.TARDISXPRewarder;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetAchievements;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class TARDISAchievementFactory {
    private final TARDIS plugin;
    private final Player player;
    private final me.eccentric_nz.TARDIS.enumeration.Advancement advancement;
    private final int size;

    public TARDISAchievementFactory(TARDIS plugin, Player player, me.eccentric_nz.TARDIS.enumeration.Advancement advancement, int size) {
        this.plugin = plugin;
        this.player = player;
        this.advancement = advancement;
        this.size = size;
    }

    public static boolean checkAdvancement(String adv) {
        NamespacedKey nsk = new NamespacedKey((Plugin)TARDIS.plugin, adv.toLowerCase(Locale.ROOT));
        Advancement a = TARDIS.plugin.getServer().getAdvancement(nsk);
        if (a != null) {
            TARDIS.plugin.debug("Advancement 'tardis:" + adv + "' exists :)");
            return true;
        }
        TARDIS.plugin.debug("There is no advancement with that key!");
        return false;
    }

    public static void grantAdvancement(me.eccentric_nz.TARDIS.enumeration.Advancement adv, Player player) {
        NamespacedKey nsk = new NamespacedKey((Plugin)TARDIS.plugin, adv.getConfigName());
        Advancement a = TARDIS.plugin.getServer().getAdvancement(nsk);
        if (a != null) {
            AdvancementProgress avp = player.getAdvancementProgress(a);
            if (!avp.isDone()) {
                TARDIS.plugin.getServer().dispatchCommand((CommandSender)TARDIS.plugin.getConsole(), "advancement grant " + player.getName() + " only tardis:" + adv.getConfigName());
            }
        } else {
            TARDIS.plugin.getMessenger().messageWithColour((CommandSender)player, "Advancement Made!", "#FFFF55");
            TARDIS.plugin.getMessenger().message((CommandSender)player, TARDIS.plugin.getAchievementConfig().getString(adv.getConfigName() + ".message"));
        }
    }

    public void doAchievement(Object obj) {
        if (this.plugin.getConfig().getBoolean("allow.achievements")) {
            HashMap<String, Object> wherea = new HashMap<String, Object>();
            wherea.put("uuid", this.player.getUniqueId().toString());
            wherea.put("name", this.advancement.getConfigName());
            wherea.put("completed", 0);
            ResultSetAchievements rsa = new ResultSetAchievements(this.plugin, wherea);
            HashMap<String, Object> seta = new HashMap<String, Object>();
            if (rsa.resultSet()) {
                String amount;
                HashMap<String, Object> wherem = new HashMap<String, Object>();
                wherem.put("a_id", rsa.getA_id());
                boolean achieved = false;
                List<String> data = null;
                String string = amount = rsa.getAmount().isEmpty() ? "0" : rsa.getAmount();
                if (obj.getClass().equals(String.class)) {
                    data = List.of(amount.split(":"));
                    if (data.size() + 1 == this.size) {
                        achieved = true;
                    }
                } else {
                    int req = this.plugin.getAchievementConfig().getInt(String.valueOf((Object)this.advancement) + ".required");
                    int have = TARDISNumberParsers.parseInt(amount);
                    int sum = have + (Integer)obj;
                    if (sum >= req) {
                        achieved = true;
                    }
                }
                if (achieved) {
                    int reward_amount = this.plugin.getAchievementConfig().getInt(this.advancement.getConfigName() + ".reward_amount");
                    String reward_type = this.plugin.getAchievementConfig().getString(this.advancement.getConfigName() + ".reward_type");
                    TARDISAchievementFactory.grantAdvancement(this.advancement, this.player);
                    if (reward_type.equalsIgnoreCase("XP")) {
                        new TARDISXPRewarder(this.player).changeExp(reward_amount);
                    } else {
                        ItemStack is = ItemStack.of((Material)Material.valueOf((String)reward_type), (int)reward_amount);
                        PlayerInventory inv = this.player.getInventory();
                        HashMap excess = inv.addItem(new ItemStack[]{is});
                        excess.forEach((key, value) -> this.player.getWorld().dropItem(this.player.getLocation(), value));
                    }
                    seta.put("completed", 1);
                    this.plugin.getQueryFactory().doUpdate("achievements", seta, wherem);
                } else if (obj.getClass().equals(String.class)) {
                    if (data != null && !data.contains(obj)) {
                        seta.put("amount", amount + ":" + String.valueOf(obj));
                        this.plugin.getQueryFactory().doUpdate("achievements", seta, wherem);
                    }
                } else {
                    seta.put("amount", TARDISNumberParsers.parseInt(amount) + (Integer)obj);
                    this.plugin.getQueryFactory().doUpdate("achievements", seta, wherem);
                }
            } else if (this.plugin.getAchievementConfig().getBoolean(this.advancement.getConfigName() + ".auto")) {
                seta.put("uuid", this.player.getUniqueId().toString());
                seta.put("name", this.advancement.getConfigName());
                seta.put("amount", obj);
                seta.put("completed", 0);
                this.plugin.getQueryFactory().doInsert("achievements", seta);
            }
        }
    }
}

