/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.ARS;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.ARS.ARS;
import me.eccentric_nz.TARDIS.ARS.JettisonSlot;
import me.eccentric_nz.TARDIS.ARS.TARDISARS;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetArtronStorage;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.rooms.RoomCleaner;
import me.eccentric_nz.tardischunkgenerator.custombiome.BiomeHelper;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;

public class JettisonRunnable
implements Runnable {
    private final TARDIS plugin;
    private final JettisonSlot slot;
    private final ARS room;
    private final int id;
    private final Player player;

    public JettisonRunnable(TARDIS plugin, JettisonSlot slot, ARS room, int id, Player player) {
        this.plugin = plugin;
        this.slot = slot;
        this.room = room;
        this.id = id;
        this.player = player;
    }

    @Override
    public void run() {
        String r = this.room.getConfigPath();
        World world = this.slot.getChunk().getWorld();
        int x = this.slot.getX();
        int y = this.slot.getY();
        int z = this.slot.getZ();
        for (int yy = y; yy < y + 16; ++yy) {
            for (int xx = x; xx < x + 16; ++xx) {
                for (int zz = z; zz < z + 16; ++zz) {
                    BlockState state;
                    Block b = world.getBlockAt(xx, yy, zz);
                    TARDISDisplayItemUtils.remove(b);
                    if ((r.equals("GRAVITY") || r.equals("ANTIGRAVITY")) && (b.getType().equals((Object)Material.LIME_WOOL) || b.getType().equals((Object)Material.PINK_WOOL))) {
                        String l = new Location(world, (double)xx, (double)yy, (double)zz).toString();
                        HashMap<String, Object> where = new HashMap<String, Object>();
                        where.put("location", l);
                        where.put("tardis_id", this.id);
                        this.plugin.getQueryFactory().doDelete("gravity_well", where);
                        if (b.getType().equals((Object)Material.LIME_WOOL)) {
                            this.plugin.getGeneralKeeper().getGravityUpList().remove(l);
                        } else {
                            this.plugin.getGeneralKeeper().getGravityDownList().remove(l);
                        }
                    }
                    if (r.equals("EYE")) {
                        world.setBiome(xx, yy, zz, Biome.THE_VOID);
                    }
                    if ((state = b.getState()) instanceof BlockState) {
                        this.plugin.getTardisHelper().removeTileEntity(state);
                    }
                    b.setBlockData(TARDISConstants.AIR);
                }
            }
        }
        if (r.equals("EYE")) {
            BiomeHelper.refreshChunk(this.slot.getChunk());
            ResultSetArtronStorage rsa = new ResultSetArtronStorage(this.plugin);
            if (rsa.fromID(this.id)) {
                this.plugin.getServer().getScheduler().cancelTask(rsa.getTask());
                HashMap<String, Object> set = new HashMap<String, Object>();
                set.put("task", -1);
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("tardis_id", this.id);
                this.plugin.getQueryFactory().doSyncUpdate("eyes", set, where);
            }
        }
        if (r.equals("LIBRARY")) {
            Chunk chunk = this.slot.getChunk();
            for (Entity entity : chunk.getEntities()) {
                if (!(entity instanceof ItemDisplay) && !(entity instanceof Interaction) && !(entity instanceof TextDisplay)) continue;
                entity.remove();
            }
        }
        if (this.room != TARDISARS.SLOT) {
            int amount = Math.round((float)this.plugin.getArtronConfig().getInt("jettison") / 100.0f * (float)this.plugin.getRoomsConfig().getInt("rooms." + r + ".cost"));
            if (r.equals("GRAVITY") || r.equals("ANTIGRAVITY")) {
                amount /= 2;
            }
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("tardis_id", this.id);
            this.plugin.getQueryFactory().alterEnergyLevel("tardis", amount, set, null);
            if (this.player.isOnline()) {
                this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "ENERGY_RECOVERED", String.format("%d", amount));
            }
            new RoomCleaner(this.plugin).removeRecords(r, this.id, world, this.player);
        }
    }
}

