/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisvortexmanipulator.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.tardisvortexmanipulator.TVMUtils;
import me.eccentric_nz.tardisvortexmanipulator.database.TVMQueryFactory;
import me.eccentric_nz.tardisvortexmanipulator.gui.TVMGUI;
import me.eccentric_nz.tardisvortexmanipulator.gui.TVMMessageGUI;
import me.eccentric_nz.tardisvortexmanipulator.gui.TVMSavesGUI;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class TVMGUIListener
extends TARDISMenuListener {
    final List<Integer> letters = List.of(Integer.valueOf(0), Integer.valueOf(4), Integer.valueOf(5));
    final char[] two = new char[]{'2', 'a', 'b', 'c'};
    final char[] three = new char[]{'3', 'd', 'e', 'f'};
    final char[] four = new char[]{'4', 'g', 'h', 'i'};
    final char[] five = new char[]{'5', 'j', 'k', 'l'};
    final char[] six = new char[]{'6', 'm', 'n', 'o'};
    final char[] seven = new char[]{'7', 'p', 'q', 'r', 's'};
    final char[] eight = new char[]{'8', 't', 'u', 'v'};
    final char[] nine = new char[]{'9', 'w', 'x', 'y', 'z'};
    final char[] star = new char[]{'*', ' '};
    final char[] hash = new char[]{'#', '~', '_', '-'};
    final int[] pos;
    final TVMQueryFactory qf;
    private final TARDIS plugin;
    List<String> components = List.of("", "", "", "", "", "");
    int which = 0;
    int t2 = 0;
    int t3 = 0;
    int t4 = 0;
    int t5 = 0;
    int t6 = 0;
    int t7 = 0;
    int t8 = 0;
    int t9 = 0;
    int ts = 0;
    int th = 0;

    public TVMGUIListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
        this.pos = new int[6];
        for (int i = 0; i < 6; ++i) {
            this.pos[i] = 0;
        }
        this.qf = new TVMQueryFactory(this.plugin);
    }

    @EventHandler(ignoreCancelled=true)
    public void onGUIClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof TVMGUI)) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        int slot = event.getRawSlot();
        if (slot < 0 || slot > 53) {
            return;
        }
        InventoryView view = event.getView();
        block0 : switch (slot) {
            case 6: {
                this.usePredictive(view);
                break;
            }
            case 11: {
                this.which = 0;
                this.resetTrackers();
                break;
            }
            case 12: {
                this.updateDisplay(view, '1');
                break;
            }
            case 13: {
                if (this.letters.contains(this.which)) {
                    this.updateDisplay(view, this.two[this.t2]);
                    ++this.t2;
                    if (this.t2 != this.two.length) break;
                    this.t2 = 0;
                    break;
                }
                this.updateDisplay(view, '2');
                break;
            }
            case 14: {
                if (this.letters.contains(this.which)) {
                    this.updateDisplay(view, this.three[this.t3]);
                    ++this.t3;
                    if (this.t3 != this.three.length) break;
                    this.t3 = 0;
                    break;
                }
                this.updateDisplay(view, '3');
                break;
            }
            case 16: {
                this.which = 4;
                this.resetTrackers();
                break;
            }
            case 18: {
                this.which = 5;
                this.resetTrackers();
                break;
            }
            case 20: {
                this.which = 1;
                this.resetTrackers();
                break;
            }
            case 21: {
                if (this.letters.contains(this.which)) {
                    this.updateDisplay(view, this.four[this.t4]);
                    ++this.t4;
                    if (this.t4 != this.four.length) break;
                    this.t4 = 0;
                    break;
                }
                this.updateDisplay(view, '4');
                break;
            }
            case 22: {
                if (this.letters.contains(this.which)) {
                    this.updateDisplay(view, this.five[this.t5]);
                    ++this.t5;
                    if (this.t5 != this.five.length) break;
                    this.t5 = 0;
                    break;
                }
                this.updateDisplay(view, '5');
                break;
            }
            case 23: {
                if (this.letters.contains(this.which)) {
                    this.updateDisplay(view, this.six[this.t6]);
                    ++this.t6;
                    if (this.t6 != this.six.length) break;
                    this.t6 = 0;
                    break;
                }
                this.updateDisplay(view, '6');
                break;
            }
            case 25: {
                this.loadSaves(player);
                break;
            }
            case 29: {
                this.which = 2;
                this.resetTrackers();
                break;
            }
            case 30: {
                if (this.letters.contains(this.which)) {
                    this.updateDisplay(view, this.seven[this.t7]);
                    ++this.t7;
                    if (this.t7 != this.seven.length) break;
                    this.t7 = 0;
                    break;
                }
                this.updateDisplay(view, '7');
                break;
            }
            case 31: {
                if (this.letters.contains(this.which)) {
                    this.updateDisplay(view, this.eight[this.t8]);
                    ++this.t8;
                    if (this.t8 != this.eight.length) break;
                    this.t8 = 0;
                    break;
                }
                this.updateDisplay(view, '8');
                break;
            }
            case 32: {
                if (this.letters.contains(this.which)) {
                    this.updateDisplay(view, this.nine[this.t9]);
                    ++this.t9;
                    if (this.t9 != this.nine.length) break;
                    this.t9 = 0;
                    break;
                }
                this.updateDisplay(view, '9');
                break;
            }
            case 34: {
                this.message(player);
                break;
            }
            case 38: {
                this.which = 3;
                this.resetTrackers();
                break;
            }
            case 39: {
                this.updateDisplay(view, this.star[this.ts]);
                ++this.ts;
                if (this.ts != this.star.length) break;
                this.ts = 0;
                break;
            }
            case 40: {
                this.updateDisplay(view, '0');
                break;
            }
            case 41: {
                if (this.letters.contains(this.which) || this.components.getFirst().startsWith("~")) {
                    this.updateDisplay(view, this.hash[this.th]);
                    ++this.th;
                    if (this.th != this.hash.length) break;
                    this.th = 0;
                    break;
                }
                this.updateDisplay(view, '-');
                break;
            }
            case 43: {
                this.setBeacon(player);
                break;
            }
            case 45: {
                this.close(player);
                this.components = List.of("", "", "", "", "", "");
                break;
            }
            case 48: {
                if (this.pos[this.which] > 0) {
                    int n = this.which;
                    this.pos[n] = this.pos[n] - 1;
                }
                this.resetTrackers();
                break;
            }
            case 50: {
                int next = this.components.get(this.which).length() + 1;
                if (this.pos[this.which] < next) {
                    int n = this.which;
                    this.pos[n] = this.pos[n] + 1;
                }
                this.resetTrackers();
                break;
            }
            case 53: {
                switch (this.which) {
                    case 4: {
                        this.saveCurrentLocation(player, view);
                        break block0;
                    }
                    case 5: {
                        this.scanLifesigns(player, view);
                        break block0;
                    }
                }
                this.doWarp(player, view);
                break;
            }
        }
    }

    private void usePredictive(InventoryView view) {
        ItemStack is = view.getItem(6);
        ItemMeta im = is.getItemMeta();
        String world = ComponentUtils.stripColour((Component)im.lore().getFirst());
        this.components.set(0, world);
        ItemStack display = view.getItem(4);
        ItemMeta dim = display.getItemMeta();
        dim.lore(List.of(Component.text((String)(world + " " + this.components.get(1) + " " + this.components.get(2) + " " + this.components.get(3)))));
        display.setItemMeta(dim);
        this.which = 1;
    }

    private void setPredictive(String stub, InventoryView view) {
        ItemStack is = view.getItem(6);
        ItemMeta im = is.getItemMeta();
        for (World w : this.plugin.getServer().getWorlds()) {
            String world = w.getName();
            if (!w.getName().toLowerCase(Locale.ROOT).startsWith(stub)) continue;
            im.lore(List.of(Component.text((String)world)));
            is.setItemMeta(im);
            break;
        }
    }

    private void updateDisplay(InventoryView view, char s) {
        char[] chars;
        ItemStack display = view.getItem(4);
        ItemMeta dim = display.getItemMeta();
        char[] cArray = chars = this.components.get(this.which).isEmpty() ? new char[1] : this.components.get(this.which).toCharArray();
        if (this.pos[this.which] >= chars.length) {
            char[] tmp = (char[])chars.clone();
            chars = new char[this.pos[this.which] + 1];
            int i = 0;
            for (char ignored : tmp) {
                chars[i] = tmp[i];
                ++i;
            }
        }
        chars[this.pos[this.which]] = s;
        String comp = new String(chars);
        Object combined = switch (this.which) {
            case 0 -> {
                this.setPredictive(comp.toLowerCase(Locale.ROOT), view);
                yield comp + " " + this.components.get(1) + " " + this.components.get(2) + " " + this.components.get(3);
            }
            case 1 -> this.components.getFirst() + " " + comp + " " + this.components.get(2) + " " + this.components.get(3);
            case 2 -> this.components.getFirst() + " " + this.components.get(1) + " " + comp + " " + this.components.get(3);
            case 3 -> this.components.getFirst() + " " + this.components.get(1) + " " + this.components.get(2) + " " + comp;
            default -> comp;
        };
        this.components.set(this.which, comp);
        dim.lore(List.of(Component.text((String)combined)));
        display.setItemMeta(dim);
    }

    private void resetTrackers() {
        this.t2 = 0;
        this.t3 = 0;
        this.t4 = 0;
        this.t5 = 0;
        this.t6 = 0;
        this.t7 = 0;
        this.t8 = 0;
        this.t9 = 0;
        this.ts = 0;
        this.th = 0;
    }

    private void saveCurrentLocation(Player player, InventoryView view) {
        ItemStack display = view.getItem(4);
        ItemMeta dim = display.getItemMeta();
        List lore = dim.lore();
        String name = ComponentUtils.stripColour((Component)lore.getFirst());
        if (name.isEmpty()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_NEED");
            return;
        }
        Location l = player.getLocation();
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("uuid", player.getUniqueId().toString());
        set.put("save_name", ComponentUtils.stripColour((Component)lore.getFirst()));
        set.put("world", l.getWorld().getName());
        set.put("x", l.getX());
        set.put("y", l.getY());
        set.put("z", l.getZ());
        set.put("yaw", Float.valueOf(l.getYaw()));
        set.put("pitch", Float.valueOf(l.getPitch()));
        this.plugin.getQueryFactory().doInsert("saves", set);
        this.close(player);
        this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_CURRENT");
    }

    private void scanLifesigns(Player player, InventoryView view) {
        this.close(player);
        if (!TARDISPermission.hasPermission(player, "vm.lifesigns")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_PERM_LIFESIGNS");
            return;
        }
        int required = this.plugin.getVortexConfig().getInt("tachyon_use.lifesigns");
        if (!TVMUtils.checkTachyonLevel(player.getUniqueId().toString(), required)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_LIFESIGNS_TACHYON");
            return;
        }
        this.qf.alterTachyons(player.getUniqueId().toString(), -required);
        ItemStack display = view.getItem(4);
        ItemMeta dim = display.getItemMeta();
        List lore = dim.lore();
        String pname = ComponentUtils.stripColour((Component)lore.getFirst()).trim();
        if (pname.isEmpty()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "SCAN_ENTS");
            double d = this.plugin.getVortexConfig().getDouble("lifesign_scan_distance");
            List ents = player.getNearbyEntities(d, d, d);
            if (!ents.isEmpty()) {
                HashMap<EntityType, Integer> scannedentities = new HashMap<EntityType, Integer>();
                ArrayList playernames = new ArrayList();
                ents.forEach(k -> {
                    EntityType et = k.getType();
                    if (TARDISConstants.ENTITY_TYPES.contains(et)) {
                        int entity_count = scannedentities.getOrDefault(et, 0);
                        boolean visible = true;
                        if (et.equals((Object)EntityType.PLAYER)) {
                            Player entPlayer = (Player)k;
                            if (player.canSee(entPlayer)) {
                                playernames.add(entPlayer.getName());
                            } else {
                                visible = false;
                            }
                        }
                        if (visible) {
                            scannedentities.put(et, entity_count + 1);
                        }
                    }
                });
                scannedentities.forEach((key, value) -> {
                    Object message = "";
                    StringBuilder buf = new StringBuilder();
                    if (key.equals((Object)EntityType.PLAYER) && !playernames.isEmpty()) {
                        playernames.forEach(pn -> buf.append(", ").append((String)pn));
                        message = " (" + buf.substring(2) + ")";
                    }
                    player.sendMessage("    " + String.valueOf(key) + ": " + value + (String)message);
                });
                scannedentities.clear();
            } else {
                player.sendMessage("SCAN_NONE");
            }
        } else {
            Player scanned = this.plugin.getServer().getPlayer(pname);
            if (scanned == null) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "COULD_NOT_FIND_NAME");
                return;
            }
            if (!scanned.isOnline()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_NOT_ONLINE", pname);
                return;
            }
            double mh = scanned.getAttribute(Attribute.MAX_HEALTH).getValue();
            double health = scanned.getHealth() / mh * scanned.getHealthScale();
            float hunger = (float)scanned.getFoodLevel() / 20.0f * 100.0f;
            int air = scanned.getRemainingAir();
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_LIFESIGNS", pname);
            player.sendMessage("Has been alive for: " + TVMUtils.convertTicksToTime(scanned.getTicksLived()));
            player.sendMessage("Health: " + String.format("%.1f", health / 2.0) + " hearts");
            player.sendMessage("Hunger bar: " + String.format("%.2f", Float.valueOf(hunger)) + "%");
            player.sendMessage("Air: ~" + air / 20 + " seconds remaining");
        }
    }

    private void loadSaves(Player player) {
        this.close(player);
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.openInventory(new TVMSavesGUI(this.plugin, 0, 44, player.getUniqueId().toString()).getInventory()), 2L);
    }

    private void message(Player player) {
        this.close(player);
        if (!TARDISPermission.hasPermission(player, "vm.message")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_PERM_MSGS");
            return;
        }
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.openInventory(new TVMMessageGUI(this.plugin, 0, 44, player.getUniqueId().toString()).getInventory()), 2L);
    }

    private void setBeacon(Player player) {
        if (!TARDISPermission.hasPermission(player, "vm.beacon")) {
            this.close(player);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_PERM_BEACON");
            return;
        }
        UUID uuid = player.getUniqueId();
        String message = "VM_BEACON_TACHYON";
        int required = this.plugin.getVortexConfig().getInt("tachyon_use.beacon");
        if (TVMUtils.checkTachyonLevel(uuid.toString(), required)) {
            String ustr = uuid.toString();
            Location l = player.getLocation();
            ArrayList<Flag> flags = new ArrayList<Flag>();
            if (this.plugin.getConfig().getBoolean("preferences.respect_griefprevention")) {
                flags.add(Flag.RESPECT_GRIEFPREVENTION);
            }
            if (this.plugin.getConfig().getBoolean("preferences.respect_towny")) {
                flags.add(Flag.RESPECT_TOWNY);
            }
            if (this.plugin.getConfig().getBoolean("preferences.respect_worldborder")) {
                flags.add(Flag.RESPECT_WORLDBORDER);
            }
            if (this.plugin.getConfig().getBoolean("preferences.respect_worldguard")) {
                flags.add(Flag.RESPECT_WORLDGUARD);
            }
            Parameters params = new Parameters(player, flags);
            if (!this.plugin.getTardisAPI().getRespect().getRespect(l, params)) {
                this.close(player);
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_BEACON_PERMIT");
                return;
            }
            Block b = l.getBlock().getRelative(BlockFace.DOWN);
            this.qf.saveBeaconBlock(ustr, b);
            b.setBlockData(Material.BEACON.createBlockData());
            Block down = b.getRelative(BlockFace.DOWN);
            this.qf.saveBeaconBlock(ustr, down);
            BlockData iron = Material.IRON_BLOCK.createBlockData();
            down.setBlockData(iron);
            this.plugin.getGeneralKeeper().getSurrounding().forEach(f -> {
                this.qf.saveBeaconBlock(ustr, down.getRelative(f));
                down.getRelative(f).setBlockData(iron);
            });
            this.plugin.getTvmSettings().getBeaconSetters().add(uuid);
            message = "VM_BEACON_MOVE";
            this.qf.alterTachyons(player.getUniqueId().toString(), -required);
        }
        this.close(player);
        this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, message);
    }

    private void doWarp(Player player, InventoryView view) {
        Location l;
        int required;
        ItemStack display = view.getItem(4);
        ItemMeta dim = display.getItemMeta();
        List lore = dim.lore();
        String first = ComponentUtils.stripColour((Component)lore.getFirst()).trim();
        List<Object> dest = !first.isEmpty() ? List.of(first.split(" ")) : new ArrayList();
        ArrayList<String> worlds = new ArrayList<String>();
        ArrayList<Flag> flags = new ArrayList<Flag>();
        flags.add(Flag.PERMS_AREA);
        flags.add(Flag.PERMS_NETHER);
        flags.add(Flag.PERMS_THEEND);
        flags.add(Flag.PERMS_WORLD);
        if (this.plugin.getConfig().getBoolean("preferences.respect_griefprevention")) {
            flags.add(Flag.RESPECT_GRIEFPREVENTION);
        }
        if (this.plugin.getConfig().getBoolean("preferences.respect_towny")) {
            flags.add(Flag.RESPECT_TOWNY);
        }
        if (this.plugin.getConfig().getBoolean("preferences.respect_worldborder")) {
            flags.add(Flag.RESPECT_WORLDBORDER);
        }
        if (this.plugin.getConfig().getBoolean("preferences.respect_worldguard")) {
            flags.add(Flag.RESPECT_WORLDGUARD);
        }
        Parameters params = new Parameters(player, flags);
        switch (dest.size()) {
            case 1: 
            case 2: 
            case 3: {
                required = this.plugin.getVortexConfig().getInt("tachyon_use.travel.world");
                if (this.plugin.getServer().getWorld((String)dest.getFirst()) == null) {
                    this.close(player);
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_NO_WORLD");
                    return;
                }
                if (!this.plugin.getTardisAPI().getWorlds().contains(dest.getFirst())) {
                    this.close(player);
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_NO_TRAVEL");
                    return;
                }
                worlds.add((String)dest.getFirst());
                l = this.plugin.getTardisAPI().getRandomLocation(worlds, null, params);
                break;
            }
            case 4: {
                double z;
                double y;
                double x;
                World w;
                required = this.plugin.getVortexConfig().getInt("tachyon_use.travel.coords");
                if (((String)dest.getFirst()).contains("~")) {
                    w = player.getLocation().getWorld();
                } else {
                    w = this.plugin.getServer().getWorld((String)dest.getFirst());
                    if (w == null) {
                        this.close(player);
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_NO_WORLD");
                        return;
                    }
                    if (!this.plugin.getTardisAPI().getWorlds().contains(dest.getFirst())) {
                        this.close(player);
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_NO_TRAVEL");
                        return;
                    }
                }
                try {
                    if (((String)dest.get(1)).startsWith("~")) {
                        Location tl = player.getLocation();
                        double tx = tl.getX();
                        double ty = tl.getY();
                        double tz = tl.getZ();
                        x = tx + Double.parseDouble(((String)dest.get(1)).substring(1));
                        y = ty + Double.parseDouble(((String)dest.get(2)).substring(1));
                        z = tz + Double.parseDouble(((String)dest.get(3)).substring(1));
                    } else {
                        x = Double.parseDouble((String)dest.get(1));
                        y = Double.parseDouble((String)dest.get(2));
                        z = Double.parseDouble((String)dest.get(3));
                    }
                }
                catch (NumberFormatException e2) {
                    this.close(player);
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_COORDS");
                    return;
                }
                l = new Location(w, x, y, z);
                if (l.getBlock().getType().equals((Object)Material.AIR)) break;
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_ADJUST");
                int highest = l.getWorld().getHighestBlockYAt(l);
                l.setY((double)highest);
                break;
            }
            default: {
                required = this.plugin.getVortexConfig().getInt("tachyon_use.travel.random");
                l = this.plugin.getTardisAPI().getRandomLocation(this.plugin.getTardisAPI().getWorlds(), null, params);
            }
        }
        UUID uuid = player.getUniqueId();
        if (!TVMUtils.checkTachyonLevel(uuid.toString(), required)) {
            this.close(player);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_NEED_TACHYON", required);
            return;
        }
        if (l != null) {
            this.close(player);
            ArrayList<Player> players = new ArrayList<Player>();
            players.add(player);
            if (this.plugin.getVortexConfig().getBoolean("allow.multiple")) {
                player.getNearbyEntities(0.5, 0.5, 0.5).forEach(e -> {
                    if (e instanceof Player && !e.getUniqueId().equals(uuid)) {
                        players.add((Player)e);
                    }
                });
            }
            int actual = required * players.size();
            if (!TVMUtils.checkTachyonLevel(uuid.toString(), actual)) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_NEED_TACHYON", actual);
                return;
            }
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_STANDBY");
            while (!l.getChunk().isLoaded()) {
                l.getChunk().load();
            }
            TVMUtils.movePlayers(players, l, player.getLocation().getWorld());
            this.qf.alterTachyons(uuid.toString(), -actual);
        } else {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_PARAMETERS");
        }
    }
}

